/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.table.storage.designer.wizard;

import com.semarchy.xdi.component.azure.table.storage.designer.MdConverter;
import com.semarchy.xdi.component.azure.table.storage.designer.wizard.AzureBean;
import com.semarchy.xdi.component.azure.table.storage.runtime.AzureTableStorageReverser;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.provider.wizard.IBeanLinker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class BeanMdLinker
implements IBeanLinker {
    private MdNode node;
    private AzureTableStorageReverser reverser;
    private AzureBean bean = new AzureBean();

    public BeanMdLinker() {
        this.reverser = new AzureTableStorageReverser();
    }

    public void setNode(MdNode node) {
        String reverseEngineeringSampleSize;
        String connString;
        this.node = node;
        if (node.getName() != null) {
            this.bean.setName(node.getName());
        }
        if ((connString = node.getAttributeValueByShortCode("connectionString")) != null) {
            this.bean.setConnectionString(connString);
        }
        if ((reverseEngineeringSampleSize = node.getAttributeValueByShortCode("reverseEngineeringSampleSize")) != null) {
            this.bean.setReverseEngineeringSampleSize(Integer.valueOf(reverseEngineeringSampleSize));
        }
        HashMap<String, Map<String, String>> tables = new HashMap<String, Map<String, String>>();
        for (MdNode tableNode : node.getNodeByCode("com.stambia.azure.table.table")) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (MdNode propNode : tableNode.getNodeByCode("com.stambia.azure.table.property")) {
                String type = propNode.getAttributeValueByShortCode("type");
                properties.put(propNode.getName(), type);
            }
            tables.put(tableNode.getName(), properties);
        }
        this.bean.setTables(tables);
    }

    public MdNode updateMdNode() throws Exception {
        MdNode newNode = this.getNewNode();
        HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
        this.reverseFromMdNode(newNode, reversedMap);
        return newNode;
    }

    public void reverseFromMdNode(MdNode newNode, Map<MdNode, MdNode> reversedMap) throws ReverseException {
        reversedMap.put(newNode, this.node);
        Attribute attr = newNode.getAttributeByShortCode("name");
        newNode.getAttribute().remove((Object)attr);
        IncrementalReverser ir = new IncrementalReverser(this.node.eContainer(), reversedMap, new ArrayList(), true, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, Collections.emptyMap(), true);
        ir.reverse();
    }

    public AzureBean getBean() {
        return this.bean;
    }

    public MdNode getNewNode() {
        MdNode newNode = this.node.copy(0);
        newNode.setName(this.bean.getName());
        MdNode dummyNode = MdFactoryHelper.createMdNode((String)"dummy");
        dummyNode.setSubstituteContainer((EObject)this.node);
        newNode.setSubstituteContainer((EObject)dummyNode);
        newNode.setAttribute("name", this.bean.getName(), false);
        newNode.setAttribute("connectionString", this.bean.getConnectionString(), false);
        newNode.setAttribute("reverseEngineeringSampleSize", String.valueOf(this.bean.getReverseEngineeringSampleSize()), false);
        for (Map.Entry<String, Map<String, String>> entry : this.bean.getTables().entrySet()) {
            MdNode tableNode = MdConverter.createTableNode(newNode, entry.getKey(), entry.getValue());
            newNode.getNode().add((Object)tableNode);
        }
        return newNode;
    }

    public void reverseTableProperties() {
        for (String tableName : this.bean.getCheckedTables()) {
            Map tableProps = this.reverser.getTableProperties(tableName, this.bean.getReverseEngineeringSampleSize().intValue());
            this.bean.getTables().put(tableName, tableProps);
        }
    }

    public void reverseTables() {
        this.reverser.initServiceClient(this.bean.getConnectionString());
        Set tables = this.reverser.getTables();
        HashMap<String, Map<String, String>> tablesMap = new HashMap<String, Map<String, String>>();
        for (String table : tables) {
            tablesMap.put(table, Collections.emptyMap());
        }
        this.bean.setTables(tablesMap);
    }
}

