/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.parquet;

import com.indy.addons.parquet.Messages;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdFactoryHelper;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.TypeVisitor;
import org.eclipse.emf.ecore.EObject;

public final class ParquetTypeVisitor
implements TypeVisitor,
LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Object> {
    private final Deque<MdNode> stambiaNodes = new ArrayDeque<MdNode>();
    private final Deque<String> stambiaLogicalNodeNames = new ArrayDeque<String>();
    private final MdNode newSchemaNode;
    private boolean createNewNode;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final MdNode originalSchemaNode;

    public ParquetTypeVisitor(MdNode newSchemaNode, MdNode originalSchemaNode) {
        this.newSchemaNode = newSchemaNode;
        this.originalSchemaNode = originalSchemaNode;
    }

    private final void reverseGroupType(GroupType groupType, String stambiaNodeType, boolean isSchemaNode) {
        if (groupType != null) {
            String name = groupType.getName();
            LogicalTypeAnnotation logicalType = groupType.getLogicalTypeAnnotation();
            boolean primitive = groupType.isPrimitive();
            Type.Repetition repetition = groupType.getRepetition();
            Type.ID id = groupType.getId();
            String debugMessage = "GroupType\tname:" + name + "\tlogicalType:" + logicalType + "\tprimitive:" + "\trepetition:" + repetition + "\tid:" + id;
            this.logger.debug(debugMessage);
            MdNode currentStambiaNode = isSchemaNode ? this.newSchemaNode : this.createNamedStambiaNode(name, stambiaNodeType);
            if (primitive) {
                PrimitiveType primitiveType = groupType.asPrimitiveType();
                this.addPrimitiveType(currentStambiaNode, primitiveType);
            } else {
                try {
                    this.addPrimitiveType(currentStambiaNode, "Group");
                }
                catch (XPathExpressionException exception) {
                    this.logger.warn("unexpected", (Throwable)exception);
                }
            }
            try {
                this.addLogicalType(currentStambiaNode, logicalType);
            }
            catch (XPathExpressionException exception) {
                this.logger.warn("unexpected", (Throwable)exception);
            }
            ParquetTypeVisitor.addPhysicalName(currentStambiaNode, name);
            ParquetTypeVisitor.addRepetition(currentStambiaNode, repetition);
            ParquetTypeVisitor.addId(currentStambiaNode, id);
            List fields = groupType.getFields();
            try {
                this.addFields(currentStambiaNode, fields);
            }
            catch (XPathExpressionException exception) {
                this.logger.warn("unexpected", (Throwable)exception);
            }
        }
    }

    public final void visit(GroupType groupType) {
        this.logger.debug("GroupType");
        this.reverseGroupType(groupType, "com.stambia.parquet.field", false);
    }

    public final void visit(MessageType messageType) {
        this.logger.debug(Messages.ParquetTypeVisitor_8);
        MessageType groupType = messageType;
        this.reverseGroupType((GroupType)groupType, "com.stambia.parquet.schema", true);
    }

    public final void visit(PrimitiveType primitiveType) {
        if (primitiveType != null) {
            String name = primitiveType.getName();
            int physicalLength = primitiveType.getTypeLength();
            PrimitiveType.PrimitiveTypeName primitiveTypeName = primitiveType.getPrimitiveTypeName();
            LogicalTypeAnnotation logicalType = primitiveType.getLogicalTypeAnnotation();
            Type.Repetition repetition = primitiveType.getRepetition();
            Type.ID id = primitiveType.getId();
            String debugMessage = "PrimitiveType\tname:" + name + "\tphysicalLength:" + physicalLength + "\tprimitiveTypeName:" + primitiveTypeName + "\tlogicalType:" + logicalType + "\trepetition:" + repetition + "\tid:" + id;
            this.logger.debug(debugMessage);
            String parquetPrimitiveTypeName = switch (primitiveTypeName) {
                case PrimitiveType.PrimitiveTypeName.INT64 -> "Integer 64-bits";
                case PrimitiveType.PrimitiveTypeName.INT32 -> "Integer 32-bits";
                case PrimitiveType.PrimitiveTypeName.BOOLEAN -> "Boolean";
                case PrimitiveType.PrimitiveTypeName.BINARY -> "Binary";
                case PrimitiveType.PrimitiveTypeName.FLOAT -> "Float";
                case PrimitiveType.PrimitiveTypeName.DOUBLE -> "Double";
                case PrimitiveType.PrimitiveTypeName.INT96 -> "Integer 96-bits";
                case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> "Fixed Length Byte Array";
                default -> throw new RuntimeException(Messages.ParquetTypeVisitor_0 + String.valueOf(primitiveTypeName));
            };
            MdNode stambiaFieldNode = this.stambiaNodes.getLast();
            try {
                this.addPrimitiveType(stambiaFieldNode, parquetPrimitiveTypeName);
                this.addLogicalType(stambiaFieldNode, logicalType);
            }
            catch (XPathExpressionException exception) {
                this.logger.warn("unexpected", (Throwable)exception);
            }
            stambiaFieldNode.setName(name);
            ParquetTypeVisitor.addPhysicalName(stambiaFieldNode, name);
            ParquetTypeVisitor.addPhysicalLength(stambiaFieldNode, physicalLength);
            ParquetTypeVisitor.addRepetition(stambiaFieldNode, repetition);
            ParquetTypeVisitor.addId(stambiaFieldNode, id);
        }
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
        this.logger.debug("BsonLogicalTypeAnnotation");
        this.stambiaLogicalNodeNames.add("Bson");
        return super.visit(bsonLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
        this.logger.debug("DateLogicalTypeAnnotation");
        this.stambiaLogicalNodeNames.add("Date");
        return super.visit(dateLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
        if (decimalLogicalType != null) {
            int precision = decimalLogicalType.getPrecision();
            int scale = decimalLogicalType.getScale();
            String debugMessage = "DecimalLogicalTypeAnnotation\tprecision:" + precision + "\tscale:" + scale;
            this.logger.debug(debugMessage);
            MdNode stambiaFieldNode = this.stambiaNodes.getLast();
            ParquetTypeVisitor.addLength(stambiaFieldNode, precision);
            ParquetTypeVisitor.addScale(stambiaFieldNode, scale);
            this.stambiaLogicalNodeNames.add("Decimal");
        }
        return super.visit(decimalLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
        this.logger.debug("EnumLogicalTypeAnnotation");
        this.stambiaLogicalNodeNames.add("Enum");
        return super.visit(enumLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalType) {
        this.logger.debug("IntervalLogicalTypeAnnotation");
        this.stambiaLogicalNodeNames.add("Enum");
        return super.visit(intervalLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
        if (intLogicalType != null) {
            int bitWidth = intLogicalType.getBitWidth();
            boolean signed = intLogicalType.isSigned();
            String debugMessage = "IntLogicalTypeAnnotation\tbitWidth:" + bitWidth + "\tsigned:" + signed;
            this.logger.debug(debugMessage);
            String logicalTypeName = (signed ? "S" : "Uns") + "igned Integer " + bitWidth + "-bits";
            this.stambiaLogicalNodeNames.add(logicalTypeName);
        }
        return super.visit(intLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
        this.logger.debug("JsonLogicalTypeAnnotation");
        this.stambiaLogicalNodeNames.add("Json");
        return super.visit(jsonLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
        this.logger.debug("ListLogicalTypeAnnotation");
        this.stambiaLogicalNodeNames.add("List");
        return super.visit(listLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.MapKeyValueTypeAnnotation mapKeyValueLogicalType) {
        this.logger.debug("MapKeyValueTypeAnnotation");
        this.stambiaLogicalNodeNames.add("Map Key Value");
        this.createNewNode = true;
        return super.visit(mapKeyValueLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
        this.logger.debug("MapLogicalTypeAnnotation");
        this.stambiaLogicalNodeNames.add("Map");
        return super.visit(mapLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
        this.logger.debug("StringLogicalTypeAnnotation");
        this.stambiaLogicalNodeNames.add("String");
        return super.visit(stringLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
        if (timeLogicalType != null) {
            LogicalTypeAnnotation.TimeUnit unit = timeLogicalType.getUnit();
            boolean adjustedToUTC = timeLogicalType.isAdjustedToUTC();
            String debugMessage = "TimeLogicalTypeAnnotation\tunit:" + unit + "\tadjustedToUTC:" + adjustedToUTC;
            this.logger.debug(debugMessage);
            String timeUnit = ParquetTypeVisitor.getTimeUnit(unit, adjustedToUTC);
            String logicalTypeName = "Time" + timeUnit;
            this.stambiaLogicalNodeNames.add(logicalTypeName);
        }
        return super.visit(timeLogicalType);
    }

    public final Optional<Object> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
        if (timestampLogicalType != null) {
            LogicalTypeAnnotation.TimeUnit unit = timestampLogicalType.getUnit();
            boolean adjustedToUTC = timestampLogicalType.isAdjustedToUTC();
            String debugMessage = "TimestampLogicalTypeAnnotation\tunit:" + unit + "\tadjustedToUTC:" + adjustedToUTC;
            this.logger.debug(debugMessage);
            String timeUnit = ParquetTypeVisitor.getTimeUnit(unit, adjustedToUTC);
            String logicalTypeName = "Timestamp" + timeUnit;
            this.stambiaLogicalNodeNames.add(logicalTypeName);
        }
        return super.visit(timestampLogicalType);
    }

    private static final String getTimeUnit(LogicalTypeAnnotation.TimeUnit unit, boolean adjustedToUTC) {
        String timeUnit = " with " + (switch (unit) {
            case LogicalTypeAnnotation.TimeUnit.MILLIS -> "Milli";
            case LogicalTypeAnnotation.TimeUnit.MICROS -> "Micro";
            case LogicalTypeAnnotation.TimeUnit.NANOS -> "Nano";
            default -> throw new RuntimeException(Messages.ParquetTypeVisitor_1 + String.valueOf(unit));
        }) + "second precision" + (adjustedToUTC ? " (UTC)" : "");
        return timeUnit;
    }

    private final MdNode createNamedStambiaNode(String currentNodeName, String currentNodeType) {
        MdNode stambiaNode = this.createUnamedStambiaNode(currentNodeType);
        stambiaNode.setName(currentNodeName);
        return stambiaNode;
    }

    private final MdNode createUnamedStambiaNode(String currentNodeType) {
        MdNode stambiaCurrentNode = MdFactoryHelper.createMdNode((String)currentNodeType);
        MdNode parentStambiaNode = this.stambiaNodes.getLast();
        if (parentStambiaNode != null) {
            parentStambiaNode.getNode().add((Object)stambiaCurrentNode);
        }
        return stambiaCurrentNode;
    }

    private final void addFields(MdNode stambiaNode, List<Type> fields) throws XPathExpressionException {
        if (fields != null && fields.size() > 0) {
            this.stambiaNodes.add(stambiaNode);
            for (Type field : fields) {
                boolean createSubNode;
                boolean bl = createSubNode = this.createNewNode || field.isPrimitive();
                if (createSubNode) {
                    MdNode currentStambiaNode = this.createUnamedStambiaNode("com.stambia.parquet.field");
                    this.stambiaNodes.add(currentStambiaNode);
                }
                if (field != null) {
                    field.accept((TypeVisitor)this);
                }
                if (!createSubNode) continue;
                this.stambiaNodes.removeLast();
                this.createNewNode = false;
            }
            this.stambiaNodes.removeLast();
        }
    }

    private final void addLogicalType(MdNode stambiaNode, LogicalTypeAnnotation logicalType) throws XPathExpressionException {
        MdNode logicalReference = null;
        if (stambiaNode != null && logicalType != null) {
            logicalType.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)this);
            String logicalTypeName = this.stambiaLogicalNodeNames.removeLast();
            String logicalExpression = "ancestor::product/logicalType[@name='" + logicalTypeName + "']";
            logicalReference = (MdNode)this.originalSchemaNode.evaluateMdNode(logicalExpression);
            if (logicalReference == null) {
                throw new RuntimeException(String.format(Messages.ParquetTypeVisitor_unkownLogicalType, logicalTypeName));
            }
            stambiaNode.setRefAttribute("logicalType", (EObject)logicalReference, false);
        }
    }

    private final void addPrimitiveType(MdNode stambiaNode, String primitiveTypeName) throws XPathExpressionException {
        MdNode primitiveReference = null;
        if (stambiaNode != null && primitiveTypeName != null) {
            String primitiveExpression = "ancestor::product/type[@name='" + primitiveTypeName + "']";
            primitiveReference = (MdNode)this.originalSchemaNode.evaluateMdNode(primitiveExpression);
            if (primitiveReference == null) {
                throw new RuntimeException(String.format(Messages.ParquetTypeVisitor_unknownPrimitive, primitiveTypeName));
            }
            stambiaNode.setRefAttribute("type", (EObject)primitiveReference, false);
        }
    }

    private final void addPrimitiveType(MdNode stambiaNode, PrimitiveType primitiveType) {
        if (primitiveType != null) {
            primitiveType.accept((TypeVisitor)this);
        }
    }

    private static final void addRepetition(MdNode stambiaNode, Type.Repetition repetition) {
        if (repetition != null) {
            String repetitionName = repetition.name();
            ParquetTypeVisitor.setAttribute(stambiaNode, "repetition", repetitionName);
        }
    }

    private static final void addId(MdNode stambiaNode, Type.ID id) {
        if (id != null) {
            int idValue = id.intValue();
            ParquetTypeVisitor.setAttribute(stambiaNode, "parquetId", idValue);
        }
    }

    private static final void addPhysicalName(MdNode stambiaNode, String physicalName) {
        ParquetTypeVisitor.setAttribute(stambiaNode, "physicalName", physicalName);
    }

    private static final void addPhysicalLength(MdNode stambiaNode, int physicalLength) {
        if (physicalLength > 0) {
            ParquetTypeVisitor.setAttribute(stambiaNode, "physicalLength", physicalLength);
        }
    }

    private static final void addLength(MdNode stambiaNode, int precision) {
        ParquetTypeVisitor.setAttribute(stambiaNode, "length", precision);
    }

    private static final void addScale(MdNode stambiaNode, int scale) {
        ParquetTypeVisitor.setAttribute(stambiaNode, "scale", scale);
    }

    private static final void setAttribute(MdNode node, String name, int value) {
        String stringValue = String.valueOf(value);
        ParquetTypeVisitor.setAttribute(node, name, stringValue);
    }

    private static final void setAttribute(MdNode node, String name, String value) {
        if (node != null) {
            node.setAttribute(name, value, false);
        }
    }
}

