/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.rdbms.cassandra.wizard;

import com.indy.addons.rdbms.cassandra.reverse.Reverser;
import com.indy.addons.rdbms.cassandra.wizard.Bean;
import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.util.ModuleJDBCHelper;
import com.semarchy.xdi.designer.core.services.IBaseModuleProvider;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Controller {
    private final Logger logger = LoggerFactory.getLogger(Controller.class);
    private NodesHelper nodesHelper;
    private Bean bean;
    private MdNode node;
    private Reverser reverser;
    private boolean connected = false;
    private ModuleJDBCHelper jdbcHelper = new ModuleJDBCHelper((IBaseModuleProvider)PlatformUI.getWorkbench().getService(IBaseModuleProvider.class), (IModuleService)PlatformUI.getWorkbench().getService(IModuleService.class));

    public Controller(MdNode node) {
        this.node = node;
        this.reverser = new Reverser(node);
    }

    public void loadBean() {
        try {
            this.bean.setName(this.node.getName());
            this.bean.setNodes(MdAttributeReader.readAttribute((String)"nodes", (MdNode)this.node));
            this.bean.setDatacenter(MdAttributeReader.readAttribute((String)"physicalName", (MdNode)this.node));
            this.bean.setModule(MdAttributeReader.readAttribute((String)"module", (MdNode)this.node));
            this.bean.setUsername(MdAttributeReader.readAttribute((String)"user", (MdNode)this.node));
            this.bean.setPassword(MdAttributeReader.readAttribute((String)"password", (MdNode)this.node));
            this.bean.getModuleFilters().add("com.indy.baseModule.default");
            this.bean.getModuleFilters().add("com.indy.baseModule.generic");
            Collection s = (Collection)this.node.evaluateXpathExpressionCached("INTERNAL_BASE_MODULE");
            if (s != null && !s.isEmpty()) {
                this.bean.getModuleFilters().addAll(s);
            }
            HashSet r = new HashSet();
            this.jdbcHelper.refreshModules(this.bean.getModuleFilters());
            for (ModuleJDBCHelper.ModuleDescription m : this.jdbcHelper.getModules()) {
                if (!m.getName().equals(this.bean.getModule())) continue;
                m.getJDBCProviders().forEach(j -> {
                    boolean bl = r.add(j.getDriverClassName());
                });
                break;
            }
            ArrayList l = new ArrayList(r);
            Collections.sort(l);
        }
        catch (MdAttributeReader.UnknownTechPropertyException | XPathExpressionException e) {
            this.logger.warn("Unable to load bean", e);
        }
        this.nodesHelper = new NodesHelper();
    }

    public Bean getBean() {
        return this.bean;
    }

    public MdNode getNode() {
        return this.node;
    }

    public NodesHelper getNodeHelper() {
        return this.nodesHelper;
    }

    public List<String> getModuleNames() {
        this.jdbcHelper.refreshModules(this.bean.getModuleFilters());
        ArrayList<String> modules = new ArrayList<String>();
        for (ModuleJDBCHelper.ModuleDescription m : this.jdbcHelper.getModules()) {
            modules.add(m.getName());
        }
        return modules;
    }

    public List<String> getDriverNames() {
        HashSet r = new HashSet();
        for (ModuleJDBCHelper.ModuleDescription m : this.jdbcHelper.getModules()) {
            if (!m.getName().equals(this.bean.getModule())) continue;
            m.getJDBCProviders().forEach(j -> {
                boolean bl = r.add(j.getDriverClassName());
            });
            break;
        }
        ArrayList<String> l = new ArrayList<String>(r);
        Collections.sort(l);
        return l;
    }

    public void setBean(Bean bean) {
        this.bean = bean;
    }

    public void connect() {
        this.connected = false;
        this.reverser.connect(this.bean.getNodes(), this.bean.getDatacenter(), this.bean.getUsername(), this.bean.getPassword());
        this.connected = true;
    }

    public void disconnect() {
        this.connected = false;
        this.reverser.disconnect();
    }

    public Reverser getReverser() {
        return this.reverser;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public MdNode createReversedMdNode() {
        MdNode server = this.getReverser().createNewServerNode(this.getBean().getName(), this.getBean().getNodes(), this.getBean().getModule(), this.getBean().getDatacenter(), this.getBean().getUsername(), this.getBean().getPassword(), this.getBean().getKeyspace());
        List<MdNode> datastores = this.getReverser().createNewDatastoreNodes(this.getBean().getKeyspace(), this.getBean().getDatastores());
        ((MdNode)server.getNode().get(0)).getNode().addAll(datastores);
        return server;
    }

    public class NodeInfo {
        String hostName = "";
        String port = "";

        public String toString() {
            StringBuilder res = new StringBuilder(this.hostName);
            if (!this.port.isEmpty()) {
                res.append(":").append(this.port);
            }
            return res.toString();
        }
    }

    public class NodesHelper {
        List<NodeInfo> nodes = new ArrayList<NodeInfo>();

        NodesHelper() {
            this.parseBeanNodes();
        }

        private void parseBeanNodes() {
            ArrayList<String> list1 = new ArrayList<String>(Arrays.asList(Controller.this.bean.getNodes().split(",")));
            for (String item : list1) {
                NodeInfo n = new NodeInfo();
                this.nodes.add(n);
                if (item.indexOf(":") > -1) {
                    n.hostName = item.substring(0, item.indexOf(":"));
                    n.port = item.substring(item.indexOf(":") + 1);
                    continue;
                }
                n.hostName = item;
            }
        }

        private void updateBean() {
            StringBuilder b = new StringBuilder();
            IntStream.range(0, this.nodes.size()).forEach(i -> {
                StringBuilder stringBuilder2 = b.append(String.format("%s%s%s%s", i != 0 ? "," : "", this.nodes.get((int)i).hostName, this.nodes.get((int)i).port.isEmpty() ? "" : ":", this.nodes.get((int)i).port));
            });
            Controller.this.getBean().setNodes(b.toString());
        }

        public List<NodeInfo> getNodes() {
            return this.nodes;
        }

        public void handleNodeUpdate() {
            this.updateBean();
        }

        public NodeInfo addNode() {
            NodeInfo i = new NodeInfo();
            i.hostName = "localhost";
            i.port = "";
            this.nodes.add(i);
            this.updateBean();
            return i;
        }

        public void removeNode(NodeInfo i) {
            this.nodes.remove(i);
            this.updateBean();
        }
    }
}

