/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.salesforce.core;

import com.indy.addons.salesforce.core.ISalesForceConnection;
import com.indy.addons.salesforce.core.SFEntity;
import com.indy.addons.salesforce.core.SFField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SFMetaData {
    private Map<String, SFEntity> entities = new TreeMap<String, SFEntity>();
    private Map<SFEntity, List<SFField>> fields = new HashMap<SFEntity, List<SFField>>();
    private Map<SFEntity, List<SFEntity>> children = new HashMap<SFEntity, List<SFEntity>>();
    private ISalesForceConnection connection;

    public SFMetaData(ISalesForceConnection connection) throws Exception {
        this.connection = connection;
        this.loadEntities();
    }

    private void loadEntities() throws Exception {
        for (SFEntity e : this.connection.listAvailableObjects(true)) {
            this.entities.put(e.getName(), e);
        }
    }

    public List<SFEntity> getEntities() {
        return new ArrayList<SFEntity>(this.entities.values());
    }

    public List<String> getEntitiesNames() {
        return new ArrayList<String>(this.entities.keySet());
    }

    public SFEntity getEntity(String name) {
        return this.entities.get(name);
    }

    public SFField getField(String entity, String field) throws Exception {
        for (SFField f : this.getFields(entity)) {
            if (!f.getName().equals(field)) continue;
            return f;
        }
        return null;
    }

    public List<SFField> getFields(String entityName) throws Exception {
        SFEntity entity = this.entities.get(entityName);
        if (entity == null) {
            throw new Exception("The entity " + entityName + " does not exists.");
        }
        List fieldsList = this.fields.computeIfAbsent(entity, ke -> {
            try {
                List<SFField> localFields = this.connection.loadEntityFields(ke.getName());
                for (SFField f : localFields) {
                    for (String s : f.getReferences()) {
                        SFEntity e = this.entities.get(s);
                        this.children.computeIfAbsent(e, k -> new ArrayList()).add(entity);
                    }
                }
                return localFields;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        this.fields.put(entity, fieldsList);
        return new ArrayList<SFField>(fieldsList);
    }

    public Map<String, List<SFField>> getFields(List<String> entityNames) throws Exception {
        HashMap<String, List<SFField>> map = new HashMap<String, List<SFField>>();
        ArrayList<String> toLoad = new ArrayList<String>();
        for (String k : entityNames) {
            if (!this.entities.containsKey(k)) continue;
            List<SFField> localFields = this.fields.get(this.entities.get(k));
            if (localFields == null) {
                toLoad.add(k);
                continue;
            }
            map.put(k, localFields);
        }
        Map<String, List<SFField>> currentMap = this.connection.loadEntityFields(toLoad);
        for (Map.Entry<String, List<SFField>> e : currentMap.entrySet()) {
            map.put(e.getKey(), e.getValue());
            this.fields.put(this.getEntity(e.getKey()), e.getValue());
        }
        return map;
    }

    public void dispose() {
        this.entities.clear();
        this.fields.clear();
        this.children.clear();
        this.connection = null;
    }
}

