/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class NTLMAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(NTLMAuthenticationProvider.class);
    private static final OpenCMISAuthenticator AUTHENTICATOR = new OpenCMISAuthenticator();

    static {
        Authenticator.setDefault(AUTHENTICATOR);
    }

    @Override
    public void setSession(BindingSession session) {
        super.setSession(session);
        LOG.warn("Use NTLM only for testing! Choose a different authentication method in production.");
    }

    @Override
    public Map<String, List<String>> getHTTPHeaders(String url) {
        return null;
    }

    @Override
    public Element getSOAPHeaders(Object portObject) {
        return null;
    }

    static class OpenCMISAuthenticator
    extends Authenticator {
        private PasswordAuthentication passwordAuthentication;

        OpenCMISAuthenticator() {
        }

        public synchronized void resetUser() {
            this.passwordAuthentication = null;
        }

        public synchronized void setPasswordAuthentication(String user, String password) {
            this.passwordAuthentication = new PasswordAuthentication(user, password.toCharArray());
        }

        @Override
        protected synchronized PasswordAuthentication getPasswordAuthentication() {
            return this.passwordAuthentication;
        }
    }
}

