/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.bindings.cache.Cache;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.CacheImpl;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.ContentTypeCacheLevelImpl;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.LruCacheLevelImpl;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.MapCacheLevelImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class LinkCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Set<String> KNOWN_LINKS = new HashSet<String>();
    private final Cache linkCache;
    private final Cache typeLinkCache;
    private final Cache collectionLinkCache;
    private final Cache templateCache;
    private final Cache repositoryLinkCache;

    static {
        KNOWN_LINKS.add("http://docs.oasis-open.org/ns/cmis/link/200908/acl");
        KNOWN_LINKS.add("down");
        KNOWN_LINKS.add("up");
        KNOWN_LINKS.add("http://docs.oasis-open.org/ns/cmis/link/200908/foldertree");
        KNOWN_LINKS.add("http://docs.oasis-open.org/ns/cmis/link/200908/relationships");
        KNOWN_LINKS.add("self");
        KNOWN_LINKS.add("http://docs.oasis-open.org/ns/cmis/link/200908/allowableactions");
        KNOWN_LINKS.add("edit-media");
        KNOWN_LINKS.add("http://docs.oasis-open.org/ns/cmis/link/200908/policies");
        KNOWN_LINKS.add("version-history");
        KNOWN_LINKS.add("working-copy");
        KNOWN_LINKS.add("@@content@@");
    }

    public LinkCache(BindingSession session) {
        int objCount;
        int typeCount;
        int repCount = session.get("org.apache.chemistry.opencmis.binding.cache.repositories.size", 10);
        if (repCount < 1) {
            repCount = 10;
        }
        if ((typeCount = session.get("org.apache.chemistry.opencmis.binding.cache.types.size", 100)) < 1) {
            typeCount = 100;
        }
        if ((objCount = session.get("org.apache.chemistry.opencmis.binding.cache.links.size", 400)) < 1) {
            objCount = 400;
        }
        this.linkCache = new CacheImpl("Link Cache");
        this.linkCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " capacity=" + repCount, LruCacheLevelImpl.class.getName() + " maxEntries=" + objCount, MapCacheLevelImpl.class.getName() + " capacity=12", ContentTypeCacheLevelImpl.class.getName() + " capacity=3,singleValue=true"});
        this.typeLinkCache = new CacheImpl("Type Link Cache");
        this.typeLinkCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " capacity=" + repCount, LruCacheLevelImpl.class.getName() + " maxEntries=" + typeCount, MapCacheLevelImpl.class.getName() + " capacity=12", ContentTypeCacheLevelImpl.class.getName() + " capacity=3,singleValue=true"});
        this.collectionLinkCache = new CacheImpl("Collection Link Cache");
        this.collectionLinkCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " capacity=" + repCount, MapCacheLevelImpl.class.getName() + " capacity=8"});
        this.templateCache = new CacheImpl("URI Template Cache");
        this.templateCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " capacity=" + repCount, MapCacheLevelImpl.class.getName() + " capacity=6"});
        this.repositoryLinkCache = new CacheImpl("Repository Link Cache");
        this.repositoryLinkCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " capacity=" + repCount, MapCacheLevelImpl.class.getName() + " capacity=6"});
    }

    public void addLink(String repositoryId, String id, String rel, String type, String link) {
        String streamId;
        if (KNOWN_LINKS.contains(rel)) {
            this.linkCache.put(link, repositoryId, id, rel, type);
        } else if ("alternate".equals(rel) && (streamId = this.extractStreamId(link)) != null) {
            this.linkCache.put(link, repositoryId, id, rel, streamId);
        }
    }

    protected String extractStreamId(String link) {
        int i = link.lastIndexOf(63);
        if (i > 0) {
            String[] params;
            String[] stringArray = params = link.substring(i + 1).split("&");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] parts = param.split("=", 2);
                if (parts[0].equals("streamId") && parts.length == 2) {
                    return parts[1];
                }
                ++n2;
            }
        }
        return null;
    }

    public void removeLinks(String repositoryId, String id) {
        this.linkCache.remove(repositoryId, id);
    }

    public String getLink(String repositoryId, String id, String rel, String type) {
        return (String)this.linkCache.get(repositoryId, id, rel, type);
    }

    public String getLink(String repositoryId, String id, String rel) {
        return this.getLink(repositoryId, id, rel, null);
    }

    public int checkLink(String repositoryId, String id, String rel, String type) {
        return this.linkCache.check(repositoryId, id, rel, type);
    }

    public void lockLinks() {
        this.linkCache.writeLock();
    }

    public void unlockLinks() {
        this.linkCache.writeUnlock();
    }

    public void addTypeLink(String repositoryId, String id, String rel, String type, String link) {
        if (KNOWN_LINKS.contains(rel)) {
            this.typeLinkCache.put(link, repositoryId, id, rel, type);
        }
    }

    public void removeTypeLinks(String repositoryId, String id) {
        this.typeLinkCache.remove(repositoryId, id);
    }

    public String getTypeLink(String repositoryId, String id, String rel, String type) {
        return (String)this.typeLinkCache.get(repositoryId, id, rel, type);
    }

    public void lockTypeLinks() {
        this.typeLinkCache.writeLock();
    }

    public void unlockTypeLinks() {
        this.typeLinkCache.writeUnlock();
    }

    public void addCollection(String repositoryId, String collection, String link) {
        this.collectionLinkCache.put(link, repositoryId, collection);
    }

    public String getCollection(String repositoryId, String collection) {
        return (String)this.collectionLinkCache.get(repositoryId, collection);
    }

    public void addTemplate(String repositoryId, String type, String link) {
        this.templateCache.put(link, repositoryId, type);
    }

    public String getTemplateLink(String repositoryId, String type, Map<String, Object> parameters) {
        String template = (String)this.templateCache.get(repositoryId, type);
        if (template == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(128);
        StringBuilder param = new StringBuilder(32);
        boolean paramMode = false;
        int i = 0;
        while (i < template.length()) {
            char c = template.charAt(i);
            if (paramMode) {
                if (c == '}') {
                    paramMode = false;
                    String paramValue = UrlBuilder.normalizeParameter(parameters.get(param.toString()));
                    if (paramValue != null) {
                        result.append(IOUtils.encodeURL(paramValue));
                    }
                    param.setLength(0);
                } else {
                    param.append(c);
                }
            } else if (c == '{') {
                paramMode = true;
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public void addRepositoryLink(String repositoryId, String rel, String link) {
        this.repositoryLinkCache.put(link, repositoryId, rel);
    }

    public String getRepositoryLink(String repositoryId, String rel) {
        return (String)this.repositoryLinkCache.get(repositoryId, rel);
    }

    public void clearRepository(String repositoryId) {
        this.linkCache.remove(repositoryId);
        this.typeLinkCache.remove(repositoryId);
        this.collectionLinkCache.remove(repositoryId);
        this.templateCache.remove(repositoryId);
        this.repositoryLinkCache.remove(repositoryId);
    }

    public String toString() {
        return "Link Cache [link cache=" + String.valueOf(this.linkCache) + ", type link cache=" + String.valueOf(this.typeLinkCache) + ", collection link cache=" + String.valueOf(this.collectionLinkCache) + ", repository link cache=" + String.valueOf(this.repositoryLinkCache) + ",  template cache=" + String.valueOf(this.templateCache) + "]";
    }
}

