/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.AbstractApacheClientHttpInvoker;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpInetSocketAddress;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class ApacheClientHttpInvoker
extends AbstractApacheClientHttpInvoker {
    @Override
    protected DefaultHttpClient createHttpClient(UrlBuilder url, BindingSession session) {
        HttpParams params = this.createDefaultHttpParams(session);
        params.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)this.getSSLSocketFactory(url, session)));
        PoolingClientConnectionManager connManager = new PoolingClientConnectionManager(registry);
        String keepAliveStr = System.getProperty("http.keepAlive", "true");
        if ("true".equalsIgnoreCase(keepAliveStr)) {
            String maxConnStr = System.getProperty("http.maxConnections", "5");
            int maxConn = 5;
            try {
                maxConn = Integer.parseInt(maxConnStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            connManager.setDefaultMaxPerRoute(maxConn);
            connManager.setMaxTotal(4 * maxConn);
        }
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(registry, null);
        DefaultHttpClient httpclient = new DefaultHttpClient((ClientConnectionManager)connManager, params);
        httpclient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        return httpclient;
    }

    private SchemeLayeredSocketFactory getSSLSocketFactory(UrlBuilder url, BindingSession session) {
        Object hv;
        AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(session);
        final SSLSocketFactory sf = authProvider.getSSLSocketFactory();
        if (sf == null) {
            return org.apache.http.conn.ssl.SSLSocketFactory.getSocketFactory();
        }
        Object object = hv = authProvider.getHostnameVerifier() == null ? new BrowserCompatHostnameVerifier() : authProvider.getHostnameVerifier();
        if (hv instanceof X509HostnameVerifier) {
            return new org.apache.http.conn.ssl.SSLSocketFactory(sf, (X509HostnameVerifier)hv);
        }
        return new SchemeLayeredSocketFactory((HostnameVerifier)hv){
            private final /* synthetic */ HostnameVerifier val$hv;
            {
                this.val$hv = hostnameVerifier;
            }

            public boolean isSecure(Socket sock) {
                return true;
            }

            public Socket createSocket(HttpParams params) throws IOException {
                return sf.createSocket();
            }

            public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException {
                SSLSocket sslSocket;
                Socket sock;
                Socket socket2 = sock = socket != null ? socket : this.createSocket(params);
                if (localAddress != null) {
                    sock.setReuseAddress(HttpConnectionParams.getSoReuseaddr((HttpParams)params));
                    sock.bind(localAddress);
                }
                int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
                int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
                try {
                    sock.setSoTimeout(soTimeout);
                    sock.connect(remoteAddress, connTimeout);
                }
                catch (SocketTimeoutException ex) {
                    ApacheClientHttpInvoker.this.closeSocket(sock);
                    throw new ConnectTimeoutException("Connect to " + String.valueOf(remoteAddress) + " timed out!");
                }
                String host = remoteAddress instanceof HttpInetSocketAddress ? ((HttpInetSocketAddress)remoteAddress).getHttpHost().getHostName() : remoteAddress.getHostName();
                if (sock instanceof SSLSocket) {
                    sslSocket = (SSLSocket)sock;
                } else {
                    int port = remoteAddress.getPort();
                    sslSocket = (SSLSocket)sf.createSocket(sock, host, port, true);
                }
                ApacheClientHttpInvoker.this.verify(this.val$hv, host, sslSocket);
                return sslSocket;
            }

            public Socket createLayeredSocket(Socket socket, String host, int port, HttpParams params) throws IOException {
                SSLSocket sslSocket = (SSLSocket)sf.createSocket(socket, host, port, true);
                ApacheClientHttpInvoker.this.verify(this.val$hv, host, sslSocket);
                return sslSocket;
            }
        };
    }
}

