/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.local.AbstractLocalService;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

public class ObjectServiceImpl
extends AbstractLocalService
implements ObjectService {
    public ObjectServiceImpl(BindingSession session, CmisServiceFactory factory) {
        this.setSession(session);
        this.setServiceFactory(factory);
    }

    @Override
    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            String serviceResult = service.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            String string = serviceResult;
            return string;
        }
    }

    @Override
    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            String serviceResult = service.createDocumentFromSource(repositoryId, sourceId, properties, folderId, versioningState, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            String string = serviceResult;
            return string;
        }
    }

    @Override
    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            String serviceResult = service.createFolder(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            String string = serviceResult;
            return string;
        }
    }

    @Override
    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            String serviceResult = service.createPolicy(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            String string = serviceResult;
            return string;
        }
    }

    @Override
    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            String serviceResult = service.createItem(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            String string = serviceResult;
            return string;
        }
    }

    @Override
    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            String serviceResult = service.createRelationship(repositoryId, properties, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            String string = serviceResult;
            return string;
        }
    }

    @Override
    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteContentStream(repositoryId, objectId, changeToken, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }

    @Override
    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteObject(repositoryId, objectId, allVersions, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }

    @Override
    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            FailedToDeleteData serviceResult = service.deleteTree(repositoryId, folderId, allVersions, unfileObjects, continueOnFailure, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            FailedToDeleteData failedToDeleteData = serviceResult;
            return failedToDeleteData;
        }
    }

    @Override
    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            AllowableActions serviceResult = service.getAllowableActions(repositoryId, objectId, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            AllowableActions allowableActions = serviceResult;
            return allowableActions;
        }
    }

    @Override
    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            ContentStream serviceResult = service.getContentStream(repositoryId, objectId, streamId, offset, length, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            ContentStream contentStream = serviceResult;
            return contentStream;
        }
    }

    @Override
    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            ObjectData serviceResult = service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            ObjectData objectData = serviceResult;
            return objectData;
        }
    }

    @Override
    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            ObjectData serviceResult = service.getObjectByPath(repositoryId, path, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            ObjectData objectData = serviceResult;
            return objectData;
        }
    }

    @Override
    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            Properties serviceResult = service.getProperties(repositoryId, objectId, filter, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            Properties properties = serviceResult;
            return properties;
        }
    }

    @Override
    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            List<RenditionData> serviceResult = service.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            List<RenditionData> list = serviceResult;
            return list;
        }
    }

    @Override
    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.moveObject(repositoryId, objectId, targetFolderId, sourceFolderId, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }

    @Override
    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.setContentStream(repositoryId, objectId, overwriteFlag, changeToken, contentStream, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }

    @Override
    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.appendContentStream(repositoryId, objectId, changeToken, contentStream, isLastChunk, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }

    @Override
    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.updateProperties(repositoryId, objectId, changeToken, properties, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }

    @Override
    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            List<BulkUpdateObjectIdAndChangeToken> serviceResult = service.bulkUpdateProperties(repositoryId, objectIdAndChangeToken, properties, addSecondaryTypeIds, removeSecondaryTypeIds, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            List<BulkUpdateObjectIdAndChangeToken> list = serviceResult;
            return list;
        }
    }
}

