/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.local.AbstractLocalService;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

public class VersioningServiceImpl
extends AbstractLocalService
implements VersioningService {
    public VersioningServiceImpl(BindingSession session, CmisServiceFactory factory) {
        this.setSession(session);
        this.setServiceFactory(factory);
    }

    @Override
    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.cancelCheckOut(repositoryId, objectId, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }

    @Override
    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.checkIn(repositoryId, objectId, major, properties, contentStream, checkinComment, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }

    @Override
    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.checkOut(repositoryId, objectId, extension, contentCopied);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }

    @Override
    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            List<ObjectData> serviceResult = service.getAllVersions(repositoryId, objectId, versionSeriesId, filter, includeAllowableActions, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            List<ObjectData> list = serviceResult;
            return list;
        }
    }

    @Override
    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            ObjectData serviceResult = service.getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            ObjectData objectData = serviceResult;
            return objectData;
        }
    }

    @Override
    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            Properties serviceResult = service.getPropertiesOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            Properties properties = serviceResult;
            return properties;
        }
    }
}

