/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.http.HTTPException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.chemistry.opencmis.client.bindings.impl.ClientVersion;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisProxyAuthenticationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisTooManyRequestsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ACLService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ACLServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.MultiFilingService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.MultiFilingServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RelationshipService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RelationshipServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractPortProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPortProvider.class);
    private static final int PORT_CACHE_SIZE = 5;
    protected static final int CHUNK_SIZE = 65535;
    private BindingSession session;
    private boolean useCompression;
    private boolean useClientCompression;
    private String acceptLanguage;
    private final ReentrantLock portObjectLock = new ReentrantLock();
    private final EnumMap<CmisWebSerivcesService, ArrayDeque<SoftReference<BindingProvider>>> portObjectCache = new EnumMap(CmisWebSerivcesService.class);

    public BindingSession getSession() {
        return this.session;
    }

    public void setSession(BindingSession session) {
        this.session = session;
        Object compression = session.get("org.apache.chemistry.opencmis.binding.compression");
        this.useCompression = compression != null && Boolean.parseBoolean(compression.toString());
        Object clientCompression = session.get("org.apache.chemistry.opencmis.binding.clientcompression");
        boolean bl = this.useClientCompression = clientCompression != null && Boolean.parseBoolean(clientCompression.toString());
        if (session.get("org.apache.chemistry.opencmis.binding.acceptLanguage") instanceof String) {
            this.acceptLanguage = session.get("org.apache.chemistry.opencmis.binding.acceptLanguage").toString();
        }
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public boolean useClientCompression() {
        return this.useClientCompression;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public RepositoryServicePort getRepositoryServicePort(CmisVersion cmisVersion, String soapAction) {
        BindingProvider portObject = this.getPortObject(CmisWebSerivcesService.REPOSITORY_SERVICE);
        this.setSoapAction(portObject, soapAction, cmisVersion);
        return (RepositoryServicePort)portObject;
    }

    public NavigationServicePort getNavigationServicePort(CmisVersion cmisVersion, String soapAction) {
        BindingProvider portObject = this.getPortObject(CmisWebSerivcesService.NAVIGATION_SERVICE);
        this.setSoapAction(portObject, soapAction, cmisVersion);
        return (NavigationServicePort)portObject;
    }

    public ObjectServicePort getObjectServicePort(CmisVersion cmisVersion, String soapAction) {
        BindingProvider portObject = this.getPortObject(CmisWebSerivcesService.OBJECT_SERVICE);
        this.setSoapAction(portObject, soapAction, cmisVersion);
        return (ObjectServicePort)portObject;
    }

    public VersioningServicePort getVersioningServicePort(CmisVersion cmisVersion, String soapAction) {
        BindingProvider portObject = this.getPortObject(CmisWebSerivcesService.VERSIONING_SERVICE);
        this.setSoapAction(portObject, soapAction, cmisVersion);
        return (VersioningServicePort)portObject;
    }

    public DiscoveryServicePort getDiscoveryServicePort(CmisVersion cmisVersion, String soapAction) {
        BindingProvider portObject = this.getPortObject(CmisWebSerivcesService.DISCOVERY_SERVICE);
        this.setSoapAction(portObject, soapAction, cmisVersion);
        return (DiscoveryServicePort)portObject;
    }

    public MultiFilingServicePort getMultiFilingServicePort(CmisVersion cmisVersion, String soapAction) {
        BindingProvider portObject = this.getPortObject(CmisWebSerivcesService.MULTIFILING_SERVICE);
        this.setSoapAction(portObject, soapAction, cmisVersion);
        return (MultiFilingServicePort)portObject;
    }

    public RelationshipServicePort getRelationshipServicePort(CmisVersion cmisVersion, String soapAction) {
        BindingProvider portObject = this.getPortObject(CmisWebSerivcesService.RELATIONSHIP_SERVICE);
        this.setSoapAction(portObject, soapAction, cmisVersion);
        return (RelationshipServicePort)portObject;
    }

    public PolicyServicePort getPolicyServicePort(CmisVersion cmisVersion, String soapAction) {
        BindingProvider portObject = this.getPortObject(CmisWebSerivcesService.POLICY_SERVICE);
        this.setSoapAction(portObject, soapAction, cmisVersion);
        return (PolicyServicePort)portObject;
    }

    public ACLServicePort getACLServicePort(CmisVersion cmisVersion, String soapAction) {
        BindingProvider portObject = this.getPortObject(CmisWebSerivcesService.ACL_SERVICE);
        this.setSoapAction(portObject, soapAction, cmisVersion);
        return (ACLServicePort)portObject;
    }

    public void endCall(Object portObject) {
        block26: {
            AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(this.session);
            if (authProvider != null && portObject instanceof BindingProvider) {
                BindingProvider bp = (BindingProvider)portObject;
                String url = (String)bp.getRequestContext().get("jakarta.xml.ws.service.endpoint.address");
                if (bp.getResponseContext() != null) {
                    Map headers = (Map)bp.getResponseContext().get("jakarta.xml.ws.http.response.headers");
                    Integer statusCode = (Integer)bp.getResponseContext().get("jakarta.xml.ws.http.response.code");
                    authProvider.putResponseHeaders(url, statusCode == null ? -1 : statusCode, headers);
                }
                CmisWebSerivcesService service = null;
                if (portObject instanceof RepositoryServicePort) {
                    service = CmisWebSerivcesService.REPOSITORY_SERVICE;
                } else if (portObject instanceof NavigationServicePort) {
                    service = CmisWebSerivcesService.NAVIGATION_SERVICE;
                } else if (portObject instanceof ObjectServicePort) {
                    service = CmisWebSerivcesService.OBJECT_SERVICE;
                } else if (portObject instanceof VersioningServicePort) {
                    service = CmisWebSerivcesService.VERSIONING_SERVICE;
                } else if (portObject instanceof DiscoveryServicePort) {
                    service = CmisWebSerivcesService.DISCOVERY_SERVICE;
                } else if (portObject instanceof MultiFilingServicePort) {
                    service = CmisWebSerivcesService.MULTIFILING_SERVICE;
                } else if (portObject instanceof RelationshipServicePort) {
                    service = CmisWebSerivcesService.RELATIONSHIP_SERVICE;
                } else if (portObject instanceof PolicyServicePort) {
                    service = CmisWebSerivcesService.POLICY_SERVICE;
                } else if (portObject instanceof ACLServicePort) {
                    service = CmisWebSerivcesService.ACL_SERVICE;
                }
                if (service == null) {
                    return;
                }
                this.portObjectLock.lock();
                try {
                    ArrayDeque<SoftReference<BindingProvider>> queue = this.portObjectCache.get((Object)service);
                    if (queue == null) {
                        throw new CmisRuntimeException("This is a bug!");
                    }
                    if (queue.size() < 5) {
                        queue.push(new SoftReference<BindingProvider>(bp));
                        break block26;
                    }
                    Iterator<SoftReference<BindingProvider>> iter = queue.iterator();
                    while (iter.hasNext()) {
                        SoftReference<BindingProvider> ref = iter.next();
                        if (ref.get() != null) continue;
                        iter.remove();
                        queue.push(new SoftReference<BindingProvider>(bp));
                        break;
                    }
                }
                finally {
                    this.portObjectLock.unlock();
                }
            }
        }
    }

    protected BindingProvider getPortObject(CmisWebSerivcesService service) {
        EnumMap<CmisWebSerivcesService, CmisServiceHolder> serviceMap = (EnumMap<CmisWebSerivcesService, CmisServiceHolder>)this.session.get("org.apache.chemistry.opencmis.binding.webservices.services");
        if (serviceMap == null) {
            this.session.writeLock();
            try {
                serviceMap = (Map)this.session.get("org.apache.chemistry.opencmis.binding.webservices.services");
                if (serviceMap == null) {
                    serviceMap = new EnumMap<CmisWebSerivcesService, CmisServiceHolder>(CmisWebSerivcesService.class);
                    this.session.put("org.apache.chemistry.opencmis.binding.webservices.services", serviceMap, true);
                }
                if (serviceMap.containsKey((Object)service)) {
                    BindingProvider bindingProvider = this.createPortObject((CmisServiceHolder)serviceMap.get((Object)service));
                    return bindingProvider;
                }
                CmisServiceHolder serviceholder = this.initServiceObject(service);
                serviceMap.put(service, serviceholder);
                BindingProvider bindingProvider = this.createPortObject(serviceholder);
                return bindingProvider;
            }
            finally {
                this.session.writeUnlock();
            }
        }
        if (!serviceMap.containsKey((Object)service)) {
            this.session.writeLock();
            try {
                if (serviceMap.containsKey((Object)service)) {
                    BindingProvider bindingProvider = this.createPortObject((CmisServiceHolder)serviceMap.get((Object)service));
                    return bindingProvider;
                }
                CmisServiceHolder serviceholder = this.initServiceObject(service);
                serviceMap.put(service, serviceholder);
                BindingProvider bindingProvider = this.createPortObject(serviceholder);
                return bindingProvider;
            }
            finally {
                this.session.writeUnlock();
            }
        }
        return this.createPortObject((CmisServiceHolder)serviceMap.get((Object)service));
    }

    protected CmisServiceHolder initServiceObject(CmisWebSerivcesService service) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {}: Initializing Web Service {} ...", (Object)this.getSession().getSessionId(), (Object)service.getServiceName());
        }
        try {
            URL endpointUrl = null;
            String wsdlUrlStr = (String)this.session.get(service.getWsdlKey());
            if (wsdlUrlStr != null) {
                endpointUrl = this.getEndpointUrlFromWsdl(wsdlUrlStr, service);
            } else {
                String endpointUrlStr = (String)this.session.get(service.getEndpointKey());
                if (endpointUrlStr != null) {
                    endpointUrl = new URL(endpointUrlStr);
                }
            }
            if (endpointUrl == null) {
                throw new CmisRuntimeException("Neither a WSDL URL nor an endpoint URL is specified for the service " + service.getServiceName() + "!");
            }
            return new CmisServiceHolder(service, endpointUrl);
        }
        catch (CmisBaseException ce) {
            throw ce;
        }
        catch (HTTPException he) {
            String message = "Cannot connect to Web Services [" + service.getServiceName() + "]: " + he.getMessage();
            if (he.getStatusCode() == 401) {
                throw new CmisUnauthorizedException(message, he);
            }
            if (he.getStatusCode() == 404) {
                throw new CmisObjectNotFoundException(message, he);
            }
            if (he.getStatusCode() == 407) {
                throw new CmisProxyAuthenticationException(message, he);
            }
            if (he.getStatusCode() == 429) {
                throw new CmisTooManyRequestsException(message, he);
            }
            if (he.getStatusCode() == 301 || he.getStatusCode() == 302 || he.getStatusCode() == 303 || he.getStatusCode() == 307) {
                throw new CmisConnectionException("Redirects are not supported (HTTP status code " + he.getStatusCode() + "): " + message, he);
            }
            throw new CmisConnectionException(message, he);
        }
        catch (InvocationTargetException ite) {
            String message = "Cannot initalize Web Services service object [" + service.getServiceName() + "]: " + ite.getCause().getMessage();
            throw new CmisConnectionException(message, ite);
        }
        catch (Exception e) {
            String message = "Cannot initalize Web Services service object [" + service.getServiceName() + "]: " + e.getMessage();
            throw new CmisConnectionException(message, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL getEndpointUrlFromWsdl(String wsdlUrl, CmisWebSerivcesService service) {
        try {
            url = new URL(wsdlUrl);
        }
        catch (MalformedURLException e) {
            throw new CmisConnectionException("Invalid WSDL URL: " + wsdlUrl, e);
        }
        if (url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https")) {
            hi = CmisBindingsHelper.getHttpInvoker(this.session);
            wsdlResponse = hi.invokeGET(new UrlBuilder(wsdlUrl), this.session);
            if (wsdlResponse.getResponseCode() != 200) {
                throw new CmisConnectionException("Cannot access WSDL: " + wsdlUrl, BigInteger.ZERO, wsdlResponse.getErrorContent());
            }
            wsdlStream = wsdlResponse.getStream();
        } else {
            try {
                wsdlStream = url.openStream();
            }
            catch (IOException e) {
                throw new CmisConnectionException("Cannot access WSDL: " + wsdlUrl, e);
            }
        }
        doc = XMLUtils.parseDomDocument(new BufferedInputStream(wsdlStream, 65536));
        serivceList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
        i = 0;
        if (true) ** GOTO lbl31
        {
            catch (ParserConfigurationException pe) {
                throw new CmisRuntimeException("Cannot parse this WSDL: " + wsdlUrl, pe);
            }
            catch (SAXException se) {
                throw new CmisRuntimeException("Cannot parse this WSDL: " + wsdlUrl, se);
            }
            catch (IOException ioe) {
                throw new CmisRuntimeException("Cannot read this WSDL: " + wsdlUrl, ioe);
            }
            {
                do {
                    ++i;
lbl31:
                    // 2 sources

                    if (i < serivceList.getLength()) continue;
                    throw new CmisRuntimeException("This service does not provide an endpoint address: " + service.getServiceName());
                } while ((name = (serviceNode = (Element)serivceList.item(i)).getAttribute("name")) == null || !service.getQName().getLocalPart().equals(name));
                portList = serviceNode.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "port");
                if (portList.getLength() < 1) {
                    throw new CmisRuntimeException("This service has no ports: " + service.getServiceName());
                }
                port = (Element)portList.item(0);
                addressList = port.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "address");
                if (addressList.getLength() < 1) {
                    addressList = port.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap12/", "address");
                }
                if (addressList.getLength() < 1) {
                    throw new CmisRuntimeException("This service has no endpoint address: " + service.getServiceName());
                }
                address = (Element)addressList.item(0);
                location = address.getAttribute("location");
                if (location == null) {
                    throw new CmisRuntimeException("This service has no endpoint address: " + service.getServiceName());
                }
                try {
                    return new URL(location);
                }
                catch (MalformedURLException e) {}
                throw new CmisRuntimeException("This service provides an invalid endpoint address: " + service.getServiceName(), e);
            }
        }
        finally {
            IOUtils.closeQuietly(wsdlStream);
        }
    }

    protected void setHTTPHeaders(BindingProvider portObject, Map<String, List<String>> httpHeaders) {
        if (httpHeaders == null) {
            httpHeaders = new HashMap<String, List<String>>();
        }
        httpHeaders.put("X-CMIS-Client", Collections.singletonList((String)this.session.get("org.apache.chemistry.opencmis.binding.useragent", ClientVersion.OPENCMIS_USER_AGENT)));
        if (this.useCompression) {
            httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
        }
        if (this.useClientCompression) {
            httpHeaders.put("Content-Encoding", Collections.singletonList("gzip"));
        }
        if (this.acceptLanguage != null) {
            httpHeaders.put("Accept-Language", Collections.singletonList(this.acceptLanguage));
        }
        portObject.getRequestContext().put("jakarta.xml.ws.http.request.headers", httpHeaders);
    }

    protected void setEndpointUrl(BindingProvider portObject, URL endpointUrl) {
        if (endpointUrl == null) {
            return;
        }
        portObject.getRequestContext().put("jakarta.xml.ws.service.endpoint.address", endpointUrl.toString());
    }

    protected void setSoapAction(BindingProvider portObject, String soapAction, CmisVersion cmisVersion) {
        portObject.getRequestContext().put("jakarta.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        if (cmisVersion == CmisVersion.CMIS_1_0) {
            portObject.getRequestContext().put("jakarta.xml.ws.soap.http.soapaction.uri", "");
        } else {
            portObject.getRequestContext().put("jakarta.xml.ws.soap.http.soapaction.uri", soapAction);
        }
    }

    protected BindingProvider createPortObjectFromServiceHolder(CmisServiceHolder serviceHolder, WebServiceFeature ... features) throws Exception {
        this.portObjectLock.lock();
        try {
            ArrayDeque<SoftReference<Object>> queue = this.portObjectCache.get((Object)serviceHolder.getService());
            if (queue == null) {
                queue = new ArrayDeque();
                this.portObjectCache.put(serviceHolder.getService(), queue);
            }
            while (!queue.isEmpty()) {
                BindingProvider bp = (BindingProvider)queue.pop().get();
                if (bp == null) continue;
                BindingProvider bindingProvider = bp;
                return bindingProvider;
            }
        }
        finally {
            this.portObjectLock.unlock();
        }
        return (BindingProvider)serviceHolder.getServiceObject().getPort(serviceHolder.getService().getPortClass(), features);
    }

    protected abstract BindingProvider createPortObject(CmisServiceHolder var1);

    class CmisServiceHolder {
        private final CmisWebSerivcesService service;
        private SoftReference<Service> serviceObject;
        private final URL endpointUrl;

        public CmisServiceHolder(CmisWebSerivcesService service, URL endpointUrl) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            this.service = service;
            this.endpointUrl = endpointUrl;
            this.serviceObject = new SoftReference<Service>(this.createServiceObject());
        }

        private Service createServiceObject() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            HandlerResolver handlerResolver;
            Constructor<? extends Service> serviceConstructor = this.service.getServiceClass().getConstructor(URL.class, QName.class);
            URL wsdlUrl = this.service.getPortClass().getResource("/wsdl/cmis11/CMISWS-Service.wsdl");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {}: WSDL URL: {}", (Object)AbstractPortProvider.this.getSession().getSessionId(), (Object)wsdlUrl.toExternalForm());
            }
            Service newService = serviceConstructor.newInstance(wsdlUrl, this.service.getQName());
            AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(AbstractPortProvider.this.getSession());
            if (authProvider != null && (handlerResolver = authProvider.getHandlerResolver()) != null) {
                newService.setHandlerResolver(handlerResolver);
            }
            return newService;
        }

        public CmisWebSerivcesService getService() {
            return this.service;
        }

        public Service getServiceObject() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Service result = this.serviceObject.get();
            if (result == null) {
                result = this.createServiceObject();
                this.serviceObject = new SoftReference<Service>(result);
            }
            return result;
        }

        public URL getEndpointUrl() {
            return this.endpointUrl;
        }

        public String getServiceName() {
            return this.service.getServiceName();
        }
    }

    protected static enum CmisWebSerivcesService {
        REPOSITORY_SERVICE("RepositoryService", false, RepositoryService.class, RepositoryServicePort.class, "org.apache.chemistry.opencmis.binding.webservices.RepositoryService", "org.apache.chemistry.opencmis.binding.webservices.RepositoryService.endpoint"),
        NAVIGATION_SERVICE("NavigationService", false, NavigationService.class, NavigationServicePort.class, "org.apache.chemistry.opencmis.binding.webservices.NavigationService", "org.apache.chemistry.opencmis.binding.webservices.NavigationService.endpoint"),
        OBJECT_SERVICE("ObjectService", true, ObjectService.class, ObjectServicePort.class, "org.apache.chemistry.opencmis.binding.webservices.ObjectService", "org.apache.chemistry.opencmis.binding.webservices.ObjectService.endpoint"),
        VERSIONING_SERVICE("VersioningService", true, VersioningService.class, VersioningServicePort.class, "org.apache.chemistry.opencmis.binding.webservices.VersioningService", "org.apache.chemistry.opencmis.binding.webservices.VersioningService.endpoint"),
        DISCOVERY_SERVICE("DiscoveryService", false, DiscoveryService.class, DiscoveryServicePort.class, "org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", "org.apache.chemistry.opencmis.binding.webservices.DiscoveryService.endpoint"),
        MULTIFILING_SERVICE("MultiFilingService", false, MultiFilingService.class, MultiFilingServicePort.class, "org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", "org.apache.chemistry.opencmis.binding.webservices.MultiFilingService.endpoint"),
        RELATIONSHIP_SERVICE("RelationshipService", false, RelationshipService.class, RelationshipServicePort.class, "org.apache.chemistry.opencmis.binding.webservices.RelationshipService", "org.apache.chemistry.opencmis.binding.webservices.RelationshipService.endpoint"),
        POLICY_SERVICE("PolicyService", false, PolicyService.class, PolicyServicePort.class, "org.apache.chemistry.opencmis.binding.webservices.PolicyService", "org.apache.chemistry.opencmis.binding.webservices.PolicyService.endpoint"),
        ACL_SERVICE("ACLService", false, ACLService.class, ACLServicePort.class, "org.apache.chemistry.opencmis.binding.webservices.ACLService", "org.apache.chemistry.opencmis.binding.webservices.ACLService.endpoint");

        private final String name;
        private final QName qname;
        private final boolean handlesContent;
        private final Class<? extends Service> serviceClass;
        private final Class<?> portClass;
        private final String wsdlKey;
        private final String endpointKey;

        private CmisWebSerivcesService(String localname, boolean handlesContent, Class<? extends Service> serviceClass, Class<?> port11Class, String wsdlKey, String endpointKey) {
            this.name = localname;
            this.qname = new QName("http://docs.oasis-open.org/ns/cmis/ws/200908/", localname);
            this.handlesContent = handlesContent;
            this.serviceClass = serviceClass;
            this.portClass = port11Class;
            this.wsdlKey = wsdlKey;
            this.endpointKey = endpointKey;
        }

        public String getServiceName() {
            return this.name;
        }

        public QName getQName() {
            return this.qname;
        }

        public boolean handlesContent() {
            return this.handlesContent;
        }

        public Class<? extends Service> getServiceClass() {
            return this.serviceClass;
        }

        public Class<?> getPortClass() {
            return this.portClass;
        }

        public String getWsdlKey() {
            return this.wsdlKey;
        }

        public String getEndpointKey() {
            return this.endpointKey;
        }
    }
}

