/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import jakarta.xml.ws.Binding;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.MTOMFeature;
import jakarta.xml.ws.soap.SOAPBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.namespace.QName;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.headers.Header;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CXFPortProvider
extends AbstractPortProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CXFPortProvider.class);
    private int contentThreshold;
    private int responseThreshold;

    @Override
    public void setSession(BindingSession session) {
        super.setSession(session);
        this.contentThreshold = session.get("org.apache.chemistry.opencmis.binding.webservices.memoryThreshold", 0x400000);
        this.responseThreshold = session.get("org.apache.chemistry.opencmis.binding.webservices.responseMemoryThreshold", -1);
        if (this.responseThreshold > this.contentThreshold) {
            this.contentThreshold = this.responseThreshold;
        }
    }

    @Override
    protected BindingProvider createPortObject(AbstractPortProvider.CmisServiceHolder serviceHolder) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {}: Creating Web Service port object of {} ...", (Object)this.getSession().getSessionId(), (Object)serviceHolder.getServiceName());
        }
        try {
            int readTimeout;
            BindingProvider portObject = this.createPortObjectFromServiceHolder(serviceHolder, new WebServiceFeature[]{new MTOMFeature()});
            Binding binding = portObject.getBinding();
            ((SOAPBinding)binding).setMTOMEnabled(true);
            Client client = ClientProxy.getClient((Object)portObject);
            HTTPConduit http = (HTTPConduit)client.getConduit();
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setAllowChunking(true);
            Bus bus = client.getBus();
            Object tempDir = this.getSession().get("org.apache.chemistry.opencmis.binding.webservices.tempDirectory");
            if (tempDir != null) {
                bus.setProperty("bus.io.CachedOutputStream.OutputDirectory", (Object)tempDir.toString());
            }
            if (serviceHolder.getService().handlesContent()) {
                bus.setProperty("bus.io.CachedOutputStream.Threshold", (Object)String.valueOf(this.contentThreshold));
            } else if (this.responseThreshold > -1) {
                bus.setProperty("bus.io.CachedOutputStream.Threshold", (Object)String.valueOf(this.responseThreshold));
            }
            bus.setProperty("bus.io.CachedOutputStream.MaxSize", (Object)"-1");
            if (this.getSession().get("org.apache.chemistry.opencmis.binding.webservices.tempEncrypt", false)) {
                bus.setProperty("bus.io.CachedOutputStream.CipherTransformation", (Object)"AES/CTR/PKCS5Padding");
            }
            AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(this.getSession());
            Map<String, List<String>> httpHeaders = null;
            if (authProvider != null) {
                Element soapHeader = authProvider.getSOAPHeaders(portObject);
                if (soapHeader != null) {
                    ArrayList<Header> soapHeaderList = new ArrayList<Header>(2);
                    soapHeaderList.add(new Header(new QName(soapHeader.getNamespaceURI(), soapHeader.getLocalName()), (Object)soapHeader));
                    portObject.getRequestContext().put(Header.HEADER_LIST, soapHeaderList);
                }
                String url = serviceHolder.getEndpointUrl() != null ? serviceHolder.getEndpointUrl().toString() : serviceHolder.getServiceObject().getWSDLDocumentLocation().toString();
                httpHeaders = authProvider.getHTTPHeaders(url);
                SSLSocketFactory sslSocketFactory = authProvider.getSSLSocketFactory();
                HostnameVerifier hostnameVerifier = authProvider.getHostnameVerifier();
                if (sslSocketFactory != null || hostnameVerifier != null) {
                    TLSClientParameters tlsCP = new TLSClientParameters();
                    if (sslSocketFactory != null) {
                        tlsCP.setSSLSocketFactory(sslSocketFactory);
                    }
                    if (hostnameVerifier != null) {
                        tlsCP.setHostnameVerifier(hostnameVerifier);
                    }
                    http.setTlsClientParameters(tlsCP);
                }
            }
            this.setHTTPHeaders(portObject, httpHeaders);
            this.setEndpointUrl(portObject, serviceHolder.getEndpointUrl());
            int connectTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
            if (connectTimeout >= 0) {
                httpClientPolicy.setConnectionTimeout((long)connectTimeout);
            }
            if ((readTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
                httpClientPolicy.setReceiveTimeout((long)readTimeout);
            }
            http.setClient(httpClientPolicy);
            return portObject;
        }
        catch (CmisBaseException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot initalize Web Services port object: " + e.getMessage(), e);
        }
    }
}

