/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;

public class OperationContextImpl
implements OperationContext,
Serializable {
    public static final String PROPERTIES_STAR = "*";
    public static final String RENDITION_NONE = "cmis:none";
    private static final long serialVersionUID = 1L;
    private TreeSet<String> filter;
    private boolean loadSecondaryTypeProperties;
    private boolean includeAcls;
    private boolean includeAllowableActions;
    private boolean includePolicies;
    private IncludeRelationships includeRelationships;
    private TreeSet<String> renditionFilter;
    private boolean includePathSegments;
    private String orderBy;
    private boolean cacheEnabled;
    private String cacheKey;
    private int maxItemsPerPage;

    public OperationContextImpl() {
        this.setFilter(null);
        this.setLoadSecondaryTypeProperties(false);
        this.setIncludeAcls(false);
        this.setIncludeAllowableActions(true);
        this.setIncludePolicies(false);
        this.setIncludeRelationships(IncludeRelationships.NONE);
        this.setRenditionFilter(null);
        this.setIncludePathSegments(true);
        this.setOrderBy(null);
        this.setCacheEnabled(false);
        this.generateCacheKey();
        this.setMaxItemsPerPage(100);
    }

    public OperationContextImpl(OperationContext source) {
        this.setFilter(source.getFilter());
        this.setLoadSecondaryTypeProperties(source.loadSecondaryTypeProperties());
        this.setIncludeAcls(source.isIncludeAcls());
        this.setIncludeAllowableActions(source.isIncludeAllowableActions());
        this.setIncludePolicies(source.isIncludePolicies());
        this.setIncludeRelationships(source.getIncludeRelationships());
        this.setRenditionFilter(source.getRenditionFilter());
        this.setIncludePathSegments(source.isIncludePathSegments());
        this.setOrderBy(source.getOrderBy());
        this.setCacheEnabled(source.isCacheEnabled());
        this.generateCacheKey();
        this.setMaxItemsPerPage(source.getMaxItemsPerPage());
    }

    public OperationContextImpl(Set<String> propertyFilter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        this.setFilter(propertyFilter);
        this.setIncludeAcls(includeAcls);
        this.setIncludeAllowableActions(includeAllowableActions);
        this.setIncludePolicies(includePolicies);
        this.setIncludeRelationships(includeRelationships);
        this.setRenditionFilter(renditionFilter);
        this.setIncludePathSegments(includePathSegments);
        this.setOrderBy(orderBy);
        this.setCacheEnabled(cacheEnabled);
        this.generateCacheKey();
        this.setMaxItemsPerPage(maxItemsPerPage);
    }

    @Override
    public final Set<String> getFilter() {
        if (this.filter == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.filter);
    }

    @Override
    public final void setFilter(Set<String> propertyFilter) {
        if (propertyFilter != null) {
            TreeSet<String> tempSet = new TreeSet<String>();
            for (String oid : propertyFilter) {
                String toid;
                if (oid == null || (toid = oid.trim()).length() == 0) continue;
                if (toid.equals(PROPERTIES_STAR)) {
                    tempSet = new TreeSet();
                    tempSet.add(PROPERTIES_STAR);
                    break;
                }
                if (toid.indexOf(44) > -1) {
                    throw new IllegalArgumentException("Query id must not contain a comma!");
                }
                tempSet.add(toid);
            }
            this.filter = tempSet.isEmpty() ? null : tempSet;
        } else {
            this.filter = null;
        }
        this.generateCacheKey();
    }

    @Override
    public final void setFilterString(String propertyFilter) {
        if (propertyFilter == null || propertyFilter.trim().length() == 0) {
            this.setFilter(null);
            return;
        }
        String[] propertyIds = propertyFilter.split(",");
        TreeSet<String> tempSet = new TreeSet<String>();
        String[] stringArray = propertyIds;
        int n = propertyIds.length;
        int n2 = 0;
        while (n2 < n) {
            String pid = stringArray[n2];
            tempSet.add(pid);
            ++n2;
        }
        this.setFilter(tempSet);
    }

    @Override
    public final String getFilterString() {
        if (this.filter == null) {
            return null;
        }
        if (this.filter.contains(PROPERTIES_STAR)) {
            return PROPERTIES_STAR;
        }
        this.filter.add("cmis:objectId");
        this.filter.add("cmis:baseTypeId");
        this.filter.add("cmis:objectTypeId");
        if (this.loadSecondaryTypeProperties) {
            this.filter.add("cmis:secondaryObjectTypeIds");
        }
        StringBuilder sb = new StringBuilder(128);
        for (String oid : this.filter) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(oid);
        }
        return sb.toString();
    }

    @Override
    public final void setLoadSecondaryTypeProperties(boolean load) {
        this.loadSecondaryTypeProperties = load;
    }

    @Override
    public final boolean loadSecondaryTypeProperties() {
        return this.loadSecondaryTypeProperties;
    }

    @Override
    public final boolean isIncludeAcls() {
        return this.includeAcls;
    }

    @Override
    public final void setIncludeAcls(boolean include) {
        this.includeAcls = include;
        this.generateCacheKey();
    }

    @Override
    public final boolean isIncludeAllowableActions() {
        return this.includeAllowableActions;
    }

    @Override
    public final void setIncludeAllowableActions(boolean include) {
        this.includeAllowableActions = include;
        this.generateCacheKey();
    }

    @Override
    public final boolean isIncludePolicies() {
        return this.includePolicies;
    }

    @Override
    public final void setIncludePolicies(boolean include) {
        this.includePolicies = include;
        this.generateCacheKey();
    }

    @Override
    public final IncludeRelationships getIncludeRelationships() {
        return this.includeRelationships;
    }

    @Override
    public final void setIncludeRelationships(IncludeRelationships include) {
        this.includeRelationships = include;
        this.generateCacheKey();
    }

    @Override
    public final Set<String> getRenditionFilter() {
        if (this.renditionFilter == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.renditionFilter);
    }

    @Override
    public final void setRenditionFilter(Set<String> renditionFilter) {
        TreeSet<String> tempSet = new TreeSet<String>();
        if (renditionFilter != null) {
            for (String rf : renditionFilter) {
                String trf;
                if (rf == null || (trf = rf.trim()).length() == 0) continue;
                if (trf.indexOf(44) > -1) {
                    throw new IllegalArgumentException("Rendition must not contain a comma!");
                }
                tempSet.add(trf);
            }
            if (tempSet.isEmpty()) {
                tempSet.add(RENDITION_NONE);
            }
        } else {
            tempSet.add(RENDITION_NONE);
        }
        this.renditionFilter = tempSet;
        this.generateCacheKey();
    }

    @Override
    public final void setRenditionFilterString(String renditionFilter) {
        if (renditionFilter == null || renditionFilter.trim().length() == 0) {
            this.setRenditionFilter(null);
            return;
        }
        String[] renditions = renditionFilter.split(",");
        TreeSet<String> tempSet = new TreeSet<String>();
        String[] stringArray = renditions;
        int n = renditions.length;
        int n2 = 0;
        while (n2 < n) {
            String rend = stringArray[n2];
            tempSet.add(rend);
            ++n2;
        }
        this.setRenditionFilter(tempSet);
    }

    @Override
    public final String getRenditionFilterString() {
        if (this.renditionFilter == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(128);
        for (String rf : this.renditionFilter) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(rf);
        }
        return sb.toString();
    }

    @Override
    public final boolean isIncludePathSegments() {
        return this.includePathSegments;
    }

    @Override
    public final void setIncludePathSegments(boolean include) {
        this.includePathSegments = include;
    }

    @Override
    public final String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public final void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public final boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Override
    public final void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    @Override
    public final String getCacheKey() {
        return this.cacheKey;
    }

    protected final void generateCacheKey() {
        if (!this.cacheEnabled) {
            this.cacheKey = null;
        }
        StringBuilder sb = new StringBuilder(128);
        int bits = 0;
        if (this.includeAcls) {
            ++bits;
        }
        if (this.includeAllowableActions) {
            bits += 2;
        }
        if (this.includePolicies) {
            bits += 4;
        }
        sb.append((char)(48 + bits));
        sb.append(this.includeRelationships == null ? (char)'-' : (char)(97 + this.includeRelationships.ordinal()));
        sb.append(this.filter == null ? "" : this.getFilterString());
        if (this.renditionFilter != null && this.renditionFilter.size() > 0) {
            sb.append('\\');
            sb.append(this.getRenditionFilterString());
        }
        this.cacheKey = sb.toString();
    }

    @Override
    public final int getMaxItemsPerPage() {
        return this.maxItemsPerPage;
    }

    @Override
    public final void setMaxItemsPerPage(int maxItemsPerPage) {
        if (maxItemsPerPage < 1) {
            throw new IllegalArgumentException("itemsPerPage must be > 0!");
        }
        this.maxItemsPerPage = maxItemsPerPage;
    }
}

