/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;

public final class IOUtils {
    public static final String UTF8 = "UTF-8";
    public static final String ISO_8859_1 = "ISO-8859-1";

    private IOUtils() {
    }

    public static byte[] toUTF8Bytes(String s) {
        if (s == null) {
            return null;
        }
        try {
            return s.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new CmisRuntimeException("Unsupported encoding 'UTF-8'!", e);
        }
    }

    public static String toUTF8String(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new CmisRuntimeException("Unsupported encoding 'UTF-8'!", e);
        }
    }

    public static String encodeURL(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new CmisRuntimeException("Unsupported encoding 'UTF-8'!", e);
        }
    }

    public static String decodeURL(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new CmisRuntimeException("Unsupported encoding 'UTF-8'!", e);
        }
    }

    public static InputStream checkForBytes(InputStream stream, int bufferSize) throws IOException {
        if (stream == null) {
            return null;
        }
        InputStream checkStream = stream;
        if (!stream.markSupported()) {
            checkStream = new BufferedInputStream(stream, bufferSize);
        }
        if (IOUtils.checkForBytes(checkStream)) {
            return checkStream;
        }
        return null;
    }

    public static boolean checkForBytes(InputStream stream) throws IOException {
        if (stream == null) {
            return false;
        }
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("Stream must support marks!");
        }
        stream.mark(2);
        if (stream.read() != -1) {
            stream.reset();
            return true;
        }
        return false;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ContentStream contentStream) {
        if (contentStream != null) {
            IOUtils.closeQuietly(contentStream.getStream());
        }
    }

    public static void consumeAndClose(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            try {
                byte[] buffer = new byte[65536];
                while (stream.read(buffer) > -1) {
                }
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(stream);
            }
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    public static void consumeAndClose(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            try {
                char[] buffer = new char[65536];
                while (reader.read(buffer) > -1) {
                }
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(reader);
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IOUtils.copy(in, out, 65536);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int b;
        assert (in != null);
        assert (out != null);
        assert (bufferSize > 0);
        byte[] buffer = new byte[bufferSize];
        while ((b = in.read(buffer)) > -1) {
            out.write(buffer, 0, b);
        }
    }

    public static void readLinesFromStream(InputStream stream, LineHandler handler, int maxLines) throws IOException {
        if (stream == null) {
            return;
        }
        int counter = 0;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream, UTF8));
            while ((line = reader.readLine()) != null) {
                if (maxLines <= -1 || counter != maxLines) {
                    ++counter;
                    if (handler.handle(line)) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
    }

    public static String readFirstLine(InputStream stream) throws IOException {
        final StringBuilder result = new StringBuilder(128);
        IOUtils.readLinesFromStream(stream, new LineHandler(){

            @Override
            public boolean handle(String line) {
                result.append(line);
                return false;
            }
        }, 1);
        return result.toString();
    }

    public static String readAllLines(InputStream stream) throws IOException {
        return IOUtils.readAllLines(stream, Integer.MAX_VALUE);
    }

    public static String readAllLines(InputStream stream, int maxLines) throws IOException {
        final StringBuilder result = new StringBuilder(1024);
        IOUtils.readLinesFromStream(stream, new LineHandler(){

            @Override
            public boolean handle(String line) {
                result.append(line);
                result.append('\n');
                return true;
            }
        }, maxLines);
        return result.toString();
    }

    public static String readAllLinesAndRemoveHeader(InputStream stream) throws IOException {
        return IOUtils.readAllLinesAndRemoveHeader(stream, Integer.MAX_VALUE);
    }

    public static String readAllLinesAndRemoveHeader(InputStream stream, int maxLines) throws IOException {
        final StringBuilder result = new StringBuilder(1024);
        IOUtils.readLinesFromStream(stream, new SkipHeaderLineHandler(){

            @Override
            public boolean handle(String line) {
                if (!this.isHeaderLine(line)) {
                    result.append(line);
                    result.append('\n');
                }
                return true;
            }
        }, maxLines);
        return result.toString();
    }

    public static String readAllLinesAndIgnoreComments(InputStream stream) throws IOException {
        return IOUtils.readAllLinesAndIgnoreComments(stream, Integer.MAX_VALUE);
    }

    public static String readAllLinesAndIgnoreComments(InputStream stream, int maxLines) throws IOException {
        final StringBuilder result = new StringBuilder(1024);
        IOUtils.readLinesFromStream(stream, new IgnoreCommentsLineHandler(){

            @Override
            public boolean handle(String line) {
                if (!this.isComment(line)) {
                    result.append(line);
                    result.append('\n');
                }
                return true;
            }
        }, maxLines);
        return result.toString();
    }

    public static List<String> readAllLinesAsList(InputStream stream) throws IOException {
        return IOUtils.readAllLinesAsList(stream, Integer.MAX_VALUE);
    }

    public static List<String> readAllLinesAsList(InputStream stream, int maxLines) throws IOException {
        final ArrayList<String> result = new ArrayList<String>();
        IOUtils.readLinesFromStream(stream, new IgnoreCommentsLineHandler(){

            @Override
            public boolean handle(String line) {
                if (!this.isComment(line)) {
                    result.add(line);
                }
                return true;
            }
        }, maxLines);
        return result;
    }

    public static Map<String, String> readAllLinesAsMap(InputStream stream) throws IOException {
        return IOUtils.readAllLinesAsMap(stream, Integer.MAX_VALUE);
    }

    public static Map<String, String> readAllLinesAsMap(InputStream stream, int maxLines) throws IOException {
        final HashMap<String, String> result = new HashMap<String, String>();
        IOUtils.readLinesFromStream(stream, new IgnoreCommentsLineHandler(){

            @Override
            public boolean handle(String line) {
                if (!this.isComment(line)) {
                    int x = line.indexOf(61);
                    if (x < 0) {
                        result.put(line.trim(), "");
                    } else {
                        result.put(line.substring(0, x).trim(), line.substring(x + 1).trim());
                    }
                }
                return true;
            }
        }, maxLines);
        return result;
    }

    public static abstract class IgnoreCommentsLineHandler
    implements LineHandler {
        public boolean isComment(String line) {
            String trim = line.trim();
            if (trim.length() == 0) {
                return true;
            }
            return trim.charAt(0) == '#';
        }
    }

    public static interface LineHandler {
        public boolean handle(String var1);
    }

    public static abstract class SkipHeaderLineHandler
    implements LineHandler {
        private boolean header = true;

        public boolean isHeaderLine(String line) {
            if (!this.header) {
                return false;
            }
            String trim = line.trim();
            if (trim.length() == 0) {
                this.header = false;
                return true;
            }
            char c = trim.charAt(0);
            return c == '/' || c == '*' || c == '#';
        }
    }
}

