/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.CmisEnumHelper;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.XMLConstraints;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;

public abstract class XMLWalker<T> {
    public T walk(XMLStreamReader parser) throws XMLStreamException {
        assert (parser != null);
        T result = this.prepareTarget(parser, parser.getName());
        XMLUtils.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if (this.read(parser, name, result)) continue;
                if (result instanceof ExtensionsData) {
                    this.handleExtension(parser, (ExtensionsData)result);
                    continue;
                }
                XMLUtils.skip(parser);
                continue;
            }
            if (event == 2 || !XMLUtils.next(parser)) break;
        }
        XMLUtils.next(parser);
        return result;
    }

    protected boolean isCmisNamespace(QName name) {
        assert (name != null);
        return "http://docs.oasis-open.org/ns/cmis/core/200908/".hashCode() == name.getNamespaceURI().hashCode() && "http://docs.oasis-open.org/ns/cmis/core/200908/".equals(name.getNamespaceURI());
    }

    protected boolean isAtomNamespace(QName name) {
        assert (name != null);
        return "http://www.w3.org/2005/Atom".hashCode() == name.getNamespaceURI().hashCode() && "http://www.w3.org/2005/Atom".equals(name.getNamespaceURI());
    }

    protected boolean isTag(QName name, String tag) {
        assert (name != null);
        assert (tag != null);
        return tag.hashCode() == name.getLocalPart().hashCode() && tag.equals(name.getLocalPart());
    }

    protected void handleExtension(XMLStreamReader parser, ExtensionsData extData) throws XMLStreamException {
        assert (parser != null);
        List<CmisExtensionElement> extensions = extData.getExtensions();
        if (extensions == null) {
            extensions = new ArrayList<CmisExtensionElement>();
            extData.setExtensions(extensions);
        }
        if (extensions.size() + 1 > XMLConstraints.MAX_EXTENSIONS_WIDTH) {
            throw new CmisInvalidArgumentException("Too many extensions! (More than " + XMLConstraints.MAX_EXTENSIONS_WIDTH + " extensions.)");
        }
        extensions.add(this.handleExtensionLevel(parser, 0));
    }

    private CmisExtensionElement handleExtensionLevel(XMLStreamReader parser, int level) throws XMLStreamException {
        int event;
        assert (parser != null);
        QName name = parser.getName();
        HashMap<String, String> attributes = null;
        StringBuilder sb = new StringBuilder(128);
        ArrayList<CmisExtensionElement> children = null;
        if (parser.getAttributeCount() > 0) {
            attributes = new HashMap<String, String>();
            int i = 0;
            while (i < parser.getAttributeCount()) {
                attributes.put(parser.getAttributeLocalName(i), parser.getAttributeValue(i));
                ++i;
            }
        }
        XMLUtils.next(parser);
        while ((event = parser.getEventType()) != 2) {
            if (event == 4) {
                String s = parser.getText();
                if (s != null) {
                    if (sb.length() + s.length() > 102400) {
                        throw new CmisInvalidArgumentException("String limit exceeded!");
                    }
                    sb.append(s);
                }
            } else if (event == 1) {
                if (level + 1 > XMLConstraints.MAX_EXTENSIONS_DEPTH) {
                    throw new CmisInvalidArgumentException("Extensions tree too deep!  (More than " + XMLConstraints.MAX_EXTENSIONS_DEPTH + " levels.)");
                }
                if (children == null) {
                    children = new ArrayList<CmisExtensionElement>();
                }
                if (children.size() + 1 > XMLConstraints.MAX_EXTENSIONS_WIDTH) {
                    throw new CmisInvalidArgumentException("Extensions tree too wide! (More than " + XMLConstraints.MAX_EXTENSIONS_WIDTH + " extensions on one level.)");
                }
                children.add(this.handleExtensionLevel(parser, level + 1));
                continue;
            }
            if (XMLUtils.next(parser)) continue;
        }
        XMLUtils.next(parser);
        if (children != null) {
            return new CmisExtensionElementImpl(name.getNamespaceURI(), name.getLocalPart(), attributes, children);
        }
        return new CmisExtensionElementImpl(name.getNamespaceURI(), name.getLocalPart(), attributes, sb.toString());
    }

    protected <S> List<S> addToList(List<S> list, S value) {
        if (list == null || list.isEmpty()) {
            list = new ArrayList<S>();
        }
        list.add(value);
        return list;
    }

    protected String readText(XMLStreamReader parser) throws XMLStreamException {
        assert (parser != null);
        return XMLUtils.readText(parser, 102400);
    }

    protected Boolean readBoolean(XMLStreamReader parser) throws XMLStreamException {
        assert (parser != null);
        String value = this.readText(parser);
        if ("true".equals(value) || "1".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value) || "0".equals(value)) {
            return Boolean.FALSE;
        }
        throw new CmisInvalidArgumentException("Invalid boolean value!");
    }

    protected BigInteger readInteger(XMLStreamReader parser) throws XMLStreamException {
        assert (parser != null);
        String value = this.readText(parser);
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException e) {
            throw new CmisInvalidArgumentException("Invalid integer value!", e);
        }
    }

    protected BigDecimal readDecimal(XMLStreamReader parser) throws XMLStreamException {
        assert (parser != null);
        String value = this.readText(parser);
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new CmisInvalidArgumentException("Invalid decimal value!", e);
        }
    }

    protected GregorianCalendar readDateTime(XMLStreamReader parser) throws XMLStreamException {
        assert (parser != null);
        String value = this.readText(parser);
        GregorianCalendar result = DateTimeHelper.parseXmlDateTime(value);
        if (result == null) {
            throw new CmisInvalidArgumentException("Invalid datetime value!");
        }
        return result;
    }

    public <E extends Enum<E>> E readEnum(XMLStreamReader parser, Class<E> clazz) throws XMLStreamException {
        assert (parser != null);
        assert (clazz != null);
        return CmisEnumHelper.fromValue(this.readText(parser), clazz);
    }

    protected abstract T prepareTarget(XMLStreamReader var1, QName var2) throws XMLStreamException;

    protected abstract boolean read(XMLStreamReader var1, QName var2, T var3) throws XMLStreamException;
}

