/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDataWithDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractExtensionData;

public abstract class AbstractPropertyData<T>
extends AbstractExtensionData
implements MutablePropertyData<T>,
PropertyDataWithDefinition<T> {
    private static final long serialVersionUID = 1L;
    private String id;
    private String displayName;
    private String localName;
    private String queryName;
    private PropertyDefinition<T> propDef;
    private List<T> values = Collections.emptyList();

    @Override
    public PropertyDefinition<T> getPropertyDefinition() {
        return this.propDef;
    }

    public void setPropertyDefinition(PropertyDefinition<T> propDef) {
        this.propDef = propDef;
        if (propDef != null) {
            this.id = propDef.getId();
            this.displayName = propDef.getDisplayName();
            this.localName = propDef.getLocalName();
            this.queryName = propDef.getQueryName();
        } else {
            this.id = null;
            this.displayName = null;
            this.localName = null;
            this.queryName = null;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    @Override
    public List<T> getValues() {
        return this.values;
    }

    @Override
    public void setValues(List<T> values) {
        this.values = values == null ? Collections.emptyList() : values;
    }

    @Override
    public void setValue(T value) {
        if (value == null) {
            this.values = Collections.emptyList();
        } else {
            this.values = new ArrayList<T>(1);
            this.values.add(value);
        }
    }

    @Override
    public T getFirstValue() {
        if (this.values != null && !this.values.isEmpty()) {
            return this.values.get(0);
        }
        return null;
    }

    @Override
    public String toString() {
        return "Property [id=" + this.id + ", display Name=" + this.displayName + ", local name=" + this.localName + ", query name=" + this.queryName + ", values=" + String.valueOf(this.values) + "]" + super.toString();
    }
}

