/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.MutableTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeMutability;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractExtensionData;

public abstract class AbstractTypeDefinition
extends AbstractExtensionData
implements MutableTypeDefinition {
    private static final long serialVersionUID = 2L;
    private String id;
    private String localName;
    private String localNamespace;
    private String queryName;
    private String displayName;
    private String description;
    private BaseTypeId baseId;
    private String parentId;
    private Boolean isCreatable;
    private Boolean isFileable;
    private Boolean isQueryable;
    private Boolean isIncludedInSupertypeQuery;
    private Boolean isFulltextIndexed;
    private Boolean isControllableACL;
    private Boolean isControllablePolicy;
    private LinkedHashMap<String, PropertyDefinition<?>> propertyDefinitions = new LinkedHashMap();
    private TypeMutability typeMutability;

    public void initialize(TypeDefinition typeDefinition) {
        assert (typeDefinition != null);
        this.setId(typeDefinition.getId());
        this.setLocalName(typeDefinition.getLocalName());
        this.setLocalNamespace(typeDefinition.getLocalNamespace());
        this.setQueryName(typeDefinition.getQueryName());
        this.setDisplayName(typeDefinition.getDisplayName());
        this.setDescription(typeDefinition.getDescription());
        this.setBaseTypeId(typeDefinition.getBaseTypeId());
        this.setParentTypeId(typeDefinition.getParentTypeId());
        this.setIsCreatable(typeDefinition.isCreatable());
        this.setIsFileable(typeDefinition.isFileable());
        this.setIsQueryable(typeDefinition.isQueryable());
        this.setIsIncludedInSupertypeQuery(typeDefinition.isIncludedInSupertypeQuery());
        this.setIsFulltextIndexed(typeDefinition.isFulltextIndexed());
        this.setIsControllableAcl(typeDefinition.isControllableAcl());
        this.setIsControllablePolicy(typeDefinition.isControllablePolicy());
        this.setPropertyDefinitions(typeDefinition.getPropertyDefinitions());
        this.setTypeMutability(typeDefinition.getTypeMutability());
        this.setExtensions(typeDefinition.getExtensions());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    @Override
    public String getLocalNamespace() {
        return this.localNamespace;
    }

    @Override
    public void setLocalNamespace(String localNamespace) {
        this.localNamespace = localNamespace;
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public BaseTypeId getBaseTypeId() {
        return this.baseId;
    }

    @Override
    public void setBaseTypeId(BaseTypeId baseId) {
        this.baseId = baseId;
    }

    @Override
    public String getParentTypeId() {
        return this.parentId;
    }

    @Override
    public void setParentTypeId(String parentId) {
        this.parentId = parentId == null || parentId.length() == 0 ? null : parentId;
    }

    @Override
    public Boolean isCreatable() {
        return this.isCreatable;
    }

    @Override
    public void setIsCreatable(Boolean isCreatable) {
        this.isCreatable = isCreatable;
    }

    @Override
    public Boolean isFileable() {
        return this.isFileable;
    }

    @Override
    public void setIsFileable(Boolean isFileable) {
        this.isFileable = isFileable;
    }

    @Override
    public Boolean isQueryable() {
        return this.isQueryable;
    }

    @Override
    public void setIsQueryable(Boolean isQueryable) {
        this.isQueryable = isQueryable;
    }

    @Override
    public Boolean isIncludedInSupertypeQuery() {
        return this.isIncludedInSupertypeQuery;
    }

    @Override
    public void setIsIncludedInSupertypeQuery(Boolean isIncludedInSupertypeQuery) {
        this.isIncludedInSupertypeQuery = isIncludedInSupertypeQuery;
    }

    @Override
    public Boolean isFulltextIndexed() {
        return this.isFulltextIndexed;
    }

    @Override
    public void setIsFulltextIndexed(Boolean isFulltextIndexed) {
        this.isFulltextIndexed = isFulltextIndexed;
    }

    @Override
    public Boolean isControllableAcl() {
        return this.isControllableACL;
    }

    @Override
    public void setIsControllableAcl(Boolean isControllableACL) {
        this.isControllableACL = isControllableACL;
    }

    @Override
    public Boolean isControllablePolicy() {
        return this.isControllablePolicy;
    }

    @Override
    public void setIsControllablePolicy(Boolean isControllablePolicy) {
        this.isControllablePolicy = isControllablePolicy;
    }

    @Override
    public Map<String, PropertyDefinition<?>> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public void setPropertyDefinitions(Map<String, PropertyDefinition<?>> newPropertyDefinitions) {
        this.propertyDefinitions = newPropertyDefinitions == null ? new LinkedHashMap() : (newPropertyDefinitions instanceof LinkedHashMap ? (LinkedHashMap<Object, Object>)newPropertyDefinitions : new LinkedHashMap(newPropertyDefinitions));
    }

    @Override
    public void addPropertyDefinition(PropertyDefinition<?> propertyDefinition) {
        if (propertyDefinition == null) {
            return;
        }
        this.propertyDefinitions.put(propertyDefinition.getId(), propertyDefinition);
    }

    @Override
    public void removePropertyDefinition(String propertyId) {
        if (propertyId == null) {
            return;
        }
        this.propertyDefinitions.remove(propertyId);
    }

    @Override
    public void removeAllPropertyDefinitions() {
        this.propertyDefinitions = new LinkedHashMap();
    }

    @Override
    public TypeMutability getTypeMutability() {
        return this.typeMutability;
    }

    @Override
    public void setTypeMutability(TypeMutability typeMutability) {
        this.typeMutability = typeMutability;
    }

    @Override
    public String toString() {
        return "Type Definition [base id=" + String.valueOf((Object)this.baseId) + ", id=" + this.id + ", display Name=" + this.displayName + ", description=" + this.description + ", local name=" + this.localName + ", local namespace=" + this.localNamespace + ", query name=" + this.queryName + ", parent id=" + this.parentId + ", is controllable ACL=" + String.valueOf(this.isControllableACL) + ", is controllable policy=" + String.valueOf(this.isControllablePolicy) + ", is creatable=" + String.valueOf(this.isCreatable) + ", is fileable=" + String.valueOf(this.isFileable) + ", is fulltext indexed=" + String.valueOf(this.isFulltextIndexed) + ", is included in supertype query=" + String.valueOf(this.isIncludedInSupertypeQuery) + ", is queryable=" + String.valueOf(this.isQueryable) + ", property definitions=" + String.valueOf(this.propertyDefinitions) + ", typeMutability=" + String.valueOf(this.typeMutability) + "]" + super.toString();
    }
}

