/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.endpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.chemistry.opencmis.commons.endpoints.CmisAuthentication;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpoint;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpointsDocument;

public class CmisEndpointsDocumentImpl
extends LinkedHashMap<String, Object>
implements CmisEndpointsDocument {
    private static final long serialVersionUID = 1L;

    public CmisEndpointsDocumentImpl() {
    }

    public CmisEndpointsDocumentImpl(List<CmisEndpoint> endpoints) {
        this.put("endpoints", endpoints);
    }

    @Override
    public List<CmisEndpoint> getEndpoints() {
        Object endpoints = this.get("endpoints");
        if (endpoints instanceof List) {
            return Collections.unmodifiableList((List)endpoints);
        }
        return Collections.emptyList();
    }

    @Override
    public List<CmisAuthentication> getAuthenticationsSortedByPreference() {
        ArrayList<CmisAuthentication> result = new ArrayList<CmisAuthentication>();
        for (CmisEndpoint endpoint : this.getEndpoints()) {
            for (CmisAuthentication authentication : endpoint.getAuthentications()) {
                result.add(authentication);
            }
        }
        Collections.sort(result, new Comparator<CmisAuthentication>(){

            @Override
            public int compare(CmisAuthentication ap1, CmisAuthentication ap2) {
                if (ap1.getPreference() == null && ap2.getPreference() == null) {
                    return 0;
                }
                if (ap1.getPreference() == null) {
                    return 1;
                }
                if (ap2.getPreference() == null) {
                    return -1;
                }
                return ap1.getPreference().compareTo(ap2.getPreference());
            }
        });
        return result;
    }
}

