/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.common.handler;

import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.transactions.TransactionKeyspace;
import com.couchbase.client.java.transactions.config.TransactionsConfig;
import java.nio.file.Paths;

public interface ClusterHandler {
    public static final String SEMAPHORE_MESSAGE = "Incorrect Semaphore";

    public void setClusterAndAsync(Cluster var1);

    public Cluster getCluster();

    public AsyncCluster getAsyncCluster();

    public void setClusterEnvironment(ClusterEnvironment var1);

    public ClusterEnvironment getClusterEnvironment();

    default public void connect(String connectionURL, String auhenticationMethod, String user, String password, String rawOnlyEnablePlainSaslMechanism, String certificatePath, BucketScopeCollection bucketScopeCollection) throws Exception {
        ClusterOptions clusterOptions = null;
        Boolean onlyEnablePlainSaslMechanism = Boolean.valueOf(rawOnlyEnablePlainSaslMechanism);
        if (onlyEnablePlainSaslMechanism != null && onlyEnablePlainSaslMechanism.booleanValue()) {
            PasswordAuthenticator authenticator = PasswordAuthenticator.builder().username(user).password(password).onlyEnablePlainSaslMechanism().build();
            clusterOptions = ClusterOptions.clusterOptions((Authenticator)authenticator);
        } else {
            clusterOptions = ClusterOptions.clusterOptions((String)user, (String)password);
        }
        if (bucketScopeCollection != null) {
            TransactionKeyspace keyspace = TransactionKeyspace.create((String)bucketScopeCollection.getBucket(), (String)bucketScopeCollection.getScope(), (String)bucketScopeCollection.getCollection());
            clusterOptions = clusterOptions.environment(env -> {
                ClusterEnvironment.Builder builder = env.transactionsConfig(TransactionsConfig.durabilityLevel((DurabilityLevel)DurabilityLevel.NONE).metadataCollection(keyspace));
            });
        }
        boolean initializedEnvironment = false;
        ClusterEnvironment.Builder clusterEnvironmentBuilder = ClusterEnvironment.builder();
        if (certificatePath != null && !certificatePath.trim().isEmpty()) {
            clusterEnvironmentBuilder = (ClusterEnvironment.Builder)clusterEnvironmentBuilder.securityConfig(SecurityConfig.enableTls((boolean)true).trustCertificate(Paths.get(certificatePath, new String[0])));
            initializedEnvironment = true;
        }
        if (initializedEnvironment) {
            ClusterEnvironment clusterEnvironment = clusterEnvironmentBuilder.build();
            clusterOptions.environment(clusterEnvironment);
            this.setClusterEnvironment(clusterEnvironment);
        }
        Cluster cluster = Cluster.connect((String)connectionURL, (ClusterOptions)clusterOptions);
        this.setClusterAndAsync(cluster);
    }

    default public void disconnect() {
        ClusterEnvironment clusterEnvironment;
        Cluster cluster = this.getCluster();
        if (cluster != null) {
            cluster.disconnect();
        }
        if ((clusterEnvironment = this.getClusterEnvironment()) != null) {
            clusterEnvironment.shutdown();
        }
    }

    public static class BucketScopeCollection {
        private String bucket;
        private String scope;
        private String collection;

        public BucketScopeCollection(String bucket, String scope, String collection) {
            this.bucket = bucket;
            this.scope = scope;
            this.collection = collection;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getScope() {
            return this.scope;
        }

        public String getCollection() {
            return this.collection;
        }
    }
}

