/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.common.handler.query;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.search.SearchOptions;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.queries.QueryStringQuery;
import com.couchbase.client.java.search.result.SearchResult;
import com.stambia.couchbase.common.QueryType;

public class FtsUtil {
    static String COMMA = String.valueOf(',');

    public static SearchOptions getFtsOptions(String rawFields) {
        String[] parsedFields = rawFields.split(COMMA);
        if (parsedFields != null) {
            int indicesNumber = parsedFields.length;
            int indexNumber = 0;
            while (indexNumber < indicesNumber) {
                parsedFields[indexNumber] = parsedFields[indexNumber].trim();
                ++indexNumber;
            }
        }
        SearchOptions ftsOption = SearchOptions.searchOptions().fields(parsedFields);
        return ftsOption;
    }

    public static SearchResult runFtsQuery(QueryType queryType, String queryString, Cluster cluster, String searchIndex, SearchOptions ftsOptions) {
        QueryStringQuery ftsQuery = null;
        switch (queryType) {
            case QUERYSTRING: {
                ftsQuery = SearchQuery.queryString((String)queryString);
            }
        }
        SearchResult ftsResult = cluster.searchQuery(searchIndex, (SearchQuery)ftsQuery, ftsOptions);
        return ftsResult;
    }
}

