/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration.crud;

import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.transactions.TransactionAttemptContext;
import com.couchbase.client.java.transactions.TransactionGetResult;
import com.couchbase.client.java.transactions.Transactions;
import com.stambia.couchbase.common.Operation;
import com.stambia.couchbase.integration.crud.CouchbaseCrudIntegrator;
import java.io.InputStream;
import java.io.OutputStream;

public final class CouchbaseCrudIntegratorWithTransaction
extends CouchbaseCrudIntegrator {
    private int batchSize = 0;
    private int batchCounter = 0;
    private Transactions transactions = this.cluster.transactions();
    private Exception exception = null;

    public CouchbaseCrudIntegratorWithTransaction(InputStream inputStream, Operation operation, Cluster cluster, Collection collection, OutputStream outputStream, int batchSize) {
        super(inputStream, operation, cluster, collection, outputStream);
        this.batchSize = batchSize;
    }

    @Override
    protected final JsonObject add(String id, JsonObject content) throws Exception {
        JsonObject result = content;
        if (this.operation.isReadOnly()) {
            result = this.get(id);
        } else {
            this.transactions.run(context -> this.runTransaction((TransactionAttemptContext)context, id, content));
            if (this.exception != null) {
                throw this.exception;
            }
        }
        return result;
    }

    private void runTransaction(TransactionAttemptContext context, String id, JsonObject content) {
        try {
            switch (this.operation) {
                case REMOVE: {
                    TransactionGetResult transactionGetResult = context.get(this.collection, id);
                    context.remove(transactionGetResult);
                    ++this.batchCounter;
                    break;
                }
                case UPSERT: {
                    try {
                        TransactionGetResult transactionGetResult = context.get(this.collection, id);
                        this.replace(context, transactionGetResult, content);
                    }
                    catch (DocumentNotFoundException e) {
                        this.insert(context, id, content);
                    }
                    break;
                }
                case INSERT: {
                    this.insert(context, id, content);
                    break;
                }
                case REPLACE: {
                    TransactionGetResult transactionGetResult = context.get(this.collection, id);
                    this.replace(context, transactionGetResult, content);
                    break;
                }
                case UPDATE: {
                    TransactionGetResult transactionGetResult = context.get(this.collection, id);
                    JsonObject document = transactionGetResult.contentAsObject();
                    Object updated = CouchbaseCrudIntegratorWithTransaction.updateJsonObject(document, content);
                    this.replace(context, transactionGetResult, updated);
                }
            }
            if (this.batchCounter == this.batchSize) {
                this.batchCounter = 0;
                this.transactions = this.cluster.transactions();
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void insert(TransactionAttemptContext context, String id, Object content) {
        context.insert(this.collection, id, content);
        ++this.batchCounter;
    }

    private void replace(TransactionAttemptContext context, TransactionGetResult document, Object content) {
        context.replace(document, content);
        ++this.batchCounter;
    }
}

