/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration.query;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.query.QueryOptions;
import com.stambia.couchbase.common.CouchbaseUtil;
import com.stambia.couchbase.integration.CouchbaseIntegrator;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public abstract class CouchbaseQueryIntegrator
extends CouchbaseIntegrator {
    public static final String DOCUMENT = "document";
    protected static final byte[] DOCUMENT_KEY = (CouchbaseUtil.enquote("document") + ':').getBytes();
    protected String rawQueryString = null;
    protected boolean isFirstLine = true;
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected String key = null;
    protected boolean runOnceOrMore = false;
    protected QueryOptions queryOptions;

    public CouchbaseQueryIntegrator(InputStream inputStream, String queryString, Duration timeout, Cluster cluster, OutputStream outputStream) {
        super(inputStream, cluster, outputStream);
        this.rawQueryString = queryString;
        this.queryOptions = QueryOptions.queryOptions().metrics(true);
        if (timeout != null) {
            this.queryOptions = (QueryOptions)this.queryOptions.timeout(timeout);
        }
    }

    protected void putParameter(String rawValue) {
        if (1 < this.depthLevel && !CouchbaseUtil.QUERY_EXCLUDE_PARAMETERS.contains(this.key)) {
            this.parameters.put(this.key, rawValue);
        } else {
            this.putSpecificParameter(rawValue);
        }
    }

    public abstract void putSpecificParameter(String var1);

    public abstract void processQueryValue() throws Exception;

    @Override
    protected void startObject() {
    }

    protected abstract String escapeValue(String var1);

    protected abstract void processRequest(String var1) throws Exception;

    @Override
    protected void keyName(String key) {
        if (1 < this.depthLevel) {
            this.key = key;
        } else {
            this.specificKeyName(key);
        }
    }

    public abstract void specificKeyName(String var1);

    @Override
    protected void valueFalse() {
        this.putParameter("false");
    }

    @Override
    protected void valueTrue() {
        this.putParameter("true");
    }

    @Override
    protected void valueNumber(Number valueNumber) {
        this.putParameter(valueNumber.toString());
    }

    @Override
    protected void valueString(String valueString) {
        this.putParameter(valueString);
    }

    @Override
    protected void endArray() {
    }

    @Override
    protected void startArray() {
    }

    @Override
    protected void valueNull() {
        this.putParameter("null");
    }
}

