/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration.query.n1ql.json;

import com.couchbase.client.java.Cluster;
import com.stambia.couchbase.integration.query.n1ql.json.CouchbaseN1qlJsonIntegrator;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;

public class CouchbaseN1qlJsonFileIntegrator
extends CouchbaseN1qlJsonIntegrator {
    private static final String JSON_EXTENSION = ".json";
    private String exportFolder = null;
    private String exportedFilesPrefix = null;

    public CouchbaseN1qlJsonFileIntegrator(InputStream inputStream, String queryString, Duration timeout, Cluster cluster, String exportFolder, OutputStream outputStream, String exportedFilesPrefix) {
        super(inputStream, queryString, timeout, cluster, outputStream);
        this.exportFolder = exportFolder;
        this.exportedFilesPrefix = exportedFilesPrefix;
    }

    @Override
    public void processQueryValue() throws Exception {
        String jsonFileName = CouchbaseN1qlJsonFileIntegrator.getFileName(this.exportFolder, this.exportedFilesPrefix, JSON_EXTENSION);
        try (OutputStream jsonFileStream = null;){
            jsonFileStream = new BufferedOutputStream(new FileOutputStream(jsonFileName));
            this.writeJson(jsonFileStream);
        }
    }
}

