/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.integration.query.n1ql.json;

import com.couchbase.client.java.Cluster;
import com.stambia.couchbase.integration.query.n1ql.json.CouchbaseN1qlJsonIntegrator;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;

public class CouchbaseN1qlJsonLinesIntegrator
extends CouchbaseN1qlJsonIntegrator {
    private static final String JSON_LINE_EXTENSION = ".jsonl";
    private OutputStream jsonFileStream;
    private static final byte[] LINE_SEPARATOR = "\n".getBytes();

    public CouchbaseN1qlJsonLinesIntegrator(InputStream inputStream, String queryString, Duration timeout, Cluster cluster, String exportFolder, OutputStream outputStream, String exportedFilesPrefix) throws Exception {
        super(inputStream, queryString, timeout, cluster, outputStream);
        String jsonFileName = CouchbaseN1qlJsonLinesIntegrator.getFileName(exportFolder, exportedFilesPrefix, JSON_LINE_EXTENSION);
        this.jsonFileStream = new BufferedOutputStream(new FileOutputStream(jsonFileName));
    }

    @Override
    public void processQueryValue() throws Exception {
        this.writeJson(this.jsonFileStream);
        this.jsonFileStream.write(LINE_SEPARATOR);
    }

    @Override
    public void close() throws IOException {
        if (this.jsonFileStream != null) {
            this.jsonFileStream.close();
        }
        super.close();
    }
}

