/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.transformation;

import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.indy.engine.action.common.SecretValueImpl;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.core.ISecretService;
import com.indy.engine.core.UtilsService;
import com.stambia.couchbase.common.handler.ClusterHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.UnaryOperator;

public abstract class CouchbaseTransformer
extends OutputStreamTransformer
implements ClusterHandler {
    protected static final String USER = "user";
    protected static final String PASSWORD = "password";
    protected static final String CONNECTION_URL = "connectionURL";
    protected static final String ONLY_ENABLE_PLAIN_SASL_MECHANISM = "onlyEnablePlainSaslMechanism";
    private static final String TRANSACTIONAL_MODE = "transactionalMode";
    private static final String BUCKET_NAME = "bucketName";
    private static final String SCOPE_NAME = "scopeName";
    private static final String COLLECTION_NAME = "collectionName";
    private static final String AUHENTICATION_METHOD = "auhenticationMethod";
    private static final String CERTIFICATE_PATH = "certificatePath";
    protected Cluster cluster = null;
    protected AsyncCluster asyncCluster = null;
    protected ClusterEnvironment clusterEnvironment = null;
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected boolean transactionalMode = false;
    protected String bucketName = null;
    protected String scopeName = null;
    protected String collectionName = null;
    UnaryOperator<String> resolveExtValue = t -> {
        try {
            return new SecretValueImpl(t, arg_0 -> ((ISecretService)UtilsService.getSecretService()).decryptString(arg_0), arg_0 -> ((ISecretService)UtilsService.getSecretService()).encryptString(arg_0)).resolveStringSecretValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    };

    public abstract void integrate() throws Exception;

    public void transform(InputStream inputStream, OutputStream outputStream) throws Exception {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        String connectionURL = this.getProperty(CONNECTION_URL);
        String auhenticationMethod = this.getProperty(AUHENTICATION_METHOD);
        String user = this.getProperty(USER);
        String password = this.getProperty(PASSWORD);
        String onlyEnablePlainSaslMechanism = this.getProperty(ONLY_ENABLE_PLAIN_SASL_MECHANISM);
        String certificatePath = this.getProperty(CERTIFICATE_PATH);
        String rawTransactionalMode = this.getProperty(TRANSACTIONAL_MODE);
        this.transactionalMode = rawTransactionalMode != null ? Boolean.valueOf(rawTransactionalMode) : false;
        this.bucketName = this.getProperty(BUCKET_NAME);
        this.scopeName = this.getProperty(SCOPE_NAME);
        this.collectionName = this.getProperty(COLLECTION_NAME);
        ClusterHandler.BucketScopeCollection bucketScopeCollection = this.transactionalMode ? new ClusterHandler.BucketScopeCollection(this.bucketName, this.scopeName, this.collectionName) : null;
        try {
            this.connect((String)this.resolveExtValue.apply(connectionURL), auhenticationMethod, (String)this.resolveExtValue.apply(user), (String)this.resolveExtValue.apply(password), onlyEnablePlainSaslMechanism, certificatePath, bucketScopeCollection);
            this.integrate();
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    public final void setClusterAndAsync(Cluster cluster) {
        this.cluster = cluster;
        this.asyncCluster = cluster.async();
    }

    @Override
    public final Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public final AsyncCluster getAsyncCluster() {
        return this.asyncCluster;
    }

    @Override
    public final void setClusterEnvironment(ClusterEnvironment clusterEnvironment) {
        this.clusterEnvironment = clusterEnvironment;
    }

    @Override
    public final ClusterEnvironment getClusterEnvironment() {
        return this.clusterEnvironment;
    }
}

