/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.couchbase.transformation.query.n1ql;

import com.indy.engine.common.tools.OutputStreamTransformer;
import com.stambia.couchbase.integration.query.CouchbaseQueryIntegrator;
import com.stambia.couchbase.integration.query.n1ql.json.CouchbaseN1qlJsonFileIntegrator;
import com.stambia.couchbase.integration.query.n1ql.json.CouchbaseN1qlJsonIntegrator;
import com.stambia.couchbase.integration.query.n1ql.json.CouchbaseN1qlJsonLinesIntegrator;
import com.stambia.couchbase.integration.query.n1ql.json.ExportMethod;
import com.stambia.couchbase.transformation.query.n1ql.CouchbaseN1qlTransformer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;

public class CouchbaseN1qlJsonTransformer
extends CouchbaseN1qlTransformer {
    private static final String OUT_NB_JSON_FILES = "OUT_NB_JSON_FILES";
    private String exportFolder = null;
    private String exportedFilesPrefix = null;
    private ExportMethod exportMethod = null;
    protected static final String EXPORT_FOLDER = "exportFolder";
    protected static final String EXPORTED_FILES_PREFIX = "exportedFilesPrefix";
    protected static final String EXPORT_METHOD = "exportMethod";

    @Override
    protected void getExtraProperties() throws Exception {
        super.getExtraProperties();
        this.exportFolder = this.getProperty(EXPORT_FOLDER);
        this.exportedFilesPrefix = this.getProperty(EXPORTED_FILES_PREFIX);
        String rawExportMethod = this.getProperty(EXPORT_METHOD);
        this.exportMethod = ExportMethod.fromString(rawExportMethod);
        if (!new File(this.exportFolder).exists()) {
            Files.createDirectories(Paths.get(this.exportFolder, new String[0]), new FileAttribute[0]);
        }
    }

    @Override
    public CouchbaseQueryIntegrator setQueryIntegrator(String queryString, Duration timeout) throws Exception {
        CouchbaseN1qlJsonIntegrator couchbaseN1qlJsonIntegrator = ExportMethod.MULTIPLE_OUTPUT_FILES_JSON_FORMAT.equals((Object)this.exportMethod) ? new CouchbaseN1qlJsonFileIntegrator(this.inputStream, queryString, timeout, this.cluster, this.exportFolder, this.outputStream, this.exportedFilesPrefix) : new CouchbaseN1qlJsonLinesIntegrator(this.inputStream, queryString, timeout, this.cluster, this.exportFolder, this.outputStream, this.exportedFilesPrefix);
        return couchbaseN1qlJsonIntegrator;
    }

    @Override
    protected void handleStatistics(OutputStreamTransformer.OutputStreamTransformerStatisticHandler statisticHandler, Map<String, Number> statistics) throws Exception {
        super.handleStatistics(statisticHandler, statistics);
        statisticHandler.handle(OUT_NB_JSON_FILES, ((Long)statistics.get("RESULT_COUNT")).longValue());
    }
}

