/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.mongodb.action;

import com.indy.addons.mongodb.action.Messages;
import com.indy.addons.mongodb.action.MongoClientUtil;
import com.indy.addons.mongodb.action.ReverseDocAction;
import com.indy.runtime.json.JsonUtils;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoDatabase;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.emf.ecore.EObject;

public class ReverseDocActionOnFind
extends ReverseDocAction {
    private static final Logger LOGGER = Logger.getLogger(ReverseDocActionOnFind.class.getName());
    private static final String UTF_8 = StandardCharsets.UTF_8.name();

    @Override
    protected List<MdNode> getNodes(MongoClient mongoClient, MdNode node) throws XPathExpressionException, ReverseException {
        MdNode databaseNode = (MdNode)node.eContainer();
        String databasePhysicalName = databaseNode.evaluate("@physicalName");
        MdNode result = null;
        try {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(databasePhysicalName);
            String collectionPhysicalName = node.evaluate("@collection");
            if (collectionPhysicalName == null || collectionPhysicalName.isEmpty()) {
                throw new ReverseException(Messages.ReverseDocActionOnFind_2);
            }
            String findQuery = node.evaluate("@query");
            if (findQuery == null || findQuery.isEmpty()) {
                throw new ReverseException(Messages.ReverseDocActionOnFind_4);
            }
            List nodes = (List)node.evaluateMdSet("*[name()='value' and @name!='document']");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            for (MdNode o : nodes) {
                String val = o.evaluate("@reverseValue");
                if (val == null) continue;
                String type = o.evaluate("@type");
                if (type != null && type.equals("string")) {
                    inputParams.put(o.getName(), "\"" + val + "\"");
                    continue;
                }
                inputParams.put(o.getName(), val);
            }
            result = MdFactoryHelper.createMdNode((String)"com.stambia.json.array");
            result.setSubstituteContainer((EObject)node);
            result.setName("result");
            MdNode document = MdFactoryHelper.createMdNode((String)"com.stambia.json.object");
            document.setSubstituteContainer((EObject)result);
            document.setName("document");
            result.getNode().add((Object)document);
            Document documentQuery = this.buildQuery(findQuery, inputParams);
            this.reverseType(document, (FindIterable<Document>)mongoDatabase.getCollection(collectionPhysicalName).find((Bson)documentQuery));
        }
        catch (Exception e) {
            MongoClientUtil.manageAuthorizationErrorOnReverse(e);
        }
        return List.of(result);
    }

    private Document buildQuery(String findQuery, Map<String, String> inputParams) throws ReverseException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JsonUtils.convertJsonToXml((InputStream)new ByteArrayInputStream(findQuery.getBytes(UTF_8)), (OutputStream)os, (String)UTF_8, (String)UTF_8, (boolean)false, inputParams);
            ByteArrayOutputStream os2 = new ByteArrayOutputStream();
            JsonUtils.convertXmlToJson((InputStream)new ByteArrayInputStream(os.toByteArray()), (OutputStream)os2, (String)UTF_8, (String)UTF_8);
            String query = new String(os2.toByteArray());
            return Document.parse((String)query);
        }
        catch (IOException | XMLStreamException e) {
            throw new ReverseException((Throwable)e);
        }
    }
}

