/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.delivery.repository.aws.s3.impl;

import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.runtime.utils.IOUtils;
import com.semarchy.xdi.delivery.repository.aws.s3.impl.AmazonS3Storage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AmazonS3Repository
implements IDeliveryRepositoryPlugin {
    private final AmazonS3Storage store;
    protected File cacheFolder = null;
    protected final Map<String, DeliveryInfoWrapper> deliveriesInfo = Collections.synchronizedMap(new HashMap());
    protected static final String FILE_EXTENSION = ".deliv";
    protected static final String PATH_SEPARATOR = "/";
    private long lastRefreshTime = 0L;

    public AmazonS3Repository(IPluginFactory.IPluginConfiguration configuration) {
        this.store = this.createStore(configuration);
    }

    protected AmazonS3Storage createStore(IPluginFactory.IPluginConfiguration configuration) {
        return new AmazonS3Storage(configuration, (AwsCredentialsProvider)DefaultCredentialsProvider.create());
    }

    public File getDeliveryContent(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) throws Exception {
        if (deliveryInfo.getFile() == null) {
            String deliveryName = deliveryInfo.getName();
            deliveryInfo = this.getDeliveryInfo(deliveryName);
        }
        return deliveryInfo.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfo(boolean refresh) throws Exception {
        if (refresh && System.currentTimeMillis() - this.lastRefreshTime > this.store.getRefreshDelay()) {
            this.lastRefreshTime = System.currentTimeMillis();
            HashMap<String, DeliveryInfoWrapper> currInfos = new HashMap<String, DeliveryInfoWrapper>();
            List<S3Object> results = this.store.getList();
            for (S3Object item : results) {
                if (!item.key().endsWith(FILE_EXTENSION)) continue;
                String deliveryName = this.getDeliveryNameFromObject(item);
                IDeliveryRepositoryPlugin.DeliveryInfo info = this.createDeliveryInfo(item);
                currInfos.put(deliveryName, new DeliveryInfoWrapper(info, item.lastModified().toEpochMilli()));
            }
            List<String> keys = this.getKeysDifference(currInfos);
            for (String key : keys) {
                this.deliveriesInfo.remove(key);
            }
            Map<String, DeliveryInfoWrapper> map = this.deliveriesInfo;
            synchronized (map) {
                for (Map.Entry<String, DeliveryInfoWrapper> entry : currInfos.entrySet()) {
                    String key = entry.getKey();
                    DeliveryInfoWrapper currInfo = currInfos.get(key);
                    DeliveryInfoWrapper oldInfo = this.deliveriesInfo.get(key);
                    if (oldInfo != null && oldInfo.getLastUpdateTimestamp().equals(currInfo.getLastUpdateTimestamp())) continue;
                    this.deliveriesInfo.put(key, currInfo);
                }
            }
        }
        return this.getDeliveriesInfoUnwrapped(this.deliveriesInfo);
    }

    private List<String> getKeysDifference(HashMap<String, DeliveryInfoWrapper> currInfos) {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, DeliveryInfoWrapper> entry : currInfos.entrySet()) {
            if (this.deliveriesInfo.containsKey(entry.getKey())) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    private Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfoUnwrapped(Map<String, DeliveryInfoWrapper> infos) {
        HashMap<String, IDeliveryRepositoryPlugin.DeliveryInfo> delivMap = new HashMap<String, IDeliveryRepositoryPlugin.DeliveryInfo>();
        for (Map.Entry<String, DeliveryInfoWrapper> entry : infos.entrySet()) {
            String key = entry.getKey();
            DeliveryInfoWrapper wrappedDeliv = infos.get(key);
            delivMap.put(key, wrappedDeliv.getInfo());
        }
        return delivMap;
    }

    private IDeliveryRepositoryPlugin.DeliveryInfo createDeliveryInfo(S3Object object) throws IOException {
        IDeliveryRepositoryPlugin.DeliveryInfo info = new IDeliveryRepositoryPlugin.DeliveryInfo();
        String deliveryName = this.getDeliveryNameFromObject(object);
        info.setName(deliveryName);
        info.setFile(this.getFile(object.key(), (InputStream)this.store.getObject(object.key())));
        return info;
    }

    private File getFile(String fileName, InputStream is) throws IOException {
        File f = new File(this.cacheFolder, fileName);
        f.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return f;
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo getDeliveryInfo(String deliveryName) throws Exception {
        this.getDeliveriesInfo(true);
        DeliveryInfoWrapper wrapper = this.deliveriesInfo.get(deliveryName);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getInfo();
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo putDelivery(InputStream inputStream, String deliveryName) throws Exception {
        Object info = null;
        StringBuilder fileName = new StringBuilder(deliveryName);
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            fileName.append(FILE_EXTENSION);
        }
        return this.store.createDelivery(fileName.toString(), this.getFile(fileName.toString(), inputStream), this.cacheFolder);
    }

    public void removeDelivery(String deliveryName) throws Exception {
        StringBuilder sb = new StringBuilder(deliveryName);
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            sb.append(FILE_EXTENSION);
        }
        this.store.removeDelivery(sb.toString());
        this.deliveriesInfo.remove(deliveryName);
    }

    public IDeliveryRepositoryInfo getInfos() {
        return this.store;
    }

    public void setCacheFolder(File cacheFolder) {
        this.cacheFolder = cacheFolder;
    }

    private String getDeliveryNameFromObject(S3Object object) {
        String name = object.key();
        int pathLength = 0;
        if (!this.store.getPath().isEmpty()) {
            pathLength = this.store.getPath().length() + 1;
        }
        name = name.substring(pathLength, name.lastIndexOf("."));
        return name;
    }

    private class DeliveryInfoWrapper {
        private IDeliveryRepositoryPlugin.DeliveryInfo info;
        private long lastUpdateTimestamp;

        public DeliveryInfoWrapper(IDeliveryRepositoryPlugin.DeliveryInfo info, long timestamp) {
            this.info = info;
            this.lastUpdateTimestamp = timestamp;
        }

        public IDeliveryRepositoryPlugin.DeliveryInfo getInfo() {
            return this.info;
        }

        public Long getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }
    }
}

