/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.sapS4hana.runtime;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.utils.InOutTemporaryFile;
import com.indy.engine.actionCodes.utils.XmlDataTypeProvider;
import com.indy.engine.core.actionCodes.convert.AbstractDataTypeConverter;
import com.sap.conn.jco.JCoDestination;
import com.semarchy.xdi.component.sapS4hana.runtime.Messages;
import com.semarchy.xdi.component.sapS4hana.runtime.SapAbstractActionCodeI;
import com.semarchy.xdi.component.sapS4hana.runtime.SapRfcWithXml;
import com.semarchy.xdi.component.sapS4hana.runtime.XmlReaderWriter;
import com.semarchy.xdi.component.sapS4hana.runtime.utils.JCOProvider;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SapRfcActionCodeI
extends SapAbstractActionCodeI {
    private InputStream isMetaData;
    private SapRfcWithXml sapBapiWithXml;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    InOutTemporaryFile iotf = new InOutTemporaryFile((ActionCodeTypeI)this);
    int rfcInvocation;
    int importFieldNumber;
    int exportFieldNumber;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    String destinationId = UUID.randomUUID().toString();

    public SapRfcActionCodeI() {
        super("Sap With Rfc", true);
    }

    @Override
    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        XmlDataTypeProvider dataTypeProvider;
        super.prepare(sourceRSet);
        String rootName = this.getLocalStringBindedParameter(sourceRSet, "SAP_ROOT_NAME");
        try {
            this.isMetaData = new ByteArrayInputStream(this.actionTxtCode.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e1) {
            throw new EngineExceptionI(Messages.getString("SapRfcActionCodeI.0"), (Throwable)e1);
        }
        String encoding = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_ENCODING", null);
        String xmlOutPutFactoryClassName = this.getLocalStringBindedParameter(sourceRSet, "XML_OUTPUT_FACTORY", null);
        String xmlInPutFactoryClassName = this.getLocalStringBindedParameter(sourceRSet, "XML_INPUT_FACTORY", null);
        String dataTypeProviderClassName = this.getLocalStringBindedParameter(sourceRSet, "DATA_TYPE_PROVIDER", null);
        if (dataTypeProviderClassName != null) {
            try {
                Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(dataTypeProviderClassName);
                dataTypeProvider = (AbstractDataTypeConverter)clazz.newInstance();
            }
            catch (Exception e) {
                throw new EngineExceptionI(Messages.getString("SapRfcActionCodeI.1") + dataTypeProviderClassName, (Throwable)e);
            }
        } else {
            dataTypeProvider = new XmlDataTypeProvider();
        }
        XmlReaderWriter.rc = this.runtimeContext;
        this.sapBapiWithXml = new SapRfcWithXml(rootName, (AbstractDataTypeConverter)dataTypeProvider){

            @Override
            protected void handleStatistics(int rfcInvocation, int importFieldNumber, int exportFieldNumber) {
            }

            @Override
            protected void handleEndInvocation() {
                SapRfcActionCodeI.this.writeStatistics();
            }

            @Override
            protected void handleStartInvocation() {
                SapRfcActionCodeI.this.writeStatistics();
            }
        };
        this.sapBapiWithXml.setEncoding(encoding);
        this.sapBapiWithXml.setXmlOutPutFactoryClassName(xmlOutPutFactoryClassName);
        this.sapBapiWithXml.setXmlInPutFactoryClassName(xmlInPutFactoryClassName);
        try {
            this.iotf.prepare(sourceRSet);
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return 0;
    }

    private void writeStatistics() {
        this.publishVariable("SAP_RFC_IMPORT_FIELDS", this.sapBapiWithXml.getImportFieldNumber());
        this.publishVariable("SAP_RFC_EXPORT_FIELDS", this.sapBapiWithXml.getExportFieldNumber());
        this.publishVariable("SAP_RFC_INVOCATIONS", this.sapBapiWithXml.getRfcInvocation());
    }

    public int finalizeExecuteCode() throws EngineExceptionI {
        try {
            if (this.sapBapiWithXml != null) {
                this.writeStatistics();
                this.sapBapiWithXml.clear();
            }
            this.iotf.close();
            JCOProvider.getInstance().removeDestinationProperties(this.destinationId);
            if (this.isMetaData != null) {
                this.isMetaData.close();
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return 0;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        try {
            try {
                this.iotf.initInput();
                this.iotf.initOuput();
                this.sapBapiWithXml.initMetaData(this.isMetaData);
                JCoDestination destination = SapRfcActionCodeI.connect(this, this.destinationId);
                this.sapBapiWithXml.setDestination(destination);
                this.sapBapiWithXml.readAndWriteFile(this.iotf.getInputStream(), this.iotf.getOutputStream());
                this.iotf.finalizeOutput();
            }
            catch (EngineExceptionI e) {
                throw e;
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            try {
                this.iotf.close();
                if (this.isMetaData != null) {
                    this.isMetaData.close();
                    this.isMetaData = null;
                }
                JCOProvider.getInstance().removeDestinationProperties(this.destinationId);
            }
            catch (IOException e) {
                this.logger.warn("Error while closing", (Throwable)e);
            }
        }
        return 0;
    }
}

