/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.service.bus;

import com.azure.core.util.IterableStream;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusReceiverClient;
import com.indy.engine.core.IActionBind;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.semarchy.xdi.component.azure.service.bus.AzureServiceBusActionCode;
import com.semarchy.xdi.component.azure.service.bus.MessageColumn;
import com.semarchy.xdi.component.azure.service.bus.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;

public abstract class AzureServiceBusReceiverActionCode
extends AzureServiceBusActionCode {
    protected ServiceBusReceiverClient client;
    protected int maxMessages = 0;
    protected Duration maxWaitTime = null;
    private int messageCount = 0;

    protected AzureServiceBusReceiverActionCode(String actionCodeName, boolean bNullCodeAllowed) {
        super(actionCodeName, bNullCodeAllowed);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        IActionBind aBind = this.getActionContext().getActionBind();
        if (aBind != null) {
            this.readMessages();
            return super.executeSimpleCode();
        }
        throw new EngineExceptionI(Messages.getString("AzureServiceBusReceiveQueueMessageActionCode.9"));
    }

    private void readMessages() throws EngineExceptionI {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (final IPreparedStatementToResultSet jpstrs = (IPreparedStatementToResultSet)this.getActionContext().createBindePreparedStatement();){
                this.setColumns(jpstrs);
                this.getActionContext().bindWithTarget(new NotFetchedResultSetBindI(){

                    public ResultSet initResultSet(String id) throws SQLException {
                        return jpstrs.getResultSet(id);
                    }

                    public ResultSet getResultSet(String id) throws SQLException {
                        return jpstrs.getResultSet(id);
                    }

                    public void closeResultSet(String id) throws SQLException {
                        ResultSet rs = jpstrs.getResultSet(id);
                        if (rs != null) {
                            rs.close();
                        }
                    }
                });
                IterableStream messages = this.maxWaitTime != null ? this.client.receiveMessages(this.maxMessages, this.maxWaitTime) : this.client.receiveMessages(this.maxMessages);
                for (ServiceBusReceivedMessage message : messages) {
                    this.handleMessage(jpstrs, message);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EngineExceptionI((Throwable)e);
        }
    }

    private void handleMessage(IPreparedStatementToResultSet jpstrs, ServiceBusReceivedMessage message) throws SQLException {
        ++this.messageCount;
        MessageColumn[] messageColumnArray = MessageColumn.values();
        int n = messageColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageColumn column = messageColumnArray[n2];
            jpstrs.setObject(column.index(), column.getValueFromMessage(message));
            ++n2;
        }
        jpstrs.executeUpdate();
        this.client.complete(message);
        this.publishStatistic("AZURE_SERVICE_BUS_RECEIVED_MESSAGES", this.messageCount, false);
    }

    private void setColumns(IPreparedStatementToResultSet jpstrs) throws SQLException {
        MessageColumn[] messageColumnArray = MessageColumn.values();
        int n = messageColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageColumn column = messageColumnArray[n2];
            jpstrs.setColumn(column.index(), column.name(), column.sqlType());
            ++n2;
        }
    }

    public int finalizeSimpleExecuteCode() throws EngineExceptionI {
        this.publishStatistic("AZURE_SERVICE_BUS_RECEIVED_MESSAGES", this.messageCount, true);
        this.client.close();
        return super.finalizeSimpleExecuteCode();
    }
}

