/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.vertica.export.objects;

import com.indy.engine.addons.vertica.export.objects.definitions.PrimaryKeyDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.ProjectionColumnDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.ProjectionDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.TableColumnDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.TableDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.UniqueKeyDefinition;
import java.util.ArrayList;
import java.util.Arrays;

public class Parser {
    private TableDefinition table = new TableDefinition();
    private String exportObjectsStatement = "";
    private ProjectionDefinition projection;
    private boolean inCreateTable;
    private boolean inCreateTableColumnList;
    private boolean inCreateProjection;
    private boolean inCreateProjectionColumnList;
    private boolean inCreateProjectionSelectStatement;
    private boolean inCreateProjectionSelectStatementSelect;
    private boolean inCreateProjectionSelectStatementFrom;
    private boolean inCreateProjectionSelectStatementWhere;
    private boolean inCreateProjectionSelectStatementGroupBy;
    private boolean inCreateProjectionSelectStatementOrderBy;
    private boolean inCreateProjectionSelectStatementSegemented;
    private boolean inCreateProjectionSelectStatementKsafe;
    private boolean inCreateProjectionSelectStatementLimit;
    private boolean inCreateProjectionSelectStatementOver;
    private boolean inAlterTable;
    private int ordinalPosition;
    private int sortPosition;
    private StringBuilder sb;

    public Parser() {
    }

    public Parser(String exportObjectsStatement) {
        this();
        this.setExportObjectsStatement(exportObjectsStatement);
    }

    public void parse() {
        this.table = new TableDefinition();
        if (this.exportObjectsStatement == null || this.exportObjectsStatement.trim().length() == 0) {
            throw new RuntimeException("The Parser does not have any statement to parse. Please use setExportObjectsStatement(String exportObjectsStatement) to set the statement to parse");
        }
        String[] lines = this.exportObjectsStatement.split("\n");
        this.inCreateTable = false;
        this.inCreateTableColumnList = false;
        this.inCreateProjection = false;
        this.inCreateProjectionColumnList = false;
        this.inCreateProjectionSelectStatement = false;
        this.inCreateProjectionSelectStatementSelect = false;
        this.inCreateProjectionSelectStatementFrom = false;
        this.inCreateProjectionSelectStatementWhere = false;
        this.inCreateProjectionSelectStatementOrderBy = false;
        this.inCreateProjectionSelectStatementGroupBy = false;
        this.inCreateProjectionSelectStatementSegemented = false;
        this.inCreateProjectionSelectStatementKsafe = false;
        this.inCreateProjectionSelectStatementLimit = false;
        this.inCreateProjectionSelectStatementOver = false;
        this.inAlterTable = false;
        this.ordinalPosition = 0;
        this.sortPosition = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).length() > 0) {
                if (line.startsWith("CREATE TABLE ")) {
                    this.inCreateTable = true;
                    line = line.replaceAll("^CREATE TABLE ", "").trim();
                    this.inCreateTableColumnList = false;
                    this.ordinalPosition = 0;
                    if (line.contains(".")) {
                        this.table.setSchemaName(line.split("\\.")[0]);
                        this.table.setTableName(line.split("\\.")[1]);
                    } else {
                        this.table.setTableName(line);
                    }
                } else if (line.startsWith("CREATE PROJECTION ")) {
                    this.sortPosition = 0;
                    this.inCreateProjection = true;
                    this.inCreateProjectionSelectStatement = false;
                    this.inCreateProjectionColumnList = false;
                    this.inCreateProjectionSelectStatementSelect = false;
                    this.inCreateProjectionSelectStatementFrom = false;
                    this.inCreateProjectionSelectStatementWhere = false;
                    this.inCreateProjectionSelectStatementGroupBy = false;
                    this.inCreateProjectionSelectStatementOrderBy = false;
                    this.inCreateProjectionSelectStatementSegemented = false;
                    this.inCreateProjectionSelectStatementKsafe = false;
                    this.inCreateProjectionSelectStatementLimit = false;
                    this.inCreateProjectionSelectStatementOver = false;
                    line = line.replaceAll("^CREATE PROJECTION ", "").trim();
                    this.projection = new ProjectionDefinition();
                    this.projection.setMainTableAlias(this.table.getTableName());
                    if (line.contains(".")) {
                        this.projection.setSchemaName(line.split("\\.")[0]);
                        this.projection.setProjectionName(line.split("\\.")[1].split(" ")[0]);
                    } else {
                        this.projection.setProjectionName(line.split(" ")[0]);
                    }
                } else {
                    if (line.startsWith("ALTER TABLE ")) {
                        this.inAlterTable = true;
                        this.sb = new StringBuilder();
                    }
                    if (this.inCreateTable) {
                        if (line.endsWith(";")) {
                            line = line.substring(0, line.length() - 1);
                            this.inCreateTable = false;
                        }
                        if (line.equals("(")) {
                            this.inCreateTableColumnList = true;
                        } else if (line.equals(")")) {
                            this.inCreateTableColumnList = false;
                        } else if (this.inCreateTableColumnList) {
                            if (line.endsWith(",")) {
                                line = line.substring(0, line.length() - 1);
                            }
                            if (line.startsWith("CONSTRAINT ")) {
                                this.parseConstraint(line);
                            } else {
                                this.parseTableColumn(line);
                            }
                        } else if (line.startsWith("PARTITION BY ")) {
                            line = line.replaceAll("^PARTITION BY ", "").trim();
                            this.table.setPartitionExpression(line);
                        } else {
                            throw new RuntimeException("An unexpected token was found at the following line: " + line);
                        }
                    }
                    if (this.inCreateProjection) {
                        if (line.endsWith(";")) {
                            line = line.substring(0, line.length() - 1);
                            this.parseProjectionSelectStatement(line);
                            this.inCreateProjection = false;
                            this.inCreateProjectionColumnList = false;
                            this.inCreateProjectionSelectStatement = false;
                            this.inCreateProjectionSelectStatement = false;
                            this.inCreateProjectionColumnList = false;
                            this.inCreateProjectionSelectStatementSelect = false;
                            this.inCreateProjectionSelectStatementFrom = false;
                            this.inCreateProjectionSelectStatementWhere = false;
                            this.inCreateProjectionSelectStatementGroupBy = false;
                            this.inCreateProjectionSelectStatementOrderBy = false;
                            this.inCreateProjectionSelectStatementSegemented = false;
                            this.inCreateProjectionSelectStatementKsafe = false;
                            this.inCreateProjectionSelectStatementLimit = false;
                            this.inCreateProjectionSelectStatementOver = false;
                            boolean isSuperProjection = true;
                            if (this.projection.isAggregate()) {
                                isSuperProjection = false;
                            }
                            if (this.projection.isTopK()) {
                                isSuperProjection = false;
                            }
                            if (this.projection.hasWhereClause()) {
                                isSuperProjection = false;
                            }
                            if (this.table.getColumns().size() != this.projection.getColumns().size()) {
                                isSuperProjection = false;
                            }
                            if (isSuperProjection) {
                                for (ProjectionColumnDefinition col : this.projection.getColumns()) {
                                    if (col.getColumn() != null) continue;
                                    isSuperProjection = false;
                                }
                            }
                            this.projection.setSuperProjection(isSuperProjection);
                            this.table.addProjection(this.projection);
                        } else if (line.equals("(")) {
                            this.inCreateProjectionColumnList = true;
                        } else if (line.equals("AS")) {
                            this.inCreateProjectionSelectStatement = true;
                        } else if (this.inCreateProjectionColumnList && line.equals(")")) {
                            this.inCreateProjectionColumnList = false;
                        } else if (this.inCreateProjectionColumnList) {
                            if (line.endsWith(",")) {
                                line = line.substring(0, line.length() - 1);
                            }
                            this.parseProjectionColumn(line);
                        } else if (this.inCreateProjectionSelectStatement) {
                            this.parseProjectionSelectStatement(line);
                        } else {
                            throw new RuntimeException("An unexpected token was found on the following line: " + line);
                        }
                    }
                    if (this.inAlterTable) {
                        if (line.endsWith(";")) {
                            this.inAlterTable = false;
                            line = line.substring(0, line.length() - 1);
                            this.sb.append(line);
                            String alterTableStatement = this.sb.toString();
                            alterTableStatement = alterTableStatement.replace("ALTER TABLE " + this.table.getTablePath() + " ", "");
                            if (alterTableStatement != null && alterTableStatement.startsWith("ADD CONSTRAINT ")) {
                                alterTableStatement = alterTableStatement.replaceAll("^ADD ", "");
                                this.parseConstraint(alterTableStatement);
                            }
                        } else {
                            this.sb.append(line);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void parseConstraint(String line) {
        line = line.replaceAll("^CONSTRAINT ", "");
        String constraintName = line.substring(0, line.indexOf(" "));
        line = line.replaceAll("^" + constraintName + " ", "");
        UniqueKeyDefinition uniqueKeyDefinition = null;
        boolean isPrimaryKey = false;
        if (line.startsWith("PRIMARY KEY ") || line.startsWith("UNIQUE ")) {
            if (line.startsWith("PRIMARY KEY ")) {
                line = line.replaceAll("^PRIMARY KEY ", "");
                uniqueKeyDefinition = new PrimaryKeyDefinition();
                isPrimaryKey = true;
            }
            if (line.startsWith("UNIQUE ")) {
                line = line.replaceAll("^UNIQUE ", "");
                uniqueKeyDefinition = new UniqueKeyDefinition();
            }
            if (!line.startsWith("(")) {
                throw new RuntimeException("An unexpected token was found on the following line: " + line);
            }
            line = line.substring(1);
            String columnList = "";
            if (!line.contains(")")) {
                throw new RuntimeException("An unexpected token was found on the following line: " + line);
            }
            columnList = line.substring(0, line.indexOf(")"));
            line = line.substring(line.indexOf(")") + 1).trim();
            if (uniqueKeyDefinition != null) {
                uniqueKeyDefinition.setConstraintName(constraintName);
                String[] stringArray = columnList.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String columnName = stringArray[n2];
                    columnName = columnName.trim();
                    uniqueKeyDefinition.addColumn(this.table.getColumn(columnName));
                    ++n2;
                }
                if (line.startsWith("ENABLED")) {
                    uniqueKeyDefinition.setEnabled(true);
                }
            }
            if (isPrimaryKey) {
                this.table.setPrimaryKey((PrimaryKeyDefinition)uniqueKeyDefinition);
            } else {
                this.table.addUniqueKey(uniqueKeyDefinition);
            }
        }
    }

    private void parseProjectionSelectStatement(String line) {
        String cleanLine = line;
        if (!(!line.startsWith("SELECT ") || this.inCreateProjectionSelectStatementSelect || this.inCreateProjectionSelectStatementFrom || this.inCreateProjectionSelectStatementWhere || this.inCreateProjectionSelectStatementGroupBy || this.inCreateProjectionSelectStatementOrderBy || this.inCreateProjectionSelectStatementSegemented || this.inCreateProjectionSelectStatementKsafe || this.inCreateProjectionSelectStatementLimit || this.inCreateProjectionSelectStatementOver)) {
            this.inCreateProjectionSelectStatementSelect = true;
            cleanLine = line.replaceAll("^SELECT ", "");
        } else if (line.startsWith("FROM ") && this.inCreateProjectionSelectStatementSelect && !this.inCreateProjectionSelectStatementFrom) {
            this.inCreateProjectionSelectStatementSelect = false;
            this.inCreateProjectionSelectStatementFrom = true;
            cleanLine = line.replaceAll("^FROM ", "");
        } else if (line.startsWith("WHERE ") && this.inCreateProjectionSelectStatementFrom) {
            this.inCreateProjectionSelectStatementFrom = false;
            this.inCreateProjectionSelectStatementWhere = true;
        } else if (line.startsWith("GROUP BY ") && (this.inCreateProjectionSelectStatementFrom || this.inCreateProjectionSelectStatementWhere)) {
            this.inCreateProjectionSelectStatementFrom = false;
            this.inCreateProjectionSelectStatementWhere = false;
            this.inCreateProjectionSelectStatementGroupBy = true;
        } else if (line.startsWith("ORDER BY ") && (this.inCreateProjectionSelectStatementFrom || this.inCreateProjectionSelectStatementWhere || this.inCreateProjectionSelectStatementGroupBy) && !this.inCreateProjectionSelectStatementOver) {
            this.inCreateProjectionSelectStatementFrom = false;
            this.inCreateProjectionSelectStatementWhere = false;
            this.inCreateProjectionSelectStatementGroupBy = false;
            this.inCreateProjectionSelectStatementOrderBy = true;
            cleanLine = line.replaceAll("^ORDER BY ", "");
        } else if (line.startsWith("SEGMENTED BY ")) {
            this.inCreateProjectionSelectStatementSelect = false;
            this.inCreateProjectionSelectStatementFrom = false;
            this.inCreateProjectionSelectStatementWhere = false;
            this.inCreateProjectionSelectStatementGroupBy = false;
            this.inCreateProjectionSelectStatementOrderBy = false;
            this.inCreateProjectionSelectStatementSegemented = true;
            this.inCreateProjectionSelectStatementKsafe = false;
            this.inCreateProjectionSelectStatementLimit = false;
            this.inCreateProjectionSelectStatementOver = false;
            this.projection.setSegmented(true);
        } else if (line.startsWith("UNSEGMENTED ")) {
            this.inCreateProjectionSelectStatementSelect = false;
            this.inCreateProjectionSelectStatementFrom = false;
            this.inCreateProjectionSelectStatementWhere = false;
            this.inCreateProjectionSelectStatementGroupBy = false;
            this.inCreateProjectionSelectStatementOrderBy = false;
            this.inCreateProjectionSelectStatementSegemented = true;
            this.inCreateProjectionSelectStatementKsafe = false;
            this.inCreateProjectionSelectStatementLimit = false;
            this.inCreateProjectionSelectStatementOver = false;
        } else if (line.startsWith("KSAFE ")) {
            this.inCreateProjectionSelectStatementSelect = false;
            this.inCreateProjectionSelectStatementFrom = false;
            this.inCreateProjectionSelectStatementWhere = false;
            this.inCreateProjectionSelectStatementGroupBy = false;
            this.inCreateProjectionSelectStatementOrderBy = false;
            this.inCreateProjectionSelectStatementSegemented = false;
            this.inCreateProjectionSelectStatementKsafe = true;
            this.inCreateProjectionSelectStatementLimit = false;
            this.inCreateProjectionSelectStatementOver = false;
        } else if (line.startsWith("LIMIT ")) {
            this.inCreateProjectionSelectStatementSelect = false;
            this.inCreateProjectionSelectStatementFrom = false;
            this.inCreateProjectionSelectStatementWhere = false;
            this.inCreateProjectionSelectStatementGroupBy = false;
            this.inCreateProjectionSelectStatementOrderBy = false;
            this.inCreateProjectionSelectStatementSegemented = false;
            this.inCreateProjectionSelectStatementKsafe = false;
            this.inCreateProjectionSelectStatementLimit = true;
            this.inCreateProjectionSelectStatementOver = false;
        } else if (line.startsWith("OVER ( ")) {
            this.inCreateProjectionSelectStatementSelect = false;
            this.inCreateProjectionSelectStatementFrom = false;
            this.inCreateProjectionSelectStatementWhere = false;
            this.inCreateProjectionSelectStatementGroupBy = false;
            this.inCreateProjectionSelectStatementOrderBy = false;
            this.inCreateProjectionSelectStatementSegemented = false;
            this.inCreateProjectionSelectStatementKsafe = false;
            this.inCreateProjectionSelectStatementLimit = false;
            this.inCreateProjectionSelectStatementOver = true;
        }
        if (this.inCreateProjectionSelectStatementSelect) {
            this.projection.appendProjectionSelectExpression(line);
            if (cleanLine.endsWith(",")) {
                cleanLine = cleanLine.substring(0, cleanLine.length() - 1);
            }
            cleanLine = cleanLine.trim();
            this.projection.addSelectExpression(cleanLine);
        }
        if (this.inCreateProjectionSelectStatementFrom) {
            this.projection.appendProjectionSelectExpression(line);
            this.projection.addFromExpression(line);
            cleanLine = cleanLine.trim();
            if (cleanLine.endsWith(",")) {
                cleanLine = cleanLine.substring(0, cleanLine.length() - 1);
            }
            if ((cleanLine = cleanLine.trim()).startsWith(this.table.getTablePath() + " ") || cleanLine.startsWith(this.table.getTableName() + " ")) {
                cleanLine = cleanLine.substring(cleanLine.indexOf(" ") + 1);
                this.projection.setMainTableAlias(cleanLine);
            }
        }
        if (this.inCreateProjectionSelectStatementWhere) {
            this.projection.appendProjectionSelectExpression(line);
            this.projection.addWhereExpression(line);
            this.projection.setHasWhereClause(true);
        }
        if (this.inCreateProjectionSelectStatementGroupBy) {
            this.projection.appendProjectionSelectExpression(line);
            this.projection.addGroupByExpression(line);
            this.projection.setAggregate(true);
        }
        if (this.inCreateProjectionSelectStatementOrderBy) {
            this.projection.appendProjectionSelectExpression(line);
            this.projection.addOrderByExpression(line);
            this.projection.appendOrderByExpression(cleanLine);
        }
        if (this.inCreateProjectionSelectStatementSegemented) {
            this.projection.appendSegmentExpression(cleanLine);
        }
        if (this.inCreateProjectionSelectStatementKsafe) {
            this.projection.appendSegmentExpression(cleanLine);
        }
        if (this.inCreateProjectionSelectStatementLimit) {
            this.projection.addLimitExpression(line);
            this.projection.setTopK(true);
        }
        if (this.inCreateProjectionSelectStatementOver) {
            this.projection.addOverExpression(line);
            this.projection.setHasOverClause(true);
        }
    }

    private void parseProjectionColumn(String line) {
        ++this.sortPosition;
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(line.split(" ")));
        Object columnName = (String)tokens.get(0);
        tokens.remove(0);
        while (((String)columnName).startsWith("\"") && !((String)columnName).endsWith("\"")) {
            columnName = (String)columnName + " " + (String)tokens.get(0);
            tokens.remove(0);
        }
        ProjectionColumnDefinition col = new ProjectionColumnDefinition();
        col.setColumnName((String)columnName);
        col.setSortPosition(this.sortPosition);
        if (tokens.size() > 1 && ((String)tokens.get(0)).equals("ENCODING")) {
            col.setEncodingType((String)tokens.get(1));
            tokens.remove(1);
            tokens.remove(0);
        }
        if (tokens.size() > 1 && ((String)tokens.get(0)).equals("ACCESSRANK")) {
            col.setEncodingType((String)tokens.get(1));
            tokens.remove(1);
            tokens.remove(0);
        }
        col.setColumn(this.table.getColumn((String)columnName));
        this.projection.addColumn(col);
    }

    void parseTableColumn(String line) {
        ++this.ordinalPosition;
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(line.split(" ")));
        Object columnName = (String)tokens.get(0);
        tokens.remove(0);
        while (((String)columnName).startsWith("\"") && !((String)columnName).endsWith("\"")) {
            columnName = (String)columnName + " " + (String)tokens.get(0);
            tokens.remove(0);
        }
        TableColumnDefinition col = new TableColumnDefinition();
        col.setColumnName((String)columnName);
        col.setOrdinalPosition(this.ordinalPosition);
        if (!tokens.isEmpty()) {
            Object dataType = (String)tokens.get(0);
            tokens.remove(0);
            if (!tokens.isEmpty()) {
                String nextToken = (String)tokens.get(0);
                if (((String)dataType).toUpperCase().startsWith("ROW") || ((String)dataType).toUpperCase().startsWith("ARRAY")) {
                    dataType = (String)dataType + " " + String.join((CharSequence)" ", tokens);
                    tokens.clear();
                } else if (((String)dataType).equalsIgnoreCase("LONG") && (nextToken.toUpperCase().startsWith("VARCHAR") || nextToken.toUpperCase().startsWith("VARBINARY"))) {
                    dataType = (String)dataType + " " + nextToken;
                    tokens.remove(0);
                } else if (((String)dataType).equalsIgnoreCase("DOUBLE") && nextToken.equalsIgnoreCase("PRECISION")) {
                    dataType = (String)dataType + " " + nextToken;
                    tokens.remove(0);
                } else if ((((String)dataType).equalsIgnoreCase("TIME") || ((String)dataType).equalsIgnoreCase("TIMESTAMP")) && nextToken.equalsIgnoreCase("WITH")) {
                    dataType = (String)dataType + " " + nextToken;
                    tokens.remove(0);
                    if (!tokens.isEmpty() && (nextToken = (String)tokens.get(0)).equalsIgnoreCase("TIMEZONE")) {
                        dataType = (String)dataType + " " + nextToken;
                        tokens.remove(0);
                    }
                } else if (((String)dataType).equalsIgnoreCase("INTERVAL") && (nextToken.equalsIgnoreCase("DAY") || nextToken.equalsIgnoreCase("HOUR") || nextToken.equalsIgnoreCase("MINUTE") || nextToken.equalsIgnoreCase("SECOND") || nextToken.equalsIgnoreCase("MONTH") || nextToken.equalsIgnoreCase("YEAR"))) {
                    dataType = (String)dataType + " " + nextToken;
                    tokens.remove(0);
                    if (!tokens.isEmpty() && (nextToken = (String)tokens.get(0)).equalsIgnoreCase("TO")) {
                        dataType = (String)dataType + " " + nextToken;
                        tokens.remove(0);
                        if (!tokens.isEmpty() && ((nextToken = (String)tokens.get(0)).toUpperCase().startsWith("SECOND") || nextToken.toUpperCase().startsWith("MINUTE") || nextToken.toUpperCase().startsWith("HOUR") || nextToken.toUpperCase().startsWith("MONTH") || nextToken.equalsIgnoreCase("MONTH"))) {
                            dataType = (String)dataType + " " + nextToken;
                            tokens.remove(0);
                        }
                    }
                }
            }
            col.setDatatypeFullString((String)dataType);
            if (((String)dataType).contains("(") && !((String)dataType).startsWith("ARRAY") && !((String)dataType).startsWith("ROW")) {
                String datatypeLength = ((String)dataType).replaceAll(".*\\((\\d+).*\\)", "$1");
                col.setColumnSize(datatypeLength);
            }
        }
        if (tokens.size() == 1) {
            throw new RuntimeException("An unexpected or missing token was found on the following line: " + line);
        }
        if (tokens.size() > 1 && ((String)tokens.get(0)).equals("NOT") && ((String)tokens.get(1)).equals("NULL")) {
            col.setNullable(false);
            tokens.remove(1);
            tokens.remove(0);
        }
        if (!tokens.isEmpty() && ((String)tokens.get(0)).equals("DEFAULT")) {
            StringBuilder builder = new StringBuilder();
            tokens.remove(0);
            for (String token : tokens) {
                builder.append(token);
                builder.append(" ");
            }
            col.setDefaultValue(builder.toString().trim());
        }
        this.table.addColumn(col);
    }

    public TableDefinition getTable() {
        return this.table;
    }

    public void setTable(TableDefinition table) {
        this.table = table;
    }

    public void setExportObjectsStatement(String exportObjectsStatement) {
        this.exportObjectsStatement = exportObjectsStatement;
    }
}

