/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.vertica.export.objects.definitions;

import com.indy.engine.addons.vertica.export.objects.definitions.ProjectionColumnDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.TableColumnDefinition;
import com.indy.engine.addons.vertica.export.objects.definitions.TableDefinition;
import java.util.ArrayList;
import java.util.List;

public class ProjectionDefinition {
    private String schemaName = "";
    private String projectionName = "";
    private String segmentExpression = "";
    private List<ProjectionColumnDefinition> columns = new ArrayList<ProjectionColumnDefinition>();
    private List<String> selectExpressions = new ArrayList<String>();
    private List<String> fromExpressions = new ArrayList<String>();
    private List<String> whereExpressions = new ArrayList<String>();
    private List<String> groupByExpressions = new ArrayList<String>();
    private List<String> limitExpressions = new ArrayList<String>();
    private List<String> overExpressions = new ArrayList<String>();
    private List<String> orderByExpressions = new ArrayList<String>();
    private boolean isAggregate = false;
    private boolean isTopK = false;
    private boolean hasWhereClause;
    private boolean hasOverClause = false;
    private boolean isSuperProjection;
    private boolean isSegmented = false;
    private String orderByExpression = "";
    private String mainTableAlias = "";
    private String projectionSelectExpression = "";

    protected void renameTable(String oldSchemaName, String oldTableName, String newSchemaName, String newTableName, TableDefinition baseTable) {
        for (TableColumnDefinition columnToReplace : baseTable.getColumns()) {
            String oldColumnPattern = "(^|[\\W])(" + oldTableName + "\\." + columnToReplace.getColumnName() + ")($|[\\W])";
            String newColumnPattern = "$1" + newTableName + "\\." + columnToReplace.getColumnName() + "$3";
            if (this.orderByExpression != null && this.orderByExpression.length() > 0) {
                this.orderByExpression = this.orderByExpression.replaceAll(oldColumnPattern, newColumnPattern);
            }
            if (this.projectionSelectExpression != null && this.projectionSelectExpression.length() > 0) {
                this.projectionSelectExpression = this.projectionSelectExpression.replaceAll(oldColumnPattern, newColumnPattern);
            }
            if (this.segmentExpression != null && this.segmentExpression.length() > 0) {
                this.segmentExpression = this.segmentExpression.replaceAll(oldColumnPattern, newColumnPattern);
            }
            if (this.selectExpressions != null) {
                ArrayList<String> newSelectExpressions = new ArrayList<String>();
                for (String selectExpression : this.selectExpressions) {
                    if (selectExpression == null || selectExpression.length() <= 0) continue;
                    selectExpression = selectExpression.replaceAll(oldColumnPattern, newColumnPattern);
                    newSelectExpressions.add(selectExpression);
                }
                this.selectExpressions = newSelectExpressions;
            }
            if (this.whereExpressions != null) {
                ArrayList<String> newWhereExpressions = new ArrayList<String>();
                for (String whereExpression : this.whereExpressions) {
                    if (whereExpression == null || whereExpression.length() <= 0) continue;
                    whereExpression = whereExpression.replaceAll(oldColumnPattern, newColumnPattern);
                    newWhereExpressions.add(whereExpression);
                }
                this.whereExpressions = newWhereExpressions;
            }
            if (this.groupByExpressions != null) {
                ArrayList<String> newGroupByExpressions = new ArrayList<String>();
                for (String groupByExpression : this.groupByExpressions) {
                    if (groupByExpression == null || groupByExpression.length() <= 0) continue;
                    groupByExpression = groupByExpression.replaceAll(oldColumnPattern, newColumnPattern);
                    newGroupByExpressions.add(groupByExpression);
                }
                this.groupByExpressions = newGroupByExpressions;
            }
            if (this.limitExpressions != null) {
                ArrayList<String> newLimitExpressions = new ArrayList<String>();
                for (String limitExpression : this.limitExpressions) {
                    if (limitExpression == null || limitExpression.length() <= 0) continue;
                    limitExpression = limitExpression.replaceAll(oldColumnPattern, newColumnPattern);
                    newLimitExpressions.add(limitExpression);
                }
                this.limitExpressions = newLimitExpressions;
            }
            if (this.overExpressions != null) {
                ArrayList<String> newOverExpressions = new ArrayList<String>();
                for (String overExpression : this.overExpressions) {
                    if (overExpression == null || overExpression.length() <= 0) continue;
                    overExpression = overExpression.replaceAll(oldColumnPattern, newColumnPattern);
                    newOverExpressions.add(overExpression);
                }
                this.overExpressions = newOverExpressions;
            }
            if (this.orderByExpressions == null) continue;
            ArrayList<String> newOrderByExpressions = new ArrayList<String>();
            for (String curOrderByExpression : this.orderByExpressions) {
                if (curOrderByExpression == null || curOrderByExpression.length() <= 0) continue;
                curOrderByExpression = curOrderByExpression.replaceAll(oldColumnPattern, newColumnPattern);
                newOrderByExpressions.add(curOrderByExpression);
            }
            this.orderByExpressions = newOrderByExpressions;
        }
        if (this.mainTableAlias != null && this.mainTableAlias.equals(oldTableName)) {
            this.mainTableAlias = newTableName;
        }
        String oldTablePattern = "(^|[\\W])(" + oldSchemaName + "\\." + oldTableName + ")($|[\\W])";
        Object newTablePattern = "";
        newTablePattern = newSchemaName != null && newSchemaName.length() > 0 ? "$1" + newSchemaName + "\\." + newTableName + "$3" : "$1" + newTableName + "$3";
        if (this.projectionSelectExpression != null && this.projectionSelectExpression.length() > 0) {
            this.projectionSelectExpression = this.projectionSelectExpression.replaceAll(oldTablePattern, (String)newTablePattern);
        }
        if (this.fromExpressions != null) {
            ArrayList<String> newFromExpressions = new ArrayList<String>();
            for (String fromExpression : this.fromExpressions) {
                if (fromExpression == null || fromExpression.length() <= 0) continue;
                fromExpression = fromExpression.replaceAll(oldTablePattern, (String)newTablePattern);
                newFromExpressions.add(fromExpression);
            }
            this.fromExpressions = newFromExpressions;
        }
    }

    public String getProjectionColumnsExpression() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.getColumns().size()) {
            ProjectionColumnDefinition projectionColumnDefinition = this.getColumns().get(i);
            sb.append(projectionColumnDefinition.getColumnName());
            sb.append(" ");
            sb.append(projectionColumnDefinition.getEncodingType());
            sb.append(" ");
            sb.append(projectionColumnDefinition.getAccessRank());
            if (i < this.getColumns().size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public String getCreateProjectionDDL() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE PROJECTION ");
        sb.append(this.getProjectionPath());
        sb.append("\n");
        sb.append("(");
        sb.append("\n");
        sb.append(this.getProjectionColumnsExpression());
        sb.append(")");
        sb.append("\n");
        sb.append("AS");
        sb.append("\n");
        sb.append(this.getProjectionSelectExpression());
        sb.append("\n");
        sb.append(this.getSegmentExpression());
        return sb.toString();
    }

    public String getCreateProjectionDDL2() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE PROJECTION ");
        sb.append(this.getProjectionPath());
        sb.append("\n");
        sb.append("(");
        sb.append("\n");
        sb.append(this.getProjectionColumnsExpression());
        sb.append(")");
        sb.append("\n");
        sb.append("AS");
        sb.append("\n");
        sb.append("SELECT");
        sb.append("\n");
        sb.append(this.getProjectionSelectExpressionsOnly());
        sb.append(this.getProjectionFromClause());
        sb.append(this.getProjectionWhereClause());
        sb.append(this.getProjectionGroupByClause());
        sb.append(this.getProjectionLimitClause());
        sb.append(this.getProjectionOverClause());
        sb.append(this.getProjectionOrderByClause());
        sb.append("\n");
        sb.append(this.getSegmentExpression());
        return sb.toString();
    }

    public String getProjectionOrderByClause() {
        StringBuilder sb = new StringBuilder();
        if (this.orderByExpressions != null) {
            int i = 0;
            while (i < this.orderByExpressions.size()) {
                sb.append(this.orderByExpressions.get(i));
                sb.append("\n");
                ++i;
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getProjectionOverClause() {
        StringBuilder sb = new StringBuilder();
        if (this.overExpressions != null) {
            int i = 0;
            while (i < this.overExpressions.size()) {
                sb.append(this.overExpressions.get(i));
                sb.append("\n");
                ++i;
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getProjectionLimitClause() {
        StringBuilder sb = new StringBuilder();
        if (this.limitExpressions != null) {
            int i = 0;
            while (i < this.limitExpressions.size()) {
                sb.append(this.limitExpressions.get(i));
                sb.append("\n");
                ++i;
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getProjectionGroupByClause() {
        StringBuilder sb = new StringBuilder();
        if (this.groupByExpressions != null) {
            int i = 0;
            while (i < this.groupByExpressions.size()) {
                sb.append(this.groupByExpressions.get(i));
                sb.append("\n");
                ++i;
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getProjectionWhereClause() {
        StringBuilder sb = new StringBuilder();
        if (this.whereExpressions != null) {
            int i = 0;
            while (i < this.whereExpressions.size()) {
                sb.append(this.whereExpressions.get(i));
                sb.append("\n");
                ++i;
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getProjectionFromClause() {
        StringBuilder sb = new StringBuilder();
        if (this.fromExpressions != null) {
            int i = 0;
            while (i < this.fromExpressions.size()) {
                sb.append(this.fromExpressions.get(i));
                sb.append("\n");
                ++i;
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getProjectionSelectExpressionsOnly() {
        StringBuilder sb = new StringBuilder();
        if (this.selectExpressions != null) {
            int i = 0;
            while (i < this.selectExpressions.size()) {
                sb.append(this.selectExpressions.get(i));
                if (i < this.selectExpressions.size() - 1) {
                    sb.append(",");
                    sb.append("\n");
                }
                ++i;
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public ProjectionDefinition renameProjection(String newSchemaName, String newProjectionName) {
        this.setSchemaName(newSchemaName);
        this.setProjectionName(newProjectionName);
        return this;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getProjectionName() {
        return this.projectionName;
    }

    public String getProjectionPath() {
        return this.getSchemaName() + "." + this.getProjectionName();
    }

    public void setProjectionName(String projectName) {
        this.projectionName = projectName;
    }

    public String getSegmentExpression() {
        return this.segmentExpression;
    }

    public void appendSegmentExpression(String segmentExpression) {
        this.segmentExpression = this.segmentExpression + "\n" + segmentExpression;
    }

    public String getOrderByExpression() {
        return this.orderByExpression;
    }

    public void appendOrderByExpression(String orderByExpression) {
        this.orderByExpression = this.orderByExpression + "\n" + orderByExpression;
    }

    public String getProjectionSelectExpression() {
        return this.projectionSelectExpression;
    }

    public void appendProjectionSelectExpression(String projectionSelectExpression) {
        this.projectionSelectExpression = this.projectionSelectExpression + "\n" + projectionSelectExpression;
    }

    public void addColumn(ProjectionColumnDefinition column) {
        this.columns.add(column);
    }

    public void addSelectExpression(String selectExpression) {
        this.selectExpressions.add(selectExpression);
    }

    public void addOrderByExpression(String orderByExpression) {
        this.orderByExpressions.add(orderByExpression);
    }

    public void addOverExpression(String overExpression) {
        this.overExpressions.add(overExpression);
    }

    public void addLimitExpression(String limitExpression) {
        this.limitExpressions.add(limitExpression);
    }

    public void addGroupByExpression(String groupByExpression) {
        this.groupByExpressions.add(groupByExpression);
    }

    public void addWhereExpression(String whereExpression) {
        this.whereExpressions.add(whereExpression);
    }

    public void addFromExpression(String fromExpression) {
        this.fromExpressions.add(fromExpression);
    }

    public List<ProjectionColumnDefinition> getColumns() {
        return new ArrayList<ProjectionColumnDefinition>(this.columns);
    }

    public List<String> getSelectExpressions() {
        return new ArrayList<String>(this.selectExpressions);
    }

    public List<String> getOrderByExpressions() {
        return new ArrayList<String>(this.orderByExpressions);
    }

    public List<String> getOverExpressions() {
        return new ArrayList<String>(this.overExpressions);
    }

    public List<String> getLimitExpressions() {
        return new ArrayList<String>(this.limitExpressions);
    }

    public List<String> getGroupByExpressions() {
        return new ArrayList<String>(this.groupByExpressions);
    }

    public List<String> getWhereExpressions() {
        return new ArrayList<String>(this.whereExpressions);
    }

    public List<String> getFromExpressions() {
        return new ArrayList<String>(this.fromExpressions);
    }

    public ProjectionColumnDefinition getColumn(String columnName) {
        for (ProjectionColumnDefinition col : this.columns) {
            if (!columnName.equals(col.getColumnName())) continue;
            return col;
        }
        return null;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public void setAggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
    }

    public boolean isSegmented() {
        return this.isSegmented;
    }

    public void setSegmented(boolean isSegmented) {
        this.isSegmented = isSegmented;
    }

    public boolean isTopK() {
        return this.isTopK;
    }

    public void setTopK(boolean isTopK) {
        this.isTopK = isTopK;
    }

    public boolean hasWhereClause() {
        return this.hasWhereClause;
    }

    public void setHasWhereClause(boolean hasWhereClause) {
        this.hasWhereClause = hasWhereClause;
    }

    public boolean isSuperProjection() {
        return this.isSuperProjection;
    }

    public void setSuperProjection(boolean isSuperProjection) {
        this.isSuperProjection = isSuperProjection;
    }

    public boolean hasOverClause() {
        return this.hasOverClause;
    }

    public void setHasOverClause(boolean hasOverClause) {
        this.hasOverClause = hasOverClause;
    }

    public String getMainTableAlias() {
        return this.mainTableAlias;
    }

    public void setMainTableAlias(String mainTableAlias) {
        this.mainTableAlias = mainTableAlias;
    }
}

