/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.wizard;

import com.indy.addons.httprest.wizard.AbstractNodeHandler;
import com.indy.addons.httprest.wizard.InvocationUI;
import com.indy.addons.httprest.wizard.Messages;
import com.indy.addons.httprest.wizard.RestWizardBean;
import com.indy.addons.httprest.wizard.RestWizardControler;
import com.indy.addons.json.actions.ReverseJsonAction;
import com.indy.addons.xml.XmlStreamReverser;
import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventWriter;
import com.semarchy.xdi.designer.core.models.MetaDataLinkCapability;
import com.stambia.md.Attribute;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NodeHandlerRest
extends AbstractNodeHandler {
    RestWizardControler controler;
    private static final String HTTP_REST_PATH = "com.stambia.http.rest.path";
    private static final String HTTP_REST_PARAMETERS = "com.stambia.http.rest.parameters";
    private static final String HTTP_REST_PARAMETER = "com.stambia.http.rest.parameter";
    private static final String HTTP_REST_RESPONSES = "com.stambia.http.rest.responses";
    private static final String HTTP_REST_RESPONSE = "com.stambia.http.rest.response";
    private static final String HTTP_REST_OPERATION = "com.stambia.http.rest.operation";
    private static final String HTTP_REST_REQUEST_BODY = "com.stambia.http.rest.requestbody";
    private static final String HTTP_REST = "com.stambia.http.rest";
    private final org.apache.logging.log4j.Logger logger = LogManager.getLogger(this.getClass());

    public NodeHandlerRest(RestWizardControler controler) {
        this.controler = controler;
    }

    @Override
    public void fillBean(MdNode reversedMdNode) {
        Attribute trustStoreAttribute;
        Attribute keyStoreAttribute;
        Attribute proxyAttribute;
        String enableHostnameVerification;
        String enableCertificateVerification;
        MetaDataLinkCapability mdlc;
        RestWizardBean bean = this.controler.getBean();
        RestWizardControler.InputHint hint = this.controler.getHint();
        MdNode rootMdNode = reversedMdNode;
        boolean reversedNodeIsSubMd = false;
        ArrayList<String> resourcePaths = new ArrayList<String>();
        ArrayList<String> endpointResourcePaths = new ArrayList<String>();
        resourcePaths.addAll(this.getPaths(reversedMdNode));
        rootMdNode = this.getRoot(rootMdNode);
        while (rootMdNode instanceof MetaDataLinkCapability && (mdlc = (MetaDataLinkCapability)rootMdNode).getMetaDataLinkBaseRef() != rootMdNode) {
            reversedNodeIsSubMd = true;
            endpointResourcePaths.addAll(this.getPaths((MdNode)mdlc.getMetaDataLinkBaseRef()));
            rootMdNode = this.getRoot((MdNode)mdlc.getMetaDataLinkBaseRef());
        }
        this.controler.setRootMdNode(rootMdNode);
        if (reversedNodeIsSubMd) {
            bean.disableEndpointEditing();
            bean.disableAuthenticationEditing();
        }
        this.refreshExistingAuthenticationMdNode(rootMdNode);
        Collections.reverse(resourcePaths);
        String resourcePath = this.buildResourcePath(resourcePaths);
        bean.setHttpResourcePath(resourcePath);
        Collections.reverse(endpointResourcePaths);
        String endpointUrl = this.buildEndpointUrl(rootMdNode, endpointResourcePaths);
        bean.setHttpEndpoint(endpointUrl);
        String method = NodeHandlerRest.readAttribute("method", reversedMdNode);
        if (method == null || method.isEmpty()) {
            method = "GET";
        }
        if ((enableCertificateVerification = rootMdNode.getAttributeValueByShortCode("enableCertificateVerification")) != null && !enableCertificateVerification.isEmpty()) {
            bean.setEnableCertificateVerification(Boolean.valueOf(enableCertificateVerification));
        }
        if ((enableHostnameVerification = rootMdNode.getAttributeValueByShortCode("enableHostnameVerification")) != null && !enableHostnameVerification.isEmpty()) {
            bean.setEnableHostnameVerification(Boolean.valueOf(enableHostnameVerification));
        }
        HashSet<String> pathParams = new HashSet<String>();
        Pattern pattern = Pattern.compile("\\{([^/]*)\\}");
        Matcher matcher = pattern.matcher(bean.getHttpResourcePath());
        while (matcher.find()) {
            pathParams.add(matcher.group(1));
        }
        for (MdNode parameters : reversedMdNode.getNodeByCode(HTTP_REST_PARAMETERS)) {
            for (MdNode param : parameters.getNodeByCode(HTTP_REST_PARAMETER)) {
                String location = NodeHandlerRest.readAttribute("location", param);
                Object value = hint.parameterValues.get(param.getName());
                if (value == null || ((String)value).isEmpty()) {
                    value = NodeHandlerRest.readAttribute("default", param);
                }
                RestWizardControler.BindingType bindingType = null;
                if (location != null) {
                    if (location.equals("path")) {
                        bindingType = RestWizardControler.BindingType.HTTP_URL_REPLACEMENT;
                        pathParams.remove(param.getName());
                    } else if (location.equals("query")) {
                        bindingType = RestWizardControler.BindingType.HTTP_URL_ENCODED;
                    } else if (location.equals("header")) {
                        bindingType = RestWizardControler.BindingType.HTTP_HEADER;
                    } else if (location.equals("cookie")) {
                        bindingType = RestWizardControler.BindingType.HTTP_COOKIE;
                    }
                }
                Boolean allowEmptyValue = false;
                try {
                    allowEmptyValue = Boolean.valueOf(NodeHandlerRest.readAttribute("allowEmptyValue", param));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bean.addParameter(param.getName(), (String)value, bindingType, true, allowEmptyValue);
            }
        }
        for (String pathParam : pathParams) {
            bean.addParameter(pathParam, null, RestWizardControler.BindingType.HTTP_URL_REPLACEMENT, true, true);
        }
        String mediaType = null;
        String contentType = null;
        for (MdNode reqBody : reversedMdNode.getNodeByCode(HTTP_REST_REQUEST_BODY)) {
            for (MdNode content : reqBody.getNodeByCode("com.stambia.http.rest.content")) {
                try {
                    contentType = MdAttributeReader.readAttribute((String)"contentType", (MdNode)content);
                    mediaType = MdAttributeReader.readAttribute((String)"mediaType", (MdNode)content);
                    if (mediaType != null && mediaType.equals("FORM")) {
                        StringBuilder b = new StringBuilder();
                        for (MdNode formValue : content.getNodeByCode("com.stambia.http.rest.formvalue")) {
                            if (b.length() > 0) {
                                b.append("&");
                            }
                            b.append(formValue.getName());
                            b.append("=");
                            b.append("<value>");
                            bean.addParameter(formValue.getName(), "", RestWizardControler.BindingType.MIME_CONTENT, true, true);
                        }
                    }
                }
                catch (MdAttributeReader.UnknownTechPropertyException e) {
                    this.logger.warn("Unknown tech property", (Throwable)e);
                }
                String dummyData = "";
                if (InvocationUI.MimeType.JSON.getMediaType().equals(mediaType)) {
                    JsonEventWriter jew = null;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    try {
                        try {
                            ByteArrayOutputStream jsonStream = new ByteArrayOutputStream();
                            jew = new JsonEventWriter((OutputStream)jsonStream, "UTF-8");
                            jew.add(JSonEvent.createStartDocument(), true);
                            this.generateDummyJsonInput(content, jew);
                            jew.add(JSonEvent.createEndDocument(), true);
                            jew.flush();
                            dummyData = new String(jsonStream.toByteArray());
                            bean.setInputData(dummyData);
                        }
                        catch (Exception e) {
                            this.logger.warn("Error while generating dummy JSON", (Throwable)e);
                            if (jew != null) {
                                jew.close();
                            }
                            if (outputStream == null) continue;
                            try {
                                outputStream.close();
                            }
                            catch (IOException e2) {
                                this.logger.warn("Error closing stream", (Throwable)e2);
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (jew != null) {
                            jew.close();
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e) {
                                this.logger.warn("Error closing stream", (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (jew != null) {
                        jew.close();
                    }
                    if (outputStream == null) continue;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        this.logger.warn("Error closing stream", (Throwable)e);
                    }
                    continue;
                }
                if (!InvocationUI.MimeType.XML.getMediaType().equals(mediaType)) continue;
                StringWriter stringOut = new StringWriter();
                XMLOutputFactory factory = XMLOutputFactory.newInstance();
                XMLStreamWriter writer = null;
                try {
                    try {
                        writer = factory.createXMLStreamWriter(stringOut);
                        writer.writeStartDocument();
                        this.generateDummyXmlInput(content, writer);
                        writer.writeEndDocument();
                        StreamResult streamResult = this.prettyPrintXml(stringOut);
                        bean.setInputData(streamResult.getWriter().toString().trim());
                    }
                    catch (Exception e) {
                        this.logger.warn("Error generating dummy XML", (Throwable)e);
                        try {
                            if (stringOut != null) {
                                stringOut.close();
                            }
                            if (writer == null) continue;
                            writer.close();
                        }
                        catch (Exception e3) {
                            this.logger.warn("Error closing stream", (Throwable)e3);
                        }
                        continue;
                    }
                }
                catch (Throwable e) {
                    try {
                        if (stringOut != null) {
                            stringOut.close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception e4) {
                        this.logger.warn("Error closing stream", (Throwable)e4);
                    }
                    throw e;
                }
                try {
                    if (stringOut != null) {
                        stringOut.close();
                    }
                    if (writer == null) continue;
                    writer.close();
                }
                catch (Exception e) {
                    this.logger.warn("Error closing stream", (Throwable)e);
                }
            }
        }
        Attribute securityAttribute = rootMdNode.getAttributeByShortCode("security");
        if (securityAttribute != null) {
            MdNode securityNode = (MdNode)securityAttribute.getRef();
            this.controler.setAuthenticationMdNode(securityNode);
        }
        if ((proxyAttribute = rootMdNode.getAttributeByShortCode("proxy")) != null) {
            MdNode securityNode = (MdNode)proxyAttribute.getRef();
            this.controler.setAuthenticationProxyMdNode(securityNode);
        }
        if ((keyStoreAttribute = rootMdNode.getAttributeByShortCode("keystore")) != null) {
            MdNode keyStoreNode = (MdNode)keyStoreAttribute.getRef();
            this.controler.setKeyStoreNode(keyStoreNode);
        }
        if ((trustStoreAttribute = rootMdNode.getAttributeByShortCode("truststore")) != null) {
            MdNode trustStoreNode = (MdNode)trustStoreAttribute.getRef();
            this.controler.setTrustStoreNode(trustStoreNode);
        }
        HashMap<String, String> outputMimeTypesByHttpResultCode = new HashMap<String, String>();
        for (MdNode n : reversedMdNode.getNodeByCode(HTTP_REST_RESPONSES)) {
            for (MdNode r : n.getNodeByCode(HTTP_REST_RESPONSE)) {
                String httpResCode = NodeHandlerRest.readAttribute("code", r);
                if (httpResCode == null || httpResCode.isEmpty()) continue;
                for (MdNode c : r.getNodeByCode("com.stambia.http.rest.content")) {
                    String mt = NodeHandlerRest.readAttribute("mediaType", c);
                    if (mt == null || mt.isEmpty()) continue;
                    outputMimeTypesByHttpResultCode.put(httpResCode, mt);
                }
            }
        }
        bean.setHttpResourcePaths(resourcePaths);
        bean.setHttpMethod(method);
        bean.setHttpInputContentType(contentType);
        bean.setHttpInputMediaType(mediaType);
        bean.setHttpOutputMediaTypePerResultCode(outputMimeTypesByHttpResultCode);
    }

    private String buildEndpointUrl(MdNode rootMdNode, List<String> endpointResourcePaths) {
        StringBuilder endpointUrlBuilder = new StringBuilder();
        String endpoint = NodeHandlerRest.readAttribute("url", rootMdNode);
        if (endpoint != null) {
            endpointUrlBuilder.append(endpoint);
        }
        endpointUrlBuilder.append(this.buildResourcePath(endpointResourcePaths));
        if (!endpointUrlBuilder.isEmpty() && !endpointUrlBuilder.toString().endsWith("/")) {
            endpointUrlBuilder.append("/");
        }
        return endpointUrlBuilder.toString();
    }

    private String buildResourcePath(List<String> resourcePaths) {
        StringBuilder resourcePathsBuilder = new StringBuilder();
        int i = 0;
        while (i < resourcePaths.size()) {
            String s = resourcePaths.get(i);
            if (s.startsWith("/") || i == 0) {
                resourcePathsBuilder.append(s);
            } else {
                resourcePathsBuilder.append("/");
                resourcePathsBuilder.append(s);
            }
            ++i;
        }
        return resourcePathsBuilder.toString();
    }

    private MdNode getRoot(MdNode node) {
        while (node.eContainer() instanceof MdNode) {
            node = (MdNode)node.eContainer();
        }
        return node;
    }

    private List<String> getPaths(MdNode node) {
        ArrayList<String> paths = new ArrayList<String>();
        while (node.eContainer() instanceof MdNode) {
            String resourcePath;
            if (node.getDefType().equals(HTTP_REST_PATH) && (resourcePath = NodeHandlerRest.readAttribute("path", node)) != null) {
                paths.add(resourcePath);
            }
            node = (MdNode)node.eContainer();
        }
        return paths;
    }

    private StreamResult prettyPrintXml(StringWriter stringOut) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource inputStream = new InputSource(new StringReader(stringOut.toString()));
        Document document = documentBuilder.parse(inputStream);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult streamResult = new StreamResult(new StringWriter());
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, streamResult);
        return streamResult;
    }

    private void generateDummyXmlInput(MdNode currentNode, XMLStreamWriter adapter) throws XMLStreamException {
        List mdNodeList = currentNode.getNodeByCode("com.stambia.xml.root");
        for (MdNode childNode : mdNodeList) {
            if (childNode.getName() == null) continue;
            adapter.writeStartElement(childNode.getName());
            this.generateDummyXmlInput(childNode, adapter);
            adapter.writeEndElement();
        }
        mdNodeList = currentNode.getNodeByCode("com.stambia.xml.sequence");
        for (MdNode childNode : mdNodeList) {
            if (childNode.getName() != null) {
                adapter.writeStartElement(childNode.getName());
            }
            this.generateDummyXmlInput(childNode, adapter);
            List lAttributes = childNode.getAttribute("com.stambia.xml.sequence.maxOccurs");
            if (lAttributes != null) {
                for (Attribute attribute : lAttributes) {
                    if (!"com.stambia.xml.sequence.maxOccurs".equals(attribute.getDefType()) || !"unbounded".equals(attribute.getValue())) continue;
                    this.generateDummyXmlInput(childNode, adapter);
                    break;
                }
            }
            if (childNode.getName() == null) continue;
            adapter.writeEndElement();
        }
        String type = null;
        List childNodeList = currentNode.getNodeByCode("com.stambia.xml.element");
        int i = 0;
        while (i < childNodeList.size()) {
            MdNode childNode = (MdNode)childNodeList.get(i);
            List attributeTypeList = childNode.getAttribute("com.stambia.xml.element.type");
            if (attributeTypeList != null && !attributeTypeList.isEmpty()) {
                for (Attribute attribute : attributeTypeList) {
                    if (!"com.stambia.xml.element.type".equals(attribute.getDefType())) continue;
                    type = attribute.getValue();
                    break;
                }
                adapter.writeStartElement(childNode.getName());
                mdNodeList = childNode.getNodeByCode("com.stambia.xml.attribute");
                String defType = null;
                for (MdNode attribute : mdNodeList) {
                    Attribute att = attribute.getAttributeByCode("com.stambia.xml.attribute.type");
                    if (att == null) continue;
                    defType = att.getValue();
                    if (defType.equals("string") || defType.equals("qname") || defType.equals("ncname") || defType.equals("name")) {
                        adapter.writeAttribute(attribute.getName(), "string");
                        continue;
                    }
                    if (this.isNumericType(defType)) {
                        adapter.writeAttribute(attribute.getName(), "0");
                        continue;
                    }
                    if (!defType.equals("boolean")) continue;
                    adapter.writeAttribute(attribute.getName(), "false");
                }
                if (type != null) {
                    String lowerCaseType = type.toLowerCase();
                    if (lowerCaseType.equals("string") || lowerCaseType.equals("qname") || lowerCaseType.equals("ncname") || lowerCaseType.equals("name")) {
                        adapter.writeCharacters("string");
                    } else if (this.isNumericType(lowerCaseType)) {
                        adapter.writeCharacters("0");
                    } else if (lowerCaseType.equals("boolean")) {
                        adapter.writeCharacters("false");
                    }
                }
                this.generateDummyXmlInput(childNode, adapter);
                adapter.writeEndElement();
            }
            ++i;
        }
    }

    private boolean isNumericType(String lowerCaseType) {
        return lowerCaseType.equals("int") || lowerCaseType.equals("integer") || lowerCaseType.equals("short") || lowerCaseType.equals("float") || lowerCaseType.equals("double") || lowerCaseType.equals("long") || lowerCaseType.equals("decimal") || lowerCaseType.equals("byte") || lowerCaseType.equals("negativeinteger") || lowerCaseType.equals("nonNegativeinteger") || lowerCaseType.equals("nonPositiveinteger") || lowerCaseType.equals("positiveinteger") || lowerCaseType.equals("unsignedlong") || lowerCaseType.equals("unsignedint") || lowerCaseType.equals("unsignedshort") || lowerCaseType.equals("unsignedbyte");
    }

    private void generateDummyJsonInput(MdNode reqBody, JsonEventWriter jew) {
        for (MdNode childNode : reqBody.getNodeByCode("com.stambia.json.rootObject")) {
            jew.add(JSonEvent.createStartObject(), true);
            this.generateDummyJsonInput(childNode, jew);
            jew.add(JSonEvent.createEndObject(), true);
        }
        for (MdNode childNode : reqBody.getNodeByCode("com.stambia.json.object")) {
            jew.add(JSonEvent.createMember((String)childNode.getName()), true);
            jew.add(JSonEvent.createStartObject(), true);
            this.generateDummyJsonInput(childNode, jew);
            jew.add(JSonEvent.createEndObject(), true);
        }
        for (MdNode childNode : reqBody.getNodeByCode("com.stambia.json.array")) {
            jew.add(JSonEvent.createMember((String)childNode.getName()), true);
            jew.add(JSonEvent.createStartArray(), true);
            this.generateDummyJsonInput(childNode, jew);
            this.generateDummyJsonInput(childNode, jew);
            jew.add(JSonEvent.createEndArray(), true);
        }
        List childNodeList = reqBody.getNodeByCode("com.stambia.json.value");
        int i = 0;
        while (i < childNodeList.size()) {
            MdNode childNode = (MdNode)childNodeList.get(i);
            List attributeTypeList = childNode.getAttribute("com.stambia.json.value.type");
            if (attributeTypeList != null) {
                String type = ((Attribute)attributeTypeList.get(0)).getValue();
                jew.add(JSonEvent.createMember((String)childNode.getName()), true);
                if ("string".equals(type)) {
                    jew.add(JSonEvent.createString((String)"string"), true);
                } else if ("number".equals(type)) {
                    jew.add(JSonEvent.createValue((String)"0", (int)8), true);
                } else if ("boolean".equals(type)) {
                    jew.add(JSonEvent.createValue((String)"false", (int)16), true);
                }
            }
            ++i;
        }
    }

    @Override
    public List<MdNode> getNewNode(MdNode originalMdNode, RestWizardControler.InvocationInput invocationInput) {
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        MdNode originalServerNode = originalMdNode;
        while (originalServerNode.eContainer() instanceof MdNode) {
            originalServerNode = (MdNode)originalServerNode.eContainer();
        }
        MdNode serverNode = this.createMdNode(originalMdNode, invocationInput);
        nodes.add(serverNode);
        RestWizardControler.InvokeResult lastResult = this.controler.getLastResult();
        MdNode resourceNode = this.findFirstNode(serverNode, HTTP_REST_PATH);
        while (resourceNode != null && !resourceNode.getNodeByCode(HTTP_REST_PATH).isEmpty()) {
            resourceNode = this.findFirstNode(resourceNode, HTTP_REST_PATH);
        }
        MdNode methodNode = this.findFirstNode(resourceNode, HTTP_REST_OPERATION);
        MdNode originalResponsesNode = this.findFirstNode(originalMdNode, HTTP_REST_RESPONSES);
        MdNode responsesNode = null;
        if (methodNode != null) {
            responsesNode = this.createOrCopyNode(originalResponsesNode, methodNode, HTTP_REST_RESPONSES);
        }
        if (lastResult != null && responsesNode != null) {
            this.addOtherResponseNodes(originalResponsesNode, responsesNode, String.valueOf(lastResult.getHttpResponseCode()));
            MdNode originalResponse = this.getOriginalResponse(originalResponsesNode, String.valueOf(lastResult.getHttpResponseCode()));
            MdNode responseNode = originalResponse != null ? originalResponse.copy(1) : MdFactory.eINSTANCE.createMdNode();
            responsesNode.getNode().add((Object)responseNode);
            responseNode.setDefType(HTTP_REST_RESPONSE);
            MdNode originalContentNode = null;
            MdNode originalHeadersNode = null;
            MdNode originalRespInfosNode = null;
            if (originalResponse != null) {
                originalHeadersNode = this.findFirstNode(originalResponse, "com.stambia.http.rest.headers");
                originalContentNode = this.findFirstNode(originalResponse, "com.stambia.http.rest.content");
                originalRespInfosNode = this.findFirstNode(originalResponse, "com.stambia.http.rest.respinfos");
            } else {
                responseNode.setAttribute("code", String.valueOf(lastResult.getHttpResponseCode()), false);
            }
            this.addHeadersAndCookiesNode(responseNode, originalHeadersNode, lastResult.getHeaders().keySet(), lastResult.getCookies().keySet());
            if (originalRespInfosNode != null) {
                this.deepCopyNode(originalRespInfosNode, responseNode);
            }
            List<MdNode> xmlNamespaceNodes = this.addContentNode(originalContentNode, originalServerNode, responseNode, lastResult.getDatas(), lastResult.getContentType(), this.controler.getBean().getHttpOutputMediaType());
            for (MdNode namespace : xmlNamespaceNodes) {
                namespace.setSubstituteContainer((EObject)originalServerNode);
                nodes.add(namespace);
            }
        }
        return nodes;
    }

    private MdNode createMdNode(MdNode originalMdNode, RestWizardControler.InvocationInput input) {
        MetaDataLinkCapability mdlc;
        MdNode result = null;
        ArrayList<MdNode> originalResourceNodes = new ArrayList<MdNode>();
        MdNode originalMethodNode = null;
        MdNode originalRootNode = null;
        MdNode rootNode = null;
        MdNode current = originalMdNode;
        while (current.eContainer() instanceof MdNode) {
            if (current.getDefType().equals(HTTP_REST_PATH)) {
                originalResourceNodes.add(current);
            } else if (current.getDefType().equals(HTTP_REST_OPERATION)) {
                originalMethodNode = current;
            }
            current = (MdNode)current.eContainer();
        }
        Collections.reverse(originalResourceNodes);
        originalRootNode = current;
        rootNode = originalRootNode.copy(1);
        rootNode.setSubstituteContainer(originalRootNode.eContainer());
        if (!(originalRootNode instanceof MetaDataLinkCapability) || (mdlc = (MetaDataLinkCapability)originalRootNode).getMetaDataLinkBaseRef() == originalRootNode) {
            rootNode.setDefType(HTTP_REST);
            rootNode.setRefAttribute("security", (EObject)this.controler.getAuthenticationMdNode(), rootNode.eResource() != null);
            rootNode.setAttribute("url", input.getEndpoint(), false);
            rootNode.setRefAttribute("proxy", (EObject)this.controler.getAuthenticationProxyMdNode(), rootNode.eResource() != null);
            rootNode.setRefAttribute("keystore", (EObject)this.controler.getKeyStoreMdNode(), rootNode.eResource() != null);
            rootNode.setRefAttribute("truststore", (EObject)this.controler.getTrustStoreMdNode(), rootNode.eResource() != null);
        }
        result = rootNode;
        MdNode resourceNode = this.addResourceNodes(rootNode, originalResourceNodes, input);
        MdNode methodNode = this.createOrCopyNode(originalMethodNode, resourceNode, HTTP_REST_OPERATION);
        methodNode.setAttribute("method", input.getMethod(), false);
        if (originalResourceNodes.isEmpty() && originalRootNode.getDefType().equals(HTTP_REST_PATH)) {
            this.addOtherMethodNodes(originalRootNode, resourceNode, input.getMethod());
        } else {
            this.addOtherMethodNodes((MdNode)originalResourceNodes.get(originalResourceNodes.size() - 1), resourceNode, input.getMethod());
        }
        MdNode originalParamsNode = this.findFirstNode(originalMethodNode, HTTP_REST_PARAMETERS);
        this.addParameterNodes(methodNode, originalParamsNode, input.getParameters());
        String inputData = input.getInput();
        String inputContentType = input.getInputContentType();
        String inputMediaType = input.getMediaType();
        if (inputData != null && !inputData.trim().isEmpty() && inputContentType != null) {
            MdNode originalReqBodyNode = this.findFirstNode(originalMethodNode, HTTP_REST_REQUEST_BODY);
            MdNode reqBodyNode = this.createOrCopyNode(originalReqBodyNode, methodNode, HTTP_REST_REQUEST_BODY);
            MdNode originalContentNode = this.findFirstNode(originalReqBodyNode, "com.stambia.http.rest.content");
            this.addContentNode(originalContentNode, originalRootNode, reqBodyNode, inputData, inputContentType, inputMediaType);
        }
        return result;
    }

    private MdNode addResourceNodes(MdNode rootNode, List<MdNode> originalResourceNodes, RestWizardControler.InvocationInput input) {
        List<String> originalResourcePaths = input.getResources();
        String finalResourcePath = input.getResource();
        ArrayList<String> newResourcePaths = new ArrayList<String>();
        if (originalResourcePaths.isEmpty()) {
            newResourcePaths.add(finalResourcePath);
        } else {
            int i = 0;
            while (i < originalResourcePaths.size()) {
                if (i == originalResourcePaths.size() - 1) {
                    newResourcePaths.add(finalResourcePath);
                } else {
                    String s = originalResourcePaths.get(i);
                    long countSlashes = s.chars().filter(ch -> ch == 47).count();
                    int finalSlashIndex = -1;
                    int j = 0;
                    while ((long)j <= countSlashes) {
                        finalSlashIndex = finalResourcePath.indexOf(47, finalSlashIndex + 1);
                        ++j;
                    }
                    if (finalSlashIndex != -1) {
                        newResourcePaths.add(finalResourcePath.substring(0, finalSlashIndex));
                        finalResourcePath = finalResourcePath.substring(finalSlashIndex + 1, finalResourcePath.length());
                    } else {
                        newResourcePaths.add(finalResourcePath);
                        break;
                    }
                }
                ++i;
            }
        }
        MdNode currentNode = rootNode;
        currentNode = this.createOrCopyResourceNodes(originalResourceNodes, currentNode, finalResourcePath, newResourcePaths);
        return currentNode;
    }

    private MdNode createOrCopyResourceNodes(List<MdNode> originalResourceNodes, MdNode currentNode, String finalResourcePath, List<String> newResourcePaths) {
        if (originalResourceNodes.isEmpty() && currentNode.getDefType().equals(HTTP_REST_PATH) && finalResourcePath != null && !finalResourcePath.equals("")) {
            currentNode = this.createOrCopyNode(null, currentNode, HTTP_REST_PATH);
            currentNode.setAttribute("path", finalResourcePath, false);
        } else if (finalResourcePath != null && !finalResourcePath.equals("") && currentNode.getDefType().equals(HTTP_REST_PATH) || currentNode.getDefType().equals(HTTP_REST)) {
            int i = 0;
            while (i < originalResourceNodes.size()) {
                MdNode originalResourceNode = originalResourceNodes.get(i);
                currentNode = this.createOrCopyNode(originalResourceNode, currentNode, HTTP_REST_PATH);
                currentNode.setAttribute("path", newResourcePaths.get(i), false);
                ++i;
            }
        }
        return currentNode;
    }

    private void addHeadersAndCookiesNode(MdNode responseNode, MdNode originalHeadersNode, Set<String> headers, Set<String> cookies) {
        MdNode headersNode = this.createOrCopyNode(originalHeadersNode, responseNode, "com.stambia.http.rest.headers");
        for (String header : headers) {
            if (header == null) continue;
            MdNode headerNode = MdFactoryHelper.createMdNode((String)"com.stambia.http.rest.header", (MdNode)headersNode);
            headerNode.setName(header);
        }
        for (String cookie : cookies) {
            if (cookie == null) continue;
            MdNode cookieNode = MdFactoryHelper.createMdNode((String)"com.stambia.http.rest.header.cookie", (MdNode)headersNode);
            cookieNode.setAttribute("cookieName", cookie, false);
            cookieNode.setName(cookie);
        }
    }

    private MdNode getOriginalResponse(MdNode originalResponsesNode, String lastResultCode) {
        List originalResponses;
        MdNode originalResponse = null;
        if (originalResponsesNode != null && (originalResponses = originalResponsesNode.getNodeByCode(HTTP_REST_RESPONSE)) != null && !originalResponses.isEmpty()) {
            for (MdNode resp : originalResponses) {
                String responseCode = NodeHandlerRest.readAttribute("code", resp);
                if (responseCode == null) continue;
                if (responseCode.equals(lastResultCode)) {
                    originalResponse = resp;
                    continue;
                }
                if (!responseCode.equals("default") || originalResponse != null) continue;
                originalResponse = resp;
            }
        }
        return originalResponse;
    }

    private MdNode reverseXmlNode(MdNode contentNode, MdNode originalRootNode, byte[] data) throws Exception {
        HashMap<String, String> prefixByURI = new HashMap<String, String>();
        for (MdNode n : originalRootNode.getNodeByCode("com.stambia.xml.namespace")) {
            prefixByURI.put(n.getName(), MdAttributeNativeEvaluator.readAttribute((String)"prefix", (MdNode)n, null));
        }
        XmlStreamReverser helper = new XmlStreamReverser(prefixByURI);
        MdNode xmlNode = helper.reverse(contentNode, (InputStream)new ByteArrayInputStream(data));
        Attribute originalType = xmlNode.getAttributeByShortCode("originalType");
        xmlNode.setDefType("com.stambia.xml.element");
        if (originalType != null) {
            originalType.setDefType("com.stambia.xml.element.originalType");
        }
        return xmlNode;
    }

    private void reverseJsonNode(MdNode contentNode, MdNode originalContentNode, MdNode originalServerNode, String data) {
        MdNode json = MdFactory.eINSTANCE.createMdNode();
        String outputRootName = null;
        if (originalContentNode != null && !originalContentNode.getNode().isEmpty()) {
            outputRootName = ((MdNode)originalContentNode.getNode().get(0)).getName();
        }
        if (outputRootName == null) {
            outputRootName = "root";
        }
        json.setName(outputRootName);
        if (data.trim().startsWith("{")) {
            json.setDefType("com.stambia.json.rootObject");
        } else if (data.startsWith("[")) {
            json.setDefType("com.stambia.json.rootArray");
        } else {
            json.setDefType("com.stambia.json.rootValue");
        }
        contentNode.getNode().add((Object)json);
        try {
            ReverseJsonAction.reverse((MdNode)json, (int)3, (String)data, (boolean)true, (MdNode)originalServerNode);
        }
        catch (ExecuteException e) {
            Logger.getLogger(NodeHandlerRest.class.getName()).log(Level.SEVERE, Messages.NodeHandlerRest_0, e);
        }
    }

    private List<MdNode> addContentNode(MdNode originalContentNode, MdNode originalServerNode, MdNode parentNode, String inputData, String inputType, String mediaType) {
        ArrayList<MdNode> namespaceNodes = new ArrayList<MdNode>();
        if (inputData != null && !inputData.isEmpty() && inputType != null && !inputType.isEmpty()) {
            MdNode contentNode = this.createOrCopyNode(originalContentNode, parentNode, "com.stambia.http.rest.content");
            contentNode.setAttribute("mediaType", mediaType, false);
            contentNode.setAttribute("contentType", inputType, false);
            if (InvocationUI.MimeType.JSON.getMediaType().equals(mediaType)) {
                this.reverseJsonNode(contentNode, originalContentNode, originalServerNode, inputData);
            } else if (InvocationUI.MimeType.XML.getMediaType().equals(mediaType)) {
                try {
                    MdNode xmlNode = this.reverseXmlNode(contentNode, originalServerNode, inputData.getBytes());
                    for (MdNode namespace : new ArrayList(xmlNode.getNodeByCode("com.stambia.xml.namespace"))) {
                        xmlNode.getNode().remove((Object)namespace);
                        namespaceNodes.add(namespace);
                    }
                    contentNode.getNode().add((Object)xmlNode);
                }
                catch (Exception e) {
                    Logger.getLogger(NodeHandlerRest.class.getName()).log(Level.SEVERE, Messages.NodeHandlerRest_0, e);
                }
            } else if (InvocationUI.MimeType.FORM.getMediaType().equals(mediaType)) {
                this.reverseFormNode(contentNode, inputData);
            }
        }
        return namespaceNodes;
    }

    private void reverseFormNode(MdNode contentNode, String inputData) {
        String[] stringArray = inputData.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] keyValue = s.split("=");
            if (keyValue.length == 2) {
                MdNode formValueNode = MdFactory.eINSTANCE.createMdNode();
                formValueNode.setDefType("com.stambia.http.rest.formvalue");
                formValueNode.setName(keyValue[0]);
                contentNode.getNode().add((Object)formValueNode);
            }
            ++n2;
        }
    }

    private void addParameterNodes(MdNode methodNode, MdNode originalParamsNode, List<RestWizardBean.Parameter> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            MdNode paramsNode = this.createOrCopyNode(originalParamsNode, methodNode, HTTP_REST_PARAMETERS);
            for (RestWizardBean.Parameter param : parameters) {
                if (param.type == RestWizardControler.BindingType.MIME_CONTENT) continue;
                MdNode originalParamNode = null;
                if (originalParamsNode != null) {
                    originalParamNode = originalParamsNode.getNodeByName(HTTP_REST_PARAMETER, param.name);
                }
                MdNode paramNode = this.createOrCopyNode(originalParamNode, paramsNode, HTTP_REST_PARAMETER);
                paramNode.setName(param.name);
                String location = switch (param.type) {
                    case RestWizardControler.BindingType.HTTP_HEADER -> "header";
                    case RestWizardControler.BindingType.HTTP_URL_ENCODED -> "query";
                    case RestWizardControler.BindingType.HTTP_URL_REPLACEMENT -> "path";
                    case RestWizardControler.BindingType.HTTP_COOKIE -> "cookie";
                    default -> null;
                };
                if (param.allowEmptyValue != null) {
                    paramNode.setAttribute("allowEmptyValue", String.valueOf(param.allowEmptyValue), false);
                }
                if (location == null) continue;
                paramNode.setAttribute("location", location, false);
            }
        }
    }

    @Override
    public void refreshExistingAuthenticationMdNode(MdNode rootMdNode) {
        ArrayList<MdNode> securityNodes = new ArrayList<MdNode>();
        try {
            Collection credentialCollection = (Collection)rootMdNode.evaluateXpathExpressionMdSet("INTERNAL_AVAILABLE_SECURITY_CREDENTIALS_REF");
            if (credentialCollection != null) {
                securityNodes.addAll(credentialCollection);
            }
        }
        catch (XPathExpressionException e) {
            this.logger.warn("Error while retrieving security credentials", (Throwable)e);
        }
        this.controler.setAuthenticationMdNodes(securityNodes);
    }

    private MdNode findFirstNode(MdNode reversedMdNode, String defType) {
        if (reversedMdNode == null) {
            return null;
        }
        List l = reversedMdNode.getNodeByCode(defType);
        if (l == null || l.isEmpty()) {
            if (reversedMdNode.getDefType().equals(defType)) {
                return reversedMdNode;
            }
            return null;
        }
        return (MdNode)l.get(0);
    }

    private MdNode createOrCopyNode(MdNode originalNode, MdNode newParentNode, String defType) {
        MdNode newNode = originalNode != null ? originalNode.copy(1) : MdFactory.eINSTANCE.createMdNode();
        boolean contains = false;
        for (MdNode n : newParentNode.getNode()) {
            if (n.getName() == null || !n.getName().equals(newNode.getName())) continue;
            contains = true;
        }
        if (!contains) {
            newParentNode.getNode().add((Object)newNode);
            newNode.setDefType(defType);
        }
        return newNode;
    }

    private void addOtherResponseNodes(MdNode originalResponseNodes, MdNode newResponsesNode, String lastResultCode) {
        if (originalResponseNodes != null) {
            for (MdNode response : originalResponseNodes.getNodeByCode(HTTP_REST_RESPONSE)) {
                if (NodeHandlerRest.readAttribute("code", response).equals(lastResultCode)) continue;
                this.deepCopyNode(response, newResponsesNode);
            }
        }
    }

    private void addOtherMethodNodes(MdNode originalResourceNode, MdNode newResourceNode, String verb) {
        if (originalResourceNode != null) {
            for (MdNode method : originalResourceNode.getNodeByCode(HTTP_REST_OPERATION)) {
                if (NodeHandlerRest.readAttribute("method", method).equals(verb)) continue;
                this.deepCopyNode(method, newResourceNode);
            }
        }
    }

    private void deepCopyNode(MdNode node, MdNode parent) {
        MdNode newNode = this.createOrCopyNode(node, parent, node.getDefType());
        for (MdNode child : node.getNode()) {
            this.deepCopyNode(child, newNode);
        }
    }
}

