/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.wizard;

import com.indy.addons.httprest.ReverseOpenApiAction;
import com.indy.addons.httprest.wizard.Messages;
import com.indy.addons.httprest.wizard.WizardBean;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EnvironmentVariableHelper;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import java.io.File;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.osgi.service.log.LogService;

public class WizardControler {
    public static final String NO_SECURITY = "--- None ---";
    public static final String NO_STORE = "--- None ---";
    private MdNode reversedMdNode;
    private WizardBean bean;
    private IProgressMonitor monitor;
    private final org.apache.logging.log4j.Logger logger = LogManager.getLogger(this.getClass());

    public WizardControler(MdNode reversedNode) {
        this.reversedMdNode = reversedNode;
        this.bean = new WizardBean();
        this.initialize();
    }

    private void initialize() {
        String url = "";
        try {
            url = MdAttributeReader.readAttribute((String)"reverseUrl", (MdNode)this.reversedMdNode);
        }
        catch (MdAttributeReader.UnknownTechPropertyException unknownTechPropertyException) {
            // empty catch block
        }
        MdNode secu = null;
        try {
            secu = MdAttributeReader.readAttributeRef((String)"security", (MdNode)this.reversedMdNode);
        }
        catch (MdAttributeReader.UnknownTechPropertyException unknownTechPropertyException) {
            // empty catch block
        }
        this.bean.setReverseURL(url == null ? "" : url);
        this.bean.setSecurityMdNode(secu);
        MdNode proxy = null;
        try {
            proxy = MdAttributeReader.readAttributeRef((String)"proxy", (MdNode)this.reversedMdNode);
        }
        catch (MdAttributeReader.UnknownTechPropertyException unknownTechPropertyException) {
            // empty catch block
        }
        this.bean.setProxyMdNode(proxy);
        MdNode keystore = null;
        try {
            keystore = MdAttributeReader.readAttributeRef((String)"keystore", (MdNode)this.reversedMdNode);
        }
        catch (MdAttributeReader.UnknownTechPropertyException unknownTechPropertyException) {
            // empty catch block
        }
        this.bean.setKeystoreMdNode(keystore);
        MdNode truststore = null;
        try {
            truststore = MdAttributeReader.readAttributeRef((String)"truststore", (MdNode)this.reversedMdNode);
        }
        catch (MdAttributeReader.UnknownTechPropertyException unknownTechPropertyException) {
            // empty catch block
        }
        this.bean.setTrustStoreMdNode(truststore);
    }

    public MdNode createReversedMdNode(boolean includeReverseOpenAPI, boolean includeReverseURL) throws Exception {
        MdNode newNode = this.reversedMdNode.copy(1);
        newNode.setSubstituteContainer(this.reversedMdNode.eContainer());
        Attribute att = newNode.getAttributeByShortCode("security");
        if (att == null) {
            att = MdFactoryHelper.createAttribute((String)"com.stambia.http.rest.security");
            newNode.getAttribute().add((Object)att);
        }
        att.setRef((EObject)this.getBean().getSecurityMdNode());
        att = newNode.getAttributeByShortCode("keystore");
        if (att == null) {
            att = MdFactoryHelper.createAttribute((String)"com.stambia.certificatesAndKeys.store");
            newNode.getAttribute().add((Object)att);
        }
        att.setRef((EObject)this.getBean().getKeystoreMdNode());
        att = newNode.getAttributeByShortCode("truststore");
        if (att == null) {
            att = MdFactoryHelper.createAttribute((String)"com.stambia.certificatesAndKeys.store");
            newNode.getAttribute().add((Object)att);
        }
        att.setRef((EObject)this.getBean().getTrustStoreMdNode());
        att = newNode.getAttributeByShortCode("proxy");
        if (att == null) {
            att = MdFactoryHelper.createAttribute((String)"com.stambia.http.rest.proxy");
            newNode.getAttribute().add((Object)att);
        }
        att.setRef((EObject)this.getBean().getProxyMdNode());
        if (includeReverseURL) {
            att = newNode.getAttributeByShortCode("reverseUrl");
            if (att == null) {
                att = MdFactoryHelper.createAttribute((String)"com.stambia.http.rest.reverseUrl");
                newNode.getAttribute().add((Object)att);
            }
            att.setValue(this.getBean().getReverseURL());
        }
        if (includeReverseOpenAPI) {
            try {
                newNode = ReverseOpenApiAction.createReversedMdNode(newNode, this.monitor);
            }
            catch (ReverseOpenApiAction.OpenAPIException ex) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(this.getClass()).error("The following error occured during Open API reverse", (Object)ex);
                newNode = ex.getOpenAPIToMd();
            }
        }
        return newNode;
    }

    public WizardBean getBean() {
        return this.bean;
    }

    public List getAvailableSecurityNodes() {
        ArrayList<String> securityNodes = new ArrayList<String>();
        securityNodes.add("--- None ---");
        try {
            Collection credentialCollection = (Collection)this.reversedMdNode.evaluateXpathExpressionMdSet("INTERNAL_AVAILABLE_SECURITY_CREDENTIALS_REF");
            if (credentialCollection != null) {
                securityNodes.addAll(credentialCollection);
            }
        }
        catch (XPathExpressionException e) {
            this.logger.warn("Error while retrieving available security credentials", (Throwable)e);
        }
        return securityNodes;
    }

    public List getAvailableProxyNodes() {
        ArrayList<String> securityNodes = new ArrayList<String>();
        securityNodes.add("--- None ---");
        try {
            Collection credentialCollection = (Collection)this.reversedMdNode.evaluateXpathExpressionMdSet("INTERNAL_AVAILABLE_PROXY_REF");
            if (credentialCollection != null) {
                securityNodes.addAll(credentialCollection);
            }
        }
        catch (XPathExpressionException e) {
            this.logger.warn("Error while retrieving available security credentials", (Throwable)e);
        }
        return securityNodes;
    }

    public List<Object> getAvailableKeyStoreAndTrustStoreNodes() {
        ArrayList<Object> securityNodes = new ArrayList<Object>();
        securityNodes.add("--- None ---");
        try {
            Collection keyStoreAndTrustStoreCollection = (Collection)this.reversedMdNode.evaluateXpathExpressionMdSet("INTERNAL_AVAILABLE_KEYSTORE_TRUSTSTORE_REF");
            if (keyStoreAndTrustStoreCollection != null) {
                securityNodes.addAll(keyStoreAndTrustStoreCollection);
            }
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(WizardControler.class.getName()).log(Level.SEVERE, Messages.WizardControler_22, ex);
        }
        return securityNodes;
    }

    public String getBeanReverseURLFileFolderPath() {
        String reverseURL = this.bean.getReverseURL();
        if ((reverseURL = MdAttributeNativeEvaluator.evaluate((String)reverseURL, (Configuration)this.reversedMdNode, null)) != null) {
            try {
                File f = new File(new URI(reverseURL.replace("\\", "/")));
                return f.getParentFile().getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setBeanReverseFileURL(String filePath) {
        String val = MdAttributeNativeEvaluator.preserveNatuveEvaluationBlock((Configuration)this.reversedMdNode, (String)this.bean.getReverseURL(), (String)filePath);
        this.bean.setReverseURL(val);
    }

    public String validateReverseURL() {
        String reverseUrl = this.bean.getReverseURL();
        try {
            reverseUrl = EnvironmentVariableHelper.resolveEnvironmentVariables((String)reverseUrl, (EnvironmentVariableHelper.Mode)EnvironmentVariableHelper.Mode.MdModel);
            URI uri = new URI(URLEncoder.encode(reverseUrl, "UTF-8"));
            return null;
        }
        catch (Exception ex) {
            return Messages.WizardControler_21 + ex.getMessage();
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

