/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth1.wizard;

import com.indy.addons.oauth1.wizard.BasicAuthenticationBean;
import com.indy.addons.oauth1.wizard.Oauth1Bean;
import com.indy.addons.oauth1.wizard.Oauth1Controller;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import com.stambia.tech.provider.wizard.IBeanLinker;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BeanMdLinker
implements IBeanLinker {
    public static final String DEF_TYPE_OAUTH1 = "com.stambia.wsdl.oauth";
    public static final String DEF_TYPE_OAUTH2 = "com.stambia.wsdl.oauth2";
    public static final String DEF_TYPE_BASIC = "com.stambia.wsdl.basicauth";
    public static final String DEF_TYPE_NTLM = "com.stambia.wsdl.ntlm";
    public static final String DEF_TYPE_BASIC_STANDALONE = "com.stambia.security.basic";
    public static final String DEF_TYPE_OAUTH1_STANDALONE = "com.stambia.security.oauth";
    private final Logger logger = LogManager.getLogger(this.getClass());
    private MdNode node;
    private Oauth1Bean oauth1Bean = new Oauth1Bean();
    Oauth1Controller oauth1Controller;
    private BasicAuthenticationBean basicBean = new BasicAuthenticationBean();
    private boolean refreshBean = false;
    String token;
    String tokenSecret;

    public BeanMdLinker() {
        this.oauth1Controller = new Oauth1Controller(this.oauth1Bean);
    }

    public void dispose() {
        this.oauth1Controller.dispose();
    }

    public void setNode(MdNode node) {
        this.node = node;
        this.refreshBean = true;
    }

    public Object getBean() {
        if (this.refreshBean) {
            if (DEF_TYPE_OAUTH1.equals(this.node.getDefType()) || DEF_TYPE_OAUTH1_STANDALONE.equals(this.node.getDefType())) {
                this.refreshOauth1Bean();
            } else if (DEF_TYPE_BASIC.equals(this.node.getDefType()) || DEF_TYPE_BASIC_STANDALONE.equals(this.node.getDefType())) {
                this.refreshBasicBean();
            }
            this.refreshBean = false;
        }
        if (DEF_TYPE_OAUTH1.equals(this.node.getDefType()) || DEF_TYPE_OAUTH1_STANDALONE.equals(this.node.getDefType())) {
            return this.oauth1Bean;
        }
        if (DEF_TYPE_BASIC.equals(this.node.getDefType()) || DEF_TYPE_BASIC_STANDALONE.equals(this.node.getDefType())) {
            return this.basicBean;
        }
        throw new RuntimeException();
    }

    private String readAttribute(String shortCode) {
        try {
            return MdAttributeReader.readAttribute((String)shortCode, (MdNode)this.node);
        }
        catch (Exception e) {
            this.logger.warn("Unable to read attribute", (Throwable)e);
            return "";
        }
    }

    private void refreshBasicBean() {
        this.basicBean.userName = this.readAttribute("userName");
        this.basicBean.password = this.readAttribute("password");
        this.basicBean.name = this.node.getName();
        if (this.basicBean.name == null) {
            this.basicBean.name = "";
        }
    }

    private void refreshOauth1Bean() {
        this.oauth1Bean.consumerKey = this.readAttribute("consumerKey");
        this.oauth1Bean.consumerSecret = this.readAttribute("consumerSecret");
        this.oauth1Bean.signatureMethod = this.readAttribute("signatureMethod");
        this.oauth1Bean.requestTokenBean.httpMethod = this.readAttribute("requestTokenHttpMethod");
        this.oauth1Bean.requestTokenBean.url = this.readAttribute("requestTokenURL");
        this.token = this.readAttribute("token");
        this.tokenSecret = this.readAttribute("tokenSecret");
        this.oauth1Bean.authorizationBean.callBackURL = this.readAttribute("callbackURL");
        this.oauth1Bean.accessTokenResponse.oauthToken = this.token;
        this.oauth1Bean.accessTokenResponse.oauthTokenSecret = this.tokenSecret;
        Attribute a = this.node.getAttributeByShortCode("requestTokenParameter");
        if (a != null) {
            for (String s : a.getValueEntry().keySet()) {
                this.oauth1Bean.requestTokenBean.additionalParams.add(new Oauth1Bean.ParameterBean(s, (String)a.getValueEntry().get((Object)s)));
            }
        }
        this.oauth1Bean.accessTokenBean.httpMethod = this.readAttribute("accessTokenHttpMethod");
        this.oauth1Bean.accessTokenBean.url = this.readAttribute("accessTokenURL");
        this.oauth1Bean.authorizationBean.url = this.readAttribute("authorizationURL");
        a = this.node.getAttributeByShortCode("authorizationParameter");
        if (a != null) {
            for (String s : a.getValueEntry().keySet()) {
                this.oauth1Bean.authorizationBean.additionalParams.add(new Oauth1Bean.ParameterBean(s, (String)a.getValueEntry().get((Object)s)));
            }
        }
    }

    public MdNode updateMdNode() throws Exception {
        MdNode node = this.node;
        if (DEF_TYPE_OAUTH1.equals(node.getDefType()) || DEF_TYPE_OAUTH1_STANDALONE.equals(node.getDefType())) {
            this.setAttribute("token", this.oauth1Bean.accessTokenResponse.oauthToken, node);
            this.setAttribute("tokenSecret", this.oauth1Bean.accessTokenResponse.oauthTokenSecret, node);
            this.setAttribute("consumerKey", this.oauth1Bean.consumerKey, node);
            this.setAttribute("consumerSecret", this.oauth1Bean.consumerSecret, node);
            this.setAttribute("signatureMethod", this.oauth1Bean.signatureMethod, node);
            this.setAttribute("requestTokenURL", this.oauth1Bean.requestTokenBean.url, node);
            this.setAttribute("requestTokenHttpMethod", this.oauth1Bean.requestTokenBean.httpMethod, node);
            this.setAttribute("requestTokenParameter", this.oauth1Bean.requestTokenBean.additionalParams, node);
            this.setAttribute("accessTokenURL", this.oauth1Bean.accessTokenBean.url, node);
            this.setAttribute("accessTokenHttpMethod", this.oauth1Bean.accessTokenBean.httpMethod, node);
            this.setAttribute("authorizationURL", this.oauth1Bean.authorizationBean.url, node);
            this.setAttribute("authorizationParameter", this.oauth1Bean.authorizationBean.additionalParams, node);
        } else if (DEF_TYPE_BASIC.equals(node.getDefType()) || DEF_TYPE_BASIC_STANDALONE.equals(node.getDefType())) {
            this.setAttribute("userName", this.basicBean.userName, node);
            this.setAttribute("password", this.basicBean.password, node);
            node.setName(this.basicBean.name);
        }
        return node;
    }

    private void setAttribute(String shortCode, Object value, MdNode n) {
        Property p = this.node.getLevel().getAttributeByShortCode(shortCode);
        Attribute a = n.getAttributeByShortCode(shortCode);
        if (a == null) {
            a = MdFactoryHelper.createAttribute((String)(this.node.getDefType() + "." + shortCode));
        }
        if (p.isUnbounded()) {
            boolean addedVal = false;
            for (Object o : (List)value) {
                if (o == null) continue;
                if (p.isKeyValue() && o instanceof Oauth1Bean.ParameterBean) {
                    if (((Oauth1Bean.ParameterBean)o).name == null) continue;
                    a.getValueEntry().put((Object)((Oauth1Bean.ParameterBean)o).name, (Object)((Oauth1Bean.ParameterBean)o).value);
                    addedVal = true;
                    continue;
                }
                a.getValues().add((Object)o.toString());
                addedVal = true;
            }
            if (addedVal) {
                n.getAttribute().add((Object)a);
            }
        } else {
            String v = null;
            if (value instanceof String) {
                if (!((String)value).trim().isEmpty()) {
                    v = (String)value;
                }
            } else {
                String string = v = value == null ? "" : value.toString();
            }
            if (p.getType() == PropertyType.PASSWORD) {
                try {
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    v = semaphoreManager.setSemaphore(true, v);
                }
                catch (Exception e) {
                    this.logger.debug("Error while setting semaphore", (Throwable)e);
                }
            }
            if (v != null) {
                a.setValue(v);
                n.getAttribute().add((Object)a);
            }
        }
    }
}

