/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.tokenBearer.wizard;

import com.indy.addons.tokenBearer.wizard.BearerTokenBean;
import com.indy.addons.tokenBearer.wizard.BearerTokenException;
import com.indy.addons.tokenBearer.wizard.Messages;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class BearerTokenControler {
    static final String DEF_TYPE = "com.stambia.security.bearerToken";
    private static final String BEARER_TOKEN_ATTR = "bearerToken";
    private static final String BEARER_TOKEN_QUALIF_ATTR = "com.stambia.security.bearerToken.bearerToken";
    private static final Logger LOGGER = LogManager.getLogger(BearerTokenControler.class);
    protected BearerTokenBean bean = new BearerTokenBean();
    protected MdNode originalNodeParent;
    protected MdNode original;

    public BearerTokenControler(MdNode originalNode, MdNode originalParent) {
        this.initBean(originalNode, originalParent);
        this.original = originalNode;
    }

    public MdNode createNewMdNode() {
        MdNode node = this.original == null ? MdFactoryHelper.createMdNode((String)DEF_TYPE) : this.original.copy(1);
        node.setName(this.bean.getName());
        Attribute attribute = node.getAttributeByShortCode(BEARER_TOKEN_ATTR);
        if (attribute == null) {
            attribute = MdFactoryHelper.createAttribute((String)BEARER_TOKEN_QUALIF_ATTR);
            node.getAttribute().add((Object)attribute);
        }
        try {
            SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
            attribute.setValue(semaphoreManager.setSemaphore(true, this.bean.getBearerToken()));
        }
        catch (Exception e) {
            LOGGER.error(Messages.tokenBearerWizardError, (Throwable)e);
            throw new BearerTokenException(e);
        }
        node.setSubstituteContainer((EObject)this.originalNodeParent);
        return node;
    }

    public void initBean(MdNode mdNode, MdNode parent) {
        this.originalNodeParent = parent;
        if (mdNode != null) {
            if (mdNode.getName() != null) {
                this.bean.setName(mdNode.getName());
            }
            try {
                this.bean.setBearerToken(MdAttributeReader.readAttribute((String)BEARER_TOKEN_ATTR, (MdNode)mdNode, (String)""));
            }
            catch (MdAttributeReader.UnknownTechPropertyException e) {
                LOGGER.error(Messages.tokenBearerWizardError, (Throwable)e);
                throw new BearerTokenException((Exception)((Object)e));
            }
        }
    }

    public BearerTokenBean getBean() {
        return this.bean;
    }
}

