/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.wsdl;

import com.indy.addons.httprest.Md2AuthenticationFactory;
import com.indy.addons.httprest.NtlmAuthentication;
import com.semarchy.xdi.base.core.auth.AuthenticationInfo;
import com.semarchy.xdi.designer.core.SSLContextFactory;
import com.semarchy.xdi.designer.core.http.ApacheHttpClient;
import com.stambia.md.MdNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;

class SecurizedHttpURIHandler
extends URIHandlerImpl {
    private MdNode authenticationNode;

    SecurizedHttpURIHandler(MdNode authenticationNode) {
        this.authenticationNode = authenticationNode;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        try {
            SSLContextFactory.SSLContextParameters contextParams = new SSLContextFactory.SSLContextParameters();
            SSLContext sc = SSLContextFactory.createSSLContext((SSLContextFactory.SSLContextParameters)contextParams);
            Throwable throwable = null;
            Object var6_8 = null;
            try (ApacheHttpClient client = ApacheHttpClient.build((ApacheHttpClient.SslConfig)new ApacheHttpClient.SslConfig(sc));){
                AuthenticationInfo authorizationInfo = Md2AuthenticationFactory.getAuthenticationInfo(this.authenticationNode, new URL(uri.toString()), "GET", null);
                HashMap<String, String> headers = new HashMap<String, String>();
                Credentials credentials = null;
                if (authorizationInfo != null) {
                    if (authorizationInfo instanceof NtlmAuthentication) {
                        NtlmAuthentication ntlmAuthorization = (NtlmAuthentication)authorizationInfo;
                        credentials = ApacheHttpClient.createNTAuthCredentials((String)ntlmAuthorization.getUsername(), (char[])ntlmAuthorization.getPassword().toCharArray(), (String)ntlmAuthorization.getDomain());
                    } else {
                        headers.put("Authorization", authorizationInfo.getAuthenticationHeaderValue(null));
                    }
                }
                return (InputStream)client.get(uri.toString(), Collections.emptyMap(), headers, credentials, false, r -> new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)r.getEntity())));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

