/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.avro.reader;

import com.indy.engine.core.UtilsService;
import com.stambia.avro.reader.AvroToHierarchyEventReader;
import com.stambia.avro.reader.Messages;
import com.stambia.avro.reader.visitor.AvroXMLConverter;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class AvroXMLReader
implements XMLReader {
    private final Logger logger = LogManager.getLogger(this.getClass());
    boolean bsonStyle;
    ContentHandler handler;

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String paramString) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public Object getProperty(String paramString) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setBsonStyle(boolean bsonStyle) {
        this.bsonStyle = bsonStyle;
    }

    @Override
    public void parse(InputSource paramInputSource) throws IOException, SAXException {
        AvroToHierarchyEventReader jxer = null;
        try {
            try {
                InputStream is = paramInputSource.getByteStream();
                jxer = is != null ? new AvroToHierarchyEventReader(is) : new AvroToHierarchyEventReader(paramInputSource.getByteStream());
                if (this.handler == null) {
                    throw new IOException(Messages.getString("AvroXMLReader.0"));
                }
                UtilsService.getXmlUtils().xmlReaderToContentHandler(jxer.creatXMLEventReader(AvroXMLConverter.INSTANCE), this.handler);
            }
            catch (Exception ex) {
                throw new SAXException(Messages.getString("AvroXMLReader.1"), ex);
            }
        }
        finally {
            try {
                if (jxer != null) {
                    jxer.close();
                }
            }
            catch (XMLStreamException e) {
                this.logger.warn(Messages.getString("AvroXMLReader.2"), (Throwable)e);
            }
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public void setContentHandler(ContentHandler paramContentHandler) {
        this.handler = paramContentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler paramDTDHandler) {
    }

    @Override
    public void setEntityResolver(EntityResolver paramEntityResolver) {
    }

    @Override
    public void setErrorHandler(ErrorHandler paramErrorHandler) {
    }

    @Override
    public void setFeature(String paramString, boolean paramBoolean) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setProperty(String paramString, Object paramObject) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

