/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.avro.reader.visitor;

import com.indy.runtime.hierarchy.HierarchyEvent;
import com.indy.runtime.hierarchy.HierarchyEventFactory;
import com.stambia.avro.reader.visitor.AvroVisitorInterface;
import com.stambia.avro.reader.visitor.AvroXMLConverter;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;

public final class AvroVisitorImplementation
implements AvroVisitorInterface {
    private final List<HierarchyEvent> avroEventList;
    private static final HierarchyEventFactory hierachyEventFactory = new HierarchyEventFactory();
    AvroXMLConverter converter = AvroXMLConverter.INSTANCE;

    public AvroVisitorImplementation(List<HierarchyEvent> avroEventList) {
        this.avroEventList = avroEventList != null ? avroEventList : new ArrayList<HierarchyEvent>();
    }

    @Override
    public void clearEventList() {
        this.avroEventList.clear();
    }

    @Override
    public final void visitStartArray() {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createStartElement("array", this.converter.getTypeCode(AvroXMLConverter.AvroType.ARRAY)));
    }

    @Override
    public final void visitEndArray() {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement("array"));
    }

    @Override
    public final void visitStartMap() {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createStartElement("map", this.converter.getTypeCode(AvroXMLConverter.AvroType.MAP)));
    }

    @Override
    public final void visitEndMap() {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement("map"));
    }

    @Override
    public final void visitStartRecord(String name) {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createStartElement("rec_" + name, this.converter.getTypeCode(AvroXMLConverter.AvroType.RECORD)));
    }

    @Override
    public final void visitEndRecord(String name) {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement("rec_" + name));
    }

    @Override
    public final void visitStartField(String name) {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createStartElement(name, this.converter.getTypeCode(AvroXMLConverter.AvroType.FIELD)));
    }

    @Override
    public final void visitEndField(String name) {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement(name));
    }

    @Override
    public final void visitStartKey(String name) {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createData("key", this.converter.getTypeCode(AvroXMLConverter.AvroType.KEY), (Object)name));
    }

    @Override
    public final void visitEndKey() {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement("key"));
    }

    @Override
    public final void visitEnum(GenericData.EnumSymbol enumSymbol) {
        if (enumSymbol != null) {
            String name = enumSymbol.getSchema().getFullName();
            this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createData("enu_" + name, this.converter.getTypeCode(AvroXMLConverter.AvroType.ENUM), (Object)enumSymbol));
            this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement("enu_" + name));
        }
    }

    @Override
    public final void visitFixed(GenericData.Fixed fixed) {
        if (fixed != null) {
            String name = fixed.getSchema().getFullName();
            this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createData("fix_" + name, this.converter.getTypeCode(AvroXMLConverter.AvroType.FIXED), (Object)fixed));
            this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement("fix_" + name));
        }
    }

    @Override
    public final void visitPrimitive(Object avroPrimitive, Schema schema) throws Exception {
        if (avroPrimitive == null) {
            this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createData("null", this.converter.getTypeCode(AvroXMLConverter.AvroType.NULL), null));
            this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement("null"));
        } else {
            if (schema == null) {
                throw new IllegalArgumentException("Missing avro schema");
            }
            AvroXMLConverter.InternalType type = schema.getObjectProps() != null ? AvroXMLConverter.INSTANCE.getInternalType(schema.getType(), schema.getObjectProps()) : AvroXMLConverter.INSTANCE.getInternalType(schema.getType());
            int dataType = type.getTypeCode();
            String name = AvroXMLConverter.INSTANCE.getTypeName(dataType);
            this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createData(name, dataType, avroPrimitive));
            this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement(name));
        }
    }

    @Override
    public void visitStartIndex(int index) {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createData("index", this.converter.getTypeCode(AvroXMLConverter.AvroType.INDEX), (Object)String.valueOf(index)));
    }

    @Override
    public void visitEndIndex() {
        this.avroEventList.add((HierarchyEvent)hierachyEventFactory.createEndElement("index"));
    }
}

