/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.avro.reader.visitor;

import com.indy.runtime.hierarchy.IXMLConverter;
import com.stambia.avro.reader.visitor.FormatHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

public class AvroXMLConverter
implements IXMLConverter {
    public static AvroXMLConverter INSTANCE = new AvroXMLConverter();
    Map<String, InternalType> internalTypeCache = Collections.synchronizedMap(new HashMap());
    Map<Integer, InternalType> internalTypeCache2 = Collections.synchronizedMap(new HashMap());

    private static void checkType(Object data, Class<?> expected, String logicalType) {
        if (data != null && !expected.isInstance(data)) {
            throw new RuntimeException("Impossible to convert: " + data.getClass().getName() + " to " + logicalType);
        }
    }

    public InternalType getInternalType(int _type) {
        return this.internalTypeCache2.get(_type);
    }

    public InternalType getInternalType(AvroType _type) {
        return this.getInternalType(_type.getName().toLowerCase());
    }

    public String getTypeName(int type) {
        return this.getInternalType(type).getName();
    }

    private InternalType getInternalType(String typeName) {
        InternalType it = this.internalTypeCache.get(typeName);
        if (it != null) {
            return it;
        }
        it = new InternalType();
        String _typeName = typeName.toLowerCase();
        String[] s = _typeName.split("_");
        String avroType = s[0];
        it.avroType = AvroType.valueOf(avroType.toUpperCase());
        int index = it.avroType.ordinal();
        int precision = -1;
        int scale = -1;
        if (s.length > 1) {
            String logicType = s[1];
            it.logicalType = AvroLogicalType.valueOf(logicType.toUpperCase());
            index = AvroType.values().length + it.logicalType.ordinal();
            if (s.length > 2) {
                precision = Integer.valueOf(s[2]);
                if (s.length > 3) {
                    scale = Integer.valueOf(s[3]);
                }
            }
        }
        it.avroName = _typeName;
        it.precision = precision;
        it.scale = scale;
        if (precision > 0) {
            index *= 1000000;
            index += Integer.valueOf(precision) * 1000;
            it.avroCode = index += Integer.valueOf(scale).intValue();
        } else {
            it.avroCode = index;
        }
        this.internalTypeCache.put(it.avroName, it);
        this.internalTypeCache2.put(it.avroCode, it);
        return it;
    }

    public int getTypeCode(String typeName) {
        InternalType it = this.getInternalType(typeName);
        return it.getTypeCode();
    }

    private String printData(InternalType type, Object data) {
        if (type.logicalType != null) {
            return this.handleLogicalType(type, data);
        }
        switch (type.avroType) {
            case INT: {
                return DatatypeConverter.printInt((int)((Integer)data));
            }
            case STRING: 
            case KEY: 
            case INDEX: {
                if (data instanceof Utf8) {
                    return ((Utf8)data).toString();
                }
                return DatatypeConverter.printString((String)((String)data));
            }
            case FIXED: {
                return DatatypeConverter.printBase64Binary((byte[])((GenericData.Fixed)data).bytes());
            }
            case ENUM: {
                return ((GenericData.EnumSymbol)data).toString();
            }
            case LONG: {
                return DatatypeConverter.printLong((long)((Long)data));
            }
            case BYTES: {
                if (data instanceof ByteBuffer) {
                    return DatatypeConverter.printBase64Binary((byte[])((ByteBuffer)data).array());
                }
                return DatatypeConverter.printBase64Binary((byte[])((byte[])data));
            }
            case FLOAT: {
                return DatatypeConverter.printFloat((float)((Float)data).floatValue());
            }
            case BOOLEAN: {
                return DatatypeConverter.printBoolean((boolean)((Boolean)data));
            }
            case DOUBLE: {
                return DatatypeConverter.printDouble((double)((Double)data));
            }
        }
        return null;
    }

    private String handleLogicalType(InternalType type, Object data) {
        if (type.logicalType != null) {
            switch (type.logicalType) {
                case TIMESTAMPMILLIS: {
                    return this.handleTimestampMillis(data);
                }
                case TIMEMILLIS: {
                    return this.handleTimeMillis(data);
                }
                case DATE: {
                    return this.handleDate(data);
                }
                case DECIMAL: {
                    return this.handleDecimal(type, data);
                }
                case TIMEMICROS: {
                    return this.handleTimeMicros(data);
                }
                case TIMESTAMPMICROS: {
                    return this.handleTimestampMicros(data);
                }
                case UUID: {
                    return this.handleUuid(data);
                }
                case LOCALTIMESTAMPMILLIS: {
                    return this.handleLocalTimestampMillis(data);
                }
                case LOCALTIMESTAMPMICROS: {
                    return this.handleLocalTimestampMicros(data);
                }
            }
            return null;
        }
        return null;
    }

    private String handleUuid(Object data) {
        String result = null;
        if (data != null) {
            if (data instanceof String) {
                result = DatatypeConverter.printString((String)((String)data));
            } else if (data instanceof Utf8) {
                result = DatatypeConverter.printString((String)((Utf8)data).toString());
            }
        }
        return result;
    }

    private String handleLocalTimestampMicros(Object data) {
        AvroXMLConverter.checkType(data, Long.class, "localtimestamp-micros");
        return FormatHandler.localTimestampMicros((Long)data);
    }

    private String handleLocalTimestampMillis(Object data) {
        AvroXMLConverter.checkType(data, Long.class, "localtimestamp-millis");
        return FormatHandler.localTimestampMillis((Long)data);
    }

    private String handleTimestampMicros(Object data) {
        AvroXMLConverter.checkType(data, Long.class, "timestamp-micros");
        return FormatHandler.timestampMicros((Long)data);
    }

    private String handleTimeMicros(Object data) {
        AvroXMLConverter.checkType(data, Long.class, "time-micros");
        return FormatHandler.timeMicros((Long)data);
    }

    private String handleDecimal(InternalType type, Object data) {
        byte[] b;
        if (data != null && !(data instanceof ByteBuffer) && !(data instanceof byte[])) {
            throw new RuntimeException("Impossible to convert: " + data.getClass().getName() + " to decimal");
        }
        if (data instanceof ByteBuffer) {
            b = ((ByteBuffer)data).array();
        } else if (data instanceof byte[]) {
            b = (byte[])data;
        } else {
            throw new RuntimeException("error");
        }
        BigInteger bi = new BigInteger(b);
        BigDecimal bd = new BigDecimal(bi, type.scale);
        if (bd.precision() > type.precision) {
            throw new RuntimeException("Error precision: " + bd.precision() + " > " + type.precision);
        }
        return DatatypeConverter.printDecimal((BigDecimal)bd);
    }

    private String handleDate(Object data) {
        AvroXMLConverter.checkType(data, Integer.class, "date");
        return FormatHandler.dateFromEpochDays((Integer)data);
    }

    private String handleTimeMillis(Object data) {
        AvroXMLConverter.checkType(data, Integer.class, "time-millis");
        return FormatHandler.timeMillis((Integer)data);
    }

    private String handleTimestampMillis(Object data) {
        AvroXMLConverter.checkType(data, Long.class, "timestamp-millis");
        return FormatHandler.timestampMillis((Long)data);
    }

    public String printData(int _type, Object data) {
        if (data != null) {
            InternalType type = this.getInternalType(_type);
            return this.printData(type, data);
        }
        return null;
    }

    public Object parseData(InternalType type, String data, Schema schema) {
        if (type.logicalType != null) {
            switch (type.logicalType) {
                case TIMESTAMPMILLIS: {
                    return this.parseTimestampMillis(type, data);
                }
                case TIMEMILLIS: {
                    return this.parseTimeMillis(type, data);
                }
                case DATE: {
                    return this.parseDate(type, data);
                }
                case DECIMAL: {
                    return this.parseDecimal(type, data);
                }
                case TIMEMICROS: {
                    return this.parseTimeMicros(type, data);
                }
                case TIMESTAMPMICROS: {
                    return this.parseTimestampMicros(type, data);
                }
                case UUID: {
                    return this.parseUuid(type, data);
                }
                case LOCALTIMESTAMPMILLIS: {
                    return this.parseLocalTimestampMillis(type, data);
                }
                case LOCALTIMESTAMPMICROS: {
                    return this.parseLocalTimestampMicros(type, data);
                }
            }
        }
        switch (type.avroType) {
            case INT: {
                return DatatypeConverter.parseInt((String)data);
            }
            case STRING: 
            case KEY: {
                String str = (String)schema.getObjectProp("avro.java.string");
                if (str != null && str.equals("String")) {
                    return data;
                }
                Utf8 utf8 = new Utf8();
                utf8.set(data);
                return utf8;
            }
            case FIXED: {
                byte[] b = DatatypeConverter.parseBase64Binary((String)data);
                return new GenericData.Fixed(schema, b);
            }
            case ENUM: {
                return new GenericData.EnumSymbol(schema, data);
            }
            case LONG: {
                return DatatypeConverter.parseLong((String)data);
            }
            case BYTES: {
                byte[] b = DatatypeConverter.parseBase64Binary((String)data);
                return ByteBuffer.wrap(b);
            }
            case FLOAT: {
                return Float.valueOf(DatatypeConverter.parseFloat((String)data));
            }
            case BOOLEAN: {
                return DatatypeConverter.parseBoolean((String)data);
            }
            case DOUBLE: {
                return DatatypeConverter.parseDouble((String)data);
            }
        }
        return null;
    }

    private String parseUuid(InternalType type, String data) {
        if (type.avroType != AvroType.STRING) {
            throw new RuntimeException("uuid can't be converted to: " + String.valueOf((Object)type.avroType));
        }
        return DatatypeConverter.printString((String)data);
    }

    private Object parseLocalTimestampMicros(InternalType type, String data) {
        if (type.avroType != AvroType.LONG) {
            throw new RuntimeException("localtimestamp-micros can't be converted to: " + String.valueOf((Object)type.avroType));
        }
        return FormatHandler.toLocalTimestampMicros(data);
    }

    private Object parseLocalTimestampMillis(InternalType type, String data) {
        if (type.avroType != AvroType.LONG) {
            throw new RuntimeException("localtimestamp-millis can't be converted to: " + String.valueOf((Object)type.avroType));
        }
        return FormatHandler.toLocalTimestampMillis(data);
    }

    private Object parseTimestampMicros(InternalType type, String data) {
        if (type.avroType != AvroType.LONG) {
            throw new RuntimeException("timestamp-micros can't be converted to: " + String.valueOf((Object)type.avroType));
        }
        return FormatHandler.toTimestampMicros(data);
    }

    private Object parseTimeMicros(InternalType type, String data) {
        if (type.avroType != AvroType.LONG) {
            throw new RuntimeException("time-micros can't be converted to: " + String.valueOf((Object)type.avroType));
        }
        return FormatHandler.toTimeMicros(data);
    }

    private Object parseDecimal(InternalType type, String data) {
        if (type.avroType != AvroType.BYTES) {
            throw new RuntimeException("decimal can't be converted to: " + String.valueOf((Object)type.avroType));
        }
        BigDecimal bd = DatatypeConverter.parseDecimal((String)data);
        if (bd.scale() > type.scale) {
            throw new RuntimeException("Error scale: " + bd.scale() + " > " + type.scale);
        }
        if (bd.precision() > type.precision) {
            throw new RuntimeException("Error precision: " + bd.precision() + " > " + type.precision);
        }
        bd = bd.movePointRight(type.scale);
        byte[] b = bd.toBigInteger().toByteArray();
        return ByteBuffer.wrap(b);
    }

    private Object parseDate(InternalType type, String data) {
        if (type.avroType != AvroType.INT) {
            throw new RuntimeException("date can't be converted to: " + String.valueOf((Object)type.avroType));
        }
        return FormatHandler.toEpochDays(data);
    }

    private Object parseTimeMillis(InternalType type, String data) {
        if (type.avroType != AvroType.INT) {
            throw new RuntimeException("time-millis can't be converted to: " + String.valueOf((Object)type.avroType));
        }
        return FormatHandler.toTimeMillis(data);
    }

    private Object parseTimestampMillis(InternalType type, String data) {
        if (type.avroType != AvroType.LONG) {
            throw new RuntimeException("timestamp-millis can't be converted to: " + String.valueOf((Object)type.avroType));
        }
        return FormatHandler.toTimestampMillis(data);
    }

    public Object parseData(int _type, String data) {
        if (data != null) {
            InternalType type = this.getInternalType(_type);
            return this.parseData(type, data, null);
        }
        return null;
    }

    public boolean isArrayType(int type) {
        return this.getInternalType(type).isArray();
    }

    public boolean isDataType(int type) {
        return this.getInternalType(type).isData();
    }

    public int getTypeCode(AvroType enum1) {
        return this.getInternalType(enum1).getTypeCode();
    }

    public InternalType getInternalType(Schema.Type type2, Map<String, Object> props) {
        String logicalType = (String)props.get("logicalType");
        if (logicalType != null) {
            String t = type2.getName().toLowerCase() + "_" + logicalType.replace("-", "");
            if (logicalType.equals("decimal")) {
                Integer precision = (Integer)props.get("precision");
                Integer scale = (Integer)props.get("scale");
                return this.getInternalType(t + "_" + String.valueOf(precision) + "_" + String.valueOf(scale));
            }
            return this.getInternalType(t);
        }
        return this.getInternalType(type2.getName().toLowerCase());
    }

    public InternalType getInternalType(Schema.Type _type) {
        AvroType type = AvroType.valueOf(_type.getName().toUpperCase());
        return this.getInternalType(type);
    }

    public InternalType getInternalType(Object node) {
        AvroType type = null;
        if (node instanceof GenericData.Array) {
            type = AvroType.ARRAY;
        } else if (node instanceof Map) {
            type = AvroType.MAP;
        } else if (node instanceof GenericRecord) {
            type = AvroType.RECORD;
        } else if (node instanceof GenericData.Fixed) {
            type = AvroType.FIXED;
        } else if (node instanceof GenericData.EnumSymbol) {
            type = AvroType.ENUM;
        } else if (node instanceof Integer) {
            type = AvroType.INT;
        } else if (node instanceof Long) {
            type = AvroType.LONG;
        } else if (node instanceof byte[] || node instanceof ByteBuffer) {
            type = AvroType.BYTES;
        } else if (node instanceof Boolean) {
            type = AvroType.BOOLEAN;
        } else if (node instanceof Double) {
            type = AvroType.DOUBLE;
        } else if (node instanceof Float) {
            type = AvroType.FLOAT;
        } else if (node instanceof String) {
            type = AvroType.STRING;
        } else if (node instanceof Utf8) {
            type = AvroType.STRING;
        } else {
            throw new RuntimeException("Error impossible to determine type of: " + String.valueOf(node));
        }
        return this.getInternalType(type);
    }

    public static enum AvroLogicalType {
        TIMESTAMPMILLIS(1),
        DATE(2),
        TIMEMILLIS(3),
        DECIMAL(6),
        LOCALTIMESTAMPMILLIS(1),
        TIMEMICROS(3),
        TIMESTAMPMICROS(1),
        UUID(11),
        LOCALTIMESTAMPMICROS(1);

        int XMLDataType = -1;

        private AvroLogicalType(int datetimetype) {
            this.XMLDataType = datetimetype;
        }
    }

    public static enum AvroType {
        RECORD(true, false, Schema.Type.RECORD),
        ARRAY(true, true, Schema.Type.ARRAY),
        MAP(true, true, Schema.Type.MAP),
        ENUM(Schema.Type.ENUM, 11),
        FIXED(Schema.Type.FIXED, 7),
        STRING(Schema.Type.STRING, 11),
        LONG(Schema.Type.LONG, 5),
        DOUBLE(Schema.Type.DOUBLE, 5),
        FLOAT(Schema.Type.FLOAT, 10),
        INT(Schema.Type.INT, 13),
        BOOLEAN(Schema.Type.BOOLEAN, 4),
        BYTES(Schema.Type.BYTES, 7),
        KEY(true, false, null, 11),
        INDEX(true, false, null, 11),
        FIELD(true, false, null),
        NULL(false, false, Schema.Type.NULL);

        boolean isContainer;
        boolean isArray;
        boolean isData;
        String name;
        Schema.Type realType;
        int XMLDataType = -1;
        static Map<String, AvroType> logicals;

        static {
            logicals = Collections.synchronizedMap(new HashMap());
        }

        public Schema.Type getRealType() {
            return this.realType;
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        public String getName() {
            return this.name;
        }

        private AvroType(boolean isContainer, boolean isArray, Schema.Type realType, int XMLDataType) {
            this.isContainer = isContainer;
            this.isArray = isArray;
            this.isData = XMLDataType != -1 || realType != null && realType == Schema.Type.NULL;
            this.name = this.name().toLowerCase();
            this.realType = realType;
            this.XMLDataType = XMLDataType;
        }

        private AvroType(boolean isContainer, boolean isArray, Schema.Type realType) {
            this(isContainer, isArray, realType, -1);
        }

        private AvroType() {
            this(false, false, null);
        }

        private AvroType(Schema.Type realType) {
            this(false, false, realType);
        }

        private AvroType(Schema.Type realType, int XMLDataType) {
            this(false, false, realType, XMLDataType);
        }
    }

    public static class InternalType {
        public AvroType avroType;
        public int avroCode;
        public String avroName;
        public AvroLogicalType logicalType;
        public int scale;
        public int precision;
        public boolean javaString;

        public String getName() {
            return this.avroName;
        }

        public int getTypeCode() {
            return this.avroCode;
        }

        public int getXmlDataType() {
            if (this.logicalType != null) {
                return this.logicalType.XMLDataType;
            }
            return this.avroType.XMLDataType;
        }

        public boolean isContainer() {
            return this.avroType.isContainer;
        }

        public Schema.Type getRealType() {
            return this.avroType.getRealType();
        }

        public boolean isArray() {
            return this.avroType.isArray;
        }

        public boolean isData() {
            return this.avroType.isData;
        }
    }
}

