/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.avro.writer;

import com.indy.runtime.hierarchy.HierarchyEvent;
import com.indy.runtime.hierarchy.HierarchyEventWriter;
import com.stambia.avro.writer.AvroHierarchyEventsToGenericRecord;
import com.stambia.avro.writer.Messages;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;

public class AvroHierarchyEventWriter
extends HierarchyEventWriter {
    private AvroHierarchyEventsToGenericRecord recordWriter;
    RecordAppender appender;
    int proof;
    List<HierarchyEvent> buffer = new ArrayList<HierarchyEvent>();

    public AvroHierarchyEventWriter(Schema schema, OutputStream os) throws IOException {
        this(schema);
        GenericDatumWriter dw = new GenericDatumWriter(schema);
        final DataFileWriter fileWriter = new DataFileWriter((DatumWriter)dw);
        fileWriter.create(schema, (OutputStream)new BufferedOutputStream(os));
        this.appender = new RecordAppender(){

            @Override
            public void append(GenericRecord record) throws IOException {
                try {
                    fileWriter.append((Object)record);
                }
                catch (Exception e) {
                    throw new IOException(Messages.getString("AvroHierarchyEventWriter.0") + String.valueOf(record), e);
                }
            }

            @Override
            public void end() throws IOException {
                fileWriter.close();
            }
        };
    }

    public AvroHierarchyEventWriter(Schema schema) throws IOException {
        this.recordWriter = new AvroHierarchyEventsToGenericRecord(schema);
        this.appender = null;
    }

    public AvroHierarchyEventWriter(Schema schema, RecordAppender handler) throws IOException {
        this(schema);
        this.recordWriter = new AvroHierarchyEventsToGenericRecord(schema);
        this.appender = handler;
    }

    public final void handle(HierarchyEvent event) throws Exception {
        if (!event.isStartDocumentEvent() && !event.isEndDocumentEvent()) {
            this.buffer.add(event);
            if (event.isStartElementEvent()) {
                ++this.proof;
            } else if (event.isEndElementEvent()) {
                --this.proof;
                if (this.proof == 0) {
                    this.writeBuffer();
                }
            }
        }
    }

    private void writeBuffer() throws IOException {
        if (this.buffer.size() > 0) {
            GenericRecord record = this.recordWriter.createRecord(this.buffer);
            try {
                this.handleRecord(record);
            }
            catch (Exception e) {
                throw new IOException(Messages.getString("AvroHierarchyEventWriter.1") + String.valueOf(record), e);
            }
            this.buffer.clear();
        }
    }

    public void handleRecord(GenericRecord record) throws IOException {
        if (this.appender != null) {
            this.appender.append(record);
        }
    }

    public final void close() throws Exception {
        if (this.appender != null) {
            this.appender.end();
        }
    }

    private static interface RecordAppender {
        public void append(GenericRecord var1) throws IOException;

        public void end() throws IOException;
    }
}

