/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.avro.writer;

import com.indy.runtime.hierarchy.HierarchyEvent;
import com.indy.runtime.hierarchy.event.StartElementEvent;
import com.stambia.avro.reader.visitor.AvroVisitorHandler;
import com.stambia.avro.reader.visitor.AvroXMLConverter;
import com.stambia.avro.writer.Messages;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AvroHierarchyEventsToGenericRecord {
    private final Logger logger = LogManager.getLogger(this.getClass());
    Schema rootSchema;

    public AvroHierarchyEventsToGenericRecord(Schema rootSchema) {
        this.rootSchema = rootSchema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GenericRecord createRecord(List<HierarchyEvent> list) throws IOException {
        AvroXMLConverter converter = AvroXMLConverter.INSTANCE;
        ContainerWrapper current = null;
        for (HierarchyEvent hierarchyEvent : list) {
            if (hierarchyEvent.isStartElementEvent()) {
                if (current == null) {
                    Schema recordSchema;
                    current = new ContainerWrapper(converter.getInternalType(AvroXMLConverter.AvroType.RECORD), null);
                    if (this.rootSchema.getType() == Schema.Type.UNION) {
                        List types = this.rootSchema.getTypes();
                        recordSchema = AvroVisitorHandler.findSchemaByName(types, ((StartElementEvent)hierarchyEvent).name.substring(4));
                    } else {
                        recordSchema = this.rootSchema;
                    }
                    current.record = new GenericData.Record(recordSchema);
                    current.setNamespace(recordSchema);
                    continue;
                }
                StartElementEvent startEvent = (StartElementEvent)hierarchyEvent;
                AvroXMLConverter.InternalType type = null;
                Object fullName = null;
                if (current.type.avroType == AvroXMLConverter.AvroType.RECORD) {
                    type = converter.getInternalType(AvroXMLConverter.AvroType.FIELD);
                } else if (startEvent.name.equals("array")) {
                    type = converter.getInternalType(AvroXMLConverter.AvroType.ARRAY);
                } else if (startEvent.name.equals("map")) {
                    type = converter.getInternalType(AvroXMLConverter.AvroType.MAP);
                } else if (startEvent.name.equals("key")) {
                    type = converter.getInternalType(AvroXMLConverter.AvroType.KEY);
                } else if (startEvent.name.startsWith("enu_")) {
                    type = converter.getInternalType(AvroXMLConverter.AvroType.ENUM);
                    fullName = startEvent.name.substring(4);
                } else if (startEvent.name.startsWith("fix_")) {
                    type = converter.getInternalType(AvroXMLConverter.AvroType.FIXED);
                    fullName = startEvent.name.substring(4);
                } else if (startEvent.name.startsWith("rec_")) {
                    type = converter.getInternalType(AvroXMLConverter.AvroType.RECORD);
                    fullName = startEvent.name.substring(4);
                } else if (startEvent.name.startsWith("index")) {
                    type = converter.getInternalType(AvroXMLConverter.AvroType.INDEX);
                } else {
                    if (startEvent.getType() == Integer.MIN_VALUE) throw new IOException(String.format(Messages.getString("AvroHierarchyEventsToGenericRecord.2"), startEvent.name));
                    type = converter.getInternalType(startEvent.getType());
                }
                ContainerWrapper parentContainerWrapper = current;
                if (!parentContainerWrapper.type.isContainer()) {
                    throw new IOException(String.format(Messages.getString("AvroHierarchyEventsToGenericRecord.3"), parentContainerWrapper.type));
                }
                current = new ContainerWrapper(type, parentContainerWrapper);
                Schema _schema = parentContainerWrapper.getSchema();
                if (type.avroType == AvroXMLConverter.AvroType.INDEX) {
                    current.setNamespace(_schema);
                    current.array = parentContainerWrapper.array;
                    continue;
                }
                if (fullName != null && !((String)fullName).contains(".") && parentContainerWrapper.namespace != null) {
                    fullName = parentContainerWrapper.namespace + "." + (String)fullName;
                }
                Schema rawSchema = null;
                if (!AvroXMLConverter.AvroType.NULL.equals((Object)type.avroType) && _schema.getType() == Schema.Type.UNION) {
                    List types = _schema.getTypes();
                    if (type.avroType == AvroXMLConverter.AvroType.RECORD || type.avroType == AvroXMLConverter.AvroType.ENUM || type.avroType == AvroXMLConverter.AvroType.FIXED) {
                        rawSchema = AvroVisitorHandler.findSchemaByName(types, (String)fullName);
                    } else {
                        if (type == null) throw new IOException(String.format(Messages.getString("AvroHierarchyEventsToGenericRecord.4"), type));
                        rawSchema = AvroVisitorHandler.findSchemaByType(types, type.getRealType());
                    }
                } else {
                    rawSchema = _schema;
                    String schemaFullName = rawSchema.getFullName();
                    if (!(type.avroType != AvroXMLConverter.AvroType.RECORD && type.avroType != AvroXMLConverter.AvroType.ENUM && type.avroType != AvroXMLConverter.AvroType.FIXED || schemaFullName.equals(fullName))) {
                        throw new IOException(String.format(Messages.getString("AvroHierarchyEventsToGenericRecord.5"), fullName, schemaFullName));
                    }
                }
                current.setNamespace(rawSchema);
                if (type.avroType == AvroXMLConverter.AvroType.ARRAY) {
                    current.array = new GenericData.Array(0, rawSchema);
                    parentContainerWrapper.add(current.array);
                    continue;
                }
                if (type.avroType == AvroXMLConverter.AvroType.MAP) {
                    current.map = new HashMap<String, Object>();
                    current.mapSchema = rawSchema;
                    parentContainerWrapper.add(current.map);
                    continue;
                }
                if (type.avroType == AvroXMLConverter.AvroType.RECORD) {
                    current.record = new GenericData.Record(rawSchema);
                    parentContainerWrapper.add(current.record);
                    continue;
                }
                if (type.avroType == AvroXMLConverter.AvroType.KEY) {
                    current.key = startEvent.getStringData();
                    continue;
                }
                if (type.avroType == AvroXMLConverter.AvroType.FIELD) {
                    current.field = rawSchema.getField(startEvent.name);
                    if (current.field != null) continue;
                    parentContainerWrapper.getSchema();
                    throw new IOException(Messages.getString("AvroHierarchyEventsToGenericRecord.6"));
                }
                if (!hierarchyEvent.isStartDataElementEvent()) throw new IOException(Messages.getString("AvroHierarchyEventsToGenericRecord.7"));
                if (startEvent.isNull()) {
                    parentContainerWrapper.add(null);
                    continue;
                }
                Object data = null;
                data = startEvent.getData() != null ? startEvent.getData() : AvroXMLConverter.INSTANCE.parseData(type, startEvent.getStringData(), rawSchema);
                parentContainerWrapper.add(data);
                continue;
            }
            if (!hierarchyEvent.isEndElementEvent() || current.parent == null) continue;
            current = current.parent;
        }
        current.record = this.setDefaultValues(current.record);
        return current.record;
    }

    private GenericData.Record setDefaultValues(GenericData.Record record) {
        List schemaFields;
        Schema schema;
        if (record != null && (schema = record.getSchema()) != null && (schemaFields = schema.getFields()) != null) {
            int fieldsNumber = schemaFields.size();
            int fieldIndex = 0;
            while (fieldIndex < fieldsNumber) {
                Schema.Field field = (Schema.Field)schemaFields.get(fieldIndex);
                if (field != null) {
                    Object defaultValue = field.defaultVal();
                    Object currentValue = record.get(fieldIndex);
                    if (defaultValue != null && currentValue == null) {
                        record.put(fieldIndex, defaultValue);
                    }
                }
                ++fieldIndex;
            }
        }
        return record;
    }

    class ContainerWrapper {
        AvroXMLConverter.InternalType type;
        ContainerWrapper parent;
        GenericData.Record record;
        Schema.Field field;
        GenericData.Array<Object> array;
        Map<String, Object> map;
        Schema mapSchema;
        String key;
        String namespace;

        public ContainerWrapper(AvroXMLConverter.InternalType type, ContainerWrapper parent) {
            this.type = type;
            this.parent = parent;
        }

        void setNamespace(Schema rawSchema) {
            String schemaNamespace = null;
            try {
                schemaNamespace = rawSchema.getNamespace();
            }
            catch (Exception e) {
                AvroHierarchyEventsToGenericRecord.this.logger.debug("Cannot get namespace from schema", (Throwable)e);
            }
            if (schemaNamespace != null) {
                this.namespace = schemaNamespace;
            } else if (this.parent != null) {
                this.namespace = this.parent.namespace;
            }
        }

        Schema getSchema() throws IOException {
            if (this.field != null) {
                return this.field.schema();
            }
            if (this.record != null) {
                return this.record.getSchema();
            }
            if (this.array != null) {
                return this.array.getSchema().getElementType();
            }
            if (this.map != null) {
                return this.mapSchema;
            }
            if (this.key != null) {
                return this.parent.mapSchema.getValueType();
            }
            throw new IOException(Messages.getString("AvroHierarchyEventsToGenericRecord.0"));
        }

        public void add(Object data) throws IOException {
            if (this.field != null) {
                Object o = this.parent.record.get(this.field.name());
                if (o == null) {
                    this.parent.record.put(this.field.name(), data);
                }
            } else if (this.array != null) {
                this.array.add(data);
            } else if (this.key != null) {
                this.parent.map.put(this.key, data);
                this.key = null;
            } else {
                throw new IOException(Messages.getString("AvroHierarchyEventsToGenericRecord.1"));
            }
        }
    }
}

