/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.externalvalueresolver.amazon;

import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

public class AmazonSecretsManagerExternalValueResolverInternalPlugin
implements IExternalValueResolverPlugin {
    public static final String AWS_REGION = "awsRegion";
    private String awsRegion;
    private SecretsManagerClient client;

    public void init(IPluginFactory.IPluginConfiguration cnf) throws Exception {
        this.awsRegion = cnf.getProperty(AWS_REGION);
        if (this.awsRegion == null) {
            throw new Exception("amazon web services's region can't be null");
        }
        Region region = Region.of((String)this.awsRegion);
        this.client = (SecretsManagerClient)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(region)).build();
    }

    public IExternalValueResolverPlugin.Value getvalue(String secretId, IExternalValueResolverPlugin.SecurityLevel type) {
        IExternalValueResolverPlugin.Value value = new IExternalValueResolverPlugin.Value();
        if (type == IExternalValueResolverPlugin.SecurityLevel.level1) {
            value.errorMessage = String.format("The key %s is not allowed to be evaluated in \"level1\" security level, which is required in this context.", secretId);
            return value;
        }
        try {
            GetSecretValueRequest valueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretId).build();
            GetSecretValueResponse valueResponse = this.client.getSecretValue(valueRequest);
            value.data = valueResponse.secretString() != null ? valueResponse.secretString().getBytes(StandardCharsets.UTF_8) : valueResponse.secretBinary().toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (SecretsManagerException e) {
            value.errorMessage = String.format("secret %s not found", secretId);
        }
        return value;
    }

    protected AmazonSecretsManagerExternalValueResolverInternalPlugin() {
    }
}

