/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.externalvalueresolver.google;

import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.nio.charset.StandardCharsets;

public class GoogleCloudSecretManagerExternalValueResolverInternalPlugin
implements IExternalValueResolverPlugin {
    public static final String PROJECT_ID = "projectId";
    private String projectId;
    private SecretManagerServiceClient client;

    public void init(IPluginFactory.IPluginConfiguration cnf) throws Exception {
        this.projectId = cnf.getProperty(PROJECT_ID);
        if (this.projectId == null) {
            throw new Exception("google's projectId can't be null");
        }
        this.client = SecretManagerServiceClient.create();
    }

    public IExternalValueResolverPlugin.Value getvalue(String secretId, IExternalValueResolverPlugin.SecurityLevel type) {
        IExternalValueResolverPlugin.Value value = new IExternalValueResolverPlugin.Value();
        if (type == IExternalValueResolverPlugin.SecurityLevel.level1) {
            value.errorMessage = String.format("The key %s is not allowed to be evaluated in \"level1\" security level, which is required in this context.", secretId);
            return value;
        }
        SecretVersionName name = SecretVersionName.of((String)this.projectId, (String)secretId, (String)"latest");
        try {
            String stringData = this.client.accessSecretVersion(name).getPayload().getData().toStringUtf8();
            value.data = stringData.getBytes(StandardCharsets.UTF_8);
        }
        catch (NotFoundException e) {
            value.errorMessage = String.format("secret %s not found", secretId);
        }
        return value;
    }

    protected GoogleCloudSecretManagerExternalValueResolverInternalPlugin() {
    }
}

