/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.externalvalueresolver.vault;

import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.vault.authentication.AppRoleAuthentication;
import org.springframework.vault.authentication.AppRoleAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.client.VaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.config.AbstractVaultConfiguration;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class AppRoleAuthenticationService
extends AbstractVaultConfiguration {
    private String roleId;
    private String secretId;
    private String host;
    private String scheme;
    private String port;
    private String namespace;
    RestTemplate restTemplate;

    public AppRoleAuthenticationService(RestTemplate restTemplate, String roleId, String secretId, String host, String scheme, String port, String namespace) {
        this.roleId = roleId;
        this.secretId = secretId;
        this.host = host;
        this.scheme = scheme;
        this.port = port;
        this.restTemplate = restTemplate;
        this.namespace = namespace;
    }

    public VaultEndpoint vaultEndpoint() {
        int portInt = Integer.parseInt(this.port);
        VaultEndpoint ep = VaultEndpoint.create((String)this.host, (int)portInt);
        if (this.scheme != null) {
            ep.setScheme(this.scheme);
        }
        return ep;
    }

    public RestOperations restOperations() {
        RestTemplate restTemplate = VaultClients.createRestTemplate((VaultEndpointProvider)this.vaultEndpointProvider(), (ClientHttpRequestFactory)this.clientHttpRequestFactoryWrapper().getClientHttpRequestFactory());
        if (this.namespace != null) {
            restTemplate.getInterceptors().add((request, body, execution) -> {
                request.getHeaders().add("X-Vault-Namespace", this.namespace);
                return execution.execute(request, body);
            });
        }
        return restTemplate;
    }

    public ClientAuthentication clientAuthentication() {
        AppRoleAuthenticationOptions options = AppRoleAuthenticationOptions.builder().roleId(AppRoleAuthenticationOptions.RoleId.provided((String)this.roleId)).secretId(AppRoleAuthenticationOptions.SecretId.provided((String)this.secretId)).build();
        return new AppRoleAuthentication(options, this.restOperations());
    }

    public ThreadPoolTaskScheduler getTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(1);
        scheduler.setWaitForTasksToCompleteOnShutdown(false);
        scheduler.initialize();
        return scheduler;
    }
}

