/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.graphql.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.client.ClientGraphQlResponse;
import org.springframework.graphql.client.GraphQlClient;
import reactor.core.publisher.Mono;

public final class GraphQlIntegrator {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String OUTPUT_OPEN_STRING = "[{\"response\":{\"root\":";
    public static final String OUTPUT_CLOSE_STRING = "}}]";
    private static final byte[] OUTPUT_OPEN_BYTE = "[{\"response\":{\"root\":".getBytes();
    private static final byte[] OUTPUT_CLOSE_BYTE = "}}]".getBytes();
    private final OutputStream outputStream;
    private final GraphQlClient graphQlClient;
    private final String operation;
    private final int partialResponseToleratedErrorsNumber;

    public GraphQlIntegrator(OutputStream outputStream, GraphQlClient graphQlClient, String operation, int partialResponseToleratedErrorsNumber) {
        this.outputStream = outputStream;
        this.graphQlClient = graphQlClient;
        this.operation = operation;
        this.partialResponseToleratedErrorsNumber = partialResponseToleratedErrorsNumber;
    }

    public final void integrate() throws SQLException, IOException {
        Mono call = this.graphQlClient.document(this.operation).execute();
        ClientGraphQlResponse response = (ClientGraphQlResponse)call.block();
        List errors = response.getErrors();
        GraphQlIntegrator.cleanErrors(errors);
        int errorsCount = errors.size();
        if (this.partialResponseToleratedErrorsNumber >= 0 && this.partialResponseToleratedErrorsNumber < errorsCount) {
            throw GraphQlIntegrator.toSQLException(errors);
        }
        String jsonResponse = OBJECT_MAPPER.writeValueAsString((Object)response);
        this.outputStream.write(OUTPUT_OPEN_BYTE);
        this.outputStream.write(jsonResponse.getBytes());
        this.outputStream.write(OUTPUT_CLOSE_BYTE);
    }

    private static void cleanErrors(List<ResponseError> errors) {
        for (ResponseError error : errors) {
            error.getExtensions().clear();
        }
    }

    private static SQLException toSQLException(List<ResponseError> errors) throws JsonProcessingException {
        ResponseError firstError = errors.get(0);
        String reason = firstError.getMessage();
        String message = OBJECT_MAPPER.writeValueAsString((Object)firstError);
        Throwable cause = new Throwable(message);
        SQLException firstException = new SQLException(reason, cause);
        if (errors.size() > 1) {
            List<ResponseError> nextErrors = errors.subList(1, errors.size());
            SQLException nextException = GraphQlIntegrator.toSQLException(nextErrors);
            firstException.setNextException(nextException);
        }
        return firstException;
    }
}

