/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.graphql.runtime;

import com.indy.engine.common.tools.OutputStreamTransformer;
import com.semarchy.xdi.component.graphql.runtime.GraphQlIntegrator;
import com.semarchy.xdi.component.graphql.runtime.connection.GraphQlConnection;
import com.semarchy.xdi.component.graphql.runtime.connection.Security;
import com.semarchy.xdi.component.graphql.runtime.connection.SslStore;
import com.semarchy.xdi.component.graphql.runtime.connection.TimeoutMs;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.graphql.client.GraphQlClient;

public final class GraphQlTransformer
extends OutputStreamTransformer {
    static final String ENDPOINT_URL_PROPERTY = "endpointUrl";
    private static final String JWT_PROPERTY = "com.stambia.security.bearerToken.bearerToken";
    private static final String KEY_STORE_FILEPATH_PROPERTY = "keystore.filepath";
    private static final String KEY_STORE_TYPE_PROPERTY = "keystore.type";
    private static final String KEY_STORE_PASSWORD_PROPERTY = "keystore.password";
    private static final String TRUST_STORE_FILEPATH_PROPERTY = "truststore.filepath";
    private static final String TRUST_STORE_TYPE_PROPERTY = "truststore.type";
    private static final String TRUST_STORE_PASSWORD_PROPERTY = "truststore.password";
    private static final String ENABLE_CERTIFICATE_VALIDATION_PROPERTY = "enableCertificateValidation";
    private static final String CONNECT_TIMEOUT_PROPERTY = "timeout.connect";
    private static final String READ_TIMEOUT_PROPERTY = "timeout.read";
    private static final String RESPONSE_TIMEOUT_PROPERTY = "timeout.response";
    private static final String WRITE_TIMEOUT_PROPERTY = "timeout.write";
    static final String OPERATION_PROPERTY = "operation";
    private static final String PARTIAL_RESPONSE_TOLERATED_ERRORS_NUMBER = "partialResponseToleratedErrorsNumber";
    private static final String GRAPHQL_OPERATION_STATISTIC = "GRAPHQL_OPERATION";

    public final void transform(InputStream inputStream, OutputStream outputStream) throws Exception {
        String endpointUrl = this.getProperty(ENDPOINT_URL_PROPERTY);
        String jsonWebToken = this.getProperty(JWT_PROPERTY);
        String keyStoreFilepath = this.getProperty(KEY_STORE_FILEPATH_PROPERTY);
        String keyStoreType = this.getProperty(KEY_STORE_TYPE_PROPERTY);
        String keyStorePassword = this.getProperty(KEY_STORE_PASSWORD_PROPERTY);
        String trustStoreFilepath = this.getProperty(TRUST_STORE_FILEPATH_PROPERTY);
        String trustStoreType = this.getProperty(TRUST_STORE_TYPE_PROPERTY);
        String trustStorePassword = this.getProperty(TRUST_STORE_PASSWORD_PROPERTY);
        String rawEnableCertificateValidation = this.getProperty(ENABLE_CERTIFICATE_VALIDATION_PROPERTY);
        boolean enableCertificateValidation = rawEnableCertificateValidation != null && !rawEnableCertificateValidation.isBlank() && Boolean.parseBoolean(rawEnableCertificateValidation);
        String rawConnectTimeout = this.getProperty(CONNECT_TIMEOUT_PROPERTY);
        int connectTimeout = rawConnectTimeout != null && !rawConnectTimeout.isBlank() ? Integer.valueOf(rawConnectTimeout) : 0;
        String rawReadTimeout = this.getProperty(READ_TIMEOUT_PROPERTY);
        int readTimeout = rawReadTimeout != null && !rawReadTimeout.isBlank() ? Integer.valueOf(rawReadTimeout) : 0;
        String rawResponseTimeout = this.getProperty(RESPONSE_TIMEOUT_PROPERTY);
        int responseTimeout = rawResponseTimeout != null && !rawResponseTimeout.isBlank() ? Integer.valueOf(rawResponseTimeout) : 0;
        String rawWriteTimeout = this.getProperty(WRITE_TIMEOUT_PROPERTY);
        int writeTimeout = rawWriteTimeout != null && !rawWriteTimeout.isBlank() ? Integer.valueOf(rawWriteTimeout) : 0;
        String operation = this.getProperty(OPERATION_PROPERTY);
        String rawPartialResponseToleratedErrorsNumber = this.getProperty(PARTIAL_RESPONSE_TOLERATED_ERRORS_NUMBER);
        int partialResponseToleratedErrorsNumber = rawPartialResponseToleratedErrorsNumber != null && !rawPartialResponseToleratedErrorsNumber.isBlank() ? Integer.valueOf(rawPartialResponseToleratedErrorsNumber) : 0;
        TimeoutMs timeoutMs = new TimeoutMs(connectTimeout, responseTimeout, readTimeout, writeTimeout);
        SslStore trustStore = new SslStore(trustStoreFilepath, trustStoreType, trustStorePassword);
        SslStore keyStore = new SslStore(keyStoreFilepath, keyStoreType, keyStorePassword);
        Security security = new Security(jsonWebToken, trustStore, keyStore, enableCertificateValidation);
        GraphQlConnection graphQlConnection = new GraphQlConnection(endpointUrl, timeoutMs, security);
        GraphQlClient client = graphQlConnection.client();
        GraphQlIntegrator graphQlIntegrator = new GraphQlIntegrator(outputStream, client, operation, partialResponseToleratedErrorsNumber);
        graphQlIntegrator.integrate();
        OutputStreamTransformer.OutputStreamTransformerStatisticHandler statHandler = this.getStatisticHandler();
        if (statHandler != null) {
            statHandler.handle(GRAPHQL_OPERATION_STATISTIC, 1L);
        }
    }
}

