/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.graphql.runtime.connection;

import com.semarchy.xdi.component.graphql.runtime.connection.Security;
import com.semarchy.xdi.component.graphql.runtime.connection.SslStore;
import com.semarchy.xdi.component.graphql.runtime.connection.TimeoutMs;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;

public final class HttpConnection {
    private static final String TRUSTSTORE_ALGORITHM = TrustManagerFactory.getDefaultAlgorithm();
    private static final String KEYSTORE_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    private final WebClient webClient;

    public HttpConnection(String endpointUrl, TimeoutMs timeoutMs, Security security) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        Objects.requireNonNull(endpointUrl, "endpointUrl cannot be null");
        Objects.requireNonNull(timeoutMs, "timeoutMs cannot be null");
        Objects.requireNonNull(security, "security cannot be null");
        HttpClient httpClient = (HttpClient)((HttpClient)HttpClient.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMs.connect())).responseTimeout(Duration.ofMillis(timeoutMs.response())).doOnConnected(connection -> {
            Connection connection2 = connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)timeoutMs.read(), TimeUnit.MILLISECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler((long)timeoutMs.write(), TimeUnit.MILLISECONDS));
        });
        boolean isHttps = endpointUrl.toLowerCase().startsWith("https://");
        if (isHttps) {
            httpClient = HttpConnection.sslContext(security, httpClient);
        }
        WebClient.Builder webClientBuilder = WebClient.builder().baseUrl(endpointUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        String bearerToken = security.bearerToken();
        if (bearerToken != null && !bearerToken.isBlank()) {
            webClientBuilder = webClientBuilder.defaultHeader("Authorization", new String[]{"Bearer " + bearerToken});
        }
        this.webClient = webClientBuilder.build();
    }

    private static final HttpClient sslContext(Security security, HttpClient httpClient) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        SslContext sslContext;
        SslContextBuilder sslBuilder = SslContextBuilder.forClient();
        if (security.validateCertificates()) {
            sslBuilder = HttpConnection.trustStore(security.trustStore(), sslBuilder);
            sslBuilder = HttpConnection.keyStore(security.keyStore(), sslBuilder);
            sslContext = sslBuilder.build();
        } else {
            sslContext = sslBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        }
        httpClient = httpClient.secure(ssl -> {
            SslProvider.Builder builder = ssl.sslContext(sslContext);
        });
        return httpClient;
    }

    private static final SslContextBuilder trustStore(SslStore trustStoreInfo, SslContextBuilder sslBuilder) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String trustPathString;
        if (trustStoreInfo != null && (trustPathString = trustStoreInfo.path()) != null && !trustPathString.isBlank()) {
            KeyStore trustStore = HttpConnection.store(trustStoreInfo);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TRUSTSTORE_ALGORITHM);
            trustManagerFactory.init(trustStore);
            sslBuilder = sslBuilder.trustManager(trustManagerFactory);
        }
        return sslBuilder;
    }

    private static final SslContextBuilder keyStore(SslStore keyStoreInfo, SslContextBuilder sslBuilder) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        String keystorePathString;
        if (keyStoreInfo != null && (keystorePathString = keyStoreInfo.path()) != null && !keystorePathString.isBlank()) {
            KeyStore keyStore = HttpConnection.store(keyStoreInfo);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KEYSTORE_ALGORITHM);
            String keyStorePassword = keyStoreInfo.password();
            keyManagerFactory.init(keyStore, keyStorePassword != null ? keyStorePassword.toCharArray() : null);
            sslBuilder = sslBuilder.keyManager(keyManagerFactory);
        }
        return sslBuilder;
    }

    private static final KeyStore store(SslStore sslStore) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String pathString = sslStore.path();
        if (pathString == null) {
            throw new IllegalArgumentException("SSL store path cannot be null");
        }
        Path storePath = Path.of(pathString, new String[0]);
        if (!Files.exists(storePath, new LinkOption[0])) {
            throw new IllegalArgumentException("Store file does not exist: " + String.valueOf(storePath));
        }
        String storeType = sslStore.type();
        if (storeType == null) {
            storeType = KeyStore.getDefaultType();
        }
        KeyStore store = KeyStore.getInstance(storeType);
        String password = sslStore.password();
        char[] storePassword = password != null ? password.toCharArray() : null;
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStream inputStream = Files.newInputStream(storePath, new OpenOption[0]);){
            store.load(inputStream, storePassword);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return store;
    }

    public final WebClient client() {
        return this.webClient;
    }
}

