/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.common;

import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.common.Messages;

public enum Operator {
    INSERT,
    UPDATE,
    DELETE,
    GET,
    UPSERT,
    SEARCH;


    public static Operator fromString(String rawValue) throws ElasticSearchException {
        if (rawValue == null) {
            throw new ElasticSearchException(Messages.getString("UNKNOWN_OPERATOR"));
        }
        try {
            return Operator.valueOf(rawValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ElasticSearchException(Messages.getString(String.format("UNKNOWN_OPERATOR", rawValue)));
        }
    }

    public boolean isCrud() {
        return !SEARCH.equals((Object)this);
    }
}

