/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.integrator;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import com.semarchy.xdi.elasticsearch.common.Authentication;
import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.common.Operator;
import com.semarchy.xdi.elasticsearch.common.SslStore;
import com.semarchy.xdi.elasticsearch.factory.SpringDataContextFactory;
import com.semarchy.xdi.elasticsearch.json.JsonDocumentComposer;
import com.semarchy.xdi.elasticsearch.json.JsonDocumentInstanciator;
import com.semarchy.xdi.elasticsearch.json.JsonDocumentMerger;
import com.semarchy.xdi.elasticsearch.json.JsonSchemaParser;
import com.semarchy.xdi.elasticsearch.json.QueryParser;
import com.semarchy.xdi.elasticsearch.json.SpringDataKeyword;
import com.semarchy.xdi.elasticsearch.springdata.ElasticSearchConfiguration;
import com.semarchy.xdi.elasticsearch.springdata.SpringDataComponent;
import com.semarchy.xdi.elasticsearch.springdata.SpringDataDocumentModel;
import com.semarchy.xdi.elasticsearch.transformer.ElasticSearchOutputStreamTransformerV8;
import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import net.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.query.Query;

public class ElasticSearchOutputStreamIntegratorV8 {
    private static final byte[] ARRAY_OPEN_BYTES = "[".getBytes();
    private static final byte[] ARRAY_CLOSE_BYTES = "]".getBytes();
    private static final byte[] ELEMENT_SEPARATOR_BYTES = ",".getBytes();
    public static final String HITS_FIELD = "hits";
    private static final byte[] HITS_OPEN = ("{" + JsonDocumentComposer.enquote("hits") + ":" + "[").getBytes();
    private static final byte[] HITS_CLOSE = ("]" + "}").getBytes();
    private static final String CREATED_FIELD = "created";
    private static final String FOUND_FIELD = "found";
    private static final String INDEX_FIELD = "index";
    private static final String SCORE_FIELD = "score";
    protected static final String INSERT_STAT = "ESEARCH_INSERT";
    protected static final String UPDATE_STAT = "ESEARCH_UPDATE";
    protected static final String DELETE_STAT = "ESEARCH_DELETE";
    protected static final String GET_STAT = "ESEARCH_GET";
    protected static final String SEARCH_STAT = "ESEARCH_HIT";
    private List<String> indices;
    private String httpUrl;
    private SSLContext sslContext;
    private Authentication authentication;
    private Map<String, Long> statistics;
    private SpringDataContextFactory springDataContextFactory;
    private JsonParser jsonDataParser;
    private JsonSchemaParser jsonSchemaParser;
    private ElasticSearchConfiguration configuration;
    private JsonDocumentComposer jsonDocumentComposer;
    private OutputStream outputStream;
    private Field indexdField;
    private Field createdField;
    private Field foundField;
    private String index;
    private long searchCounter;
    private boolean firstLine;
    private static final TrustStrategy DISABLED_CERTIFICATE_VALIDATION = (arg0, arg1) -> true;

    public ElasticSearchOutputStreamIntegratorV8(String httpUrl, Authentication authentication, SslStore sslStore, String[] indices) throws ElasticSearchException {
        this.httpUrl = httpUrl;
        this.authentication = authentication;
        this.indices = Arrays.asList(indices);
        this.sslContext = ElasticSearchOutputStreamIntegratorV8.setSslContext(sslStore);
    }

    public static SSLContext setSslContext(SslStore sslStore) throws ElasticSearchException {
        SSLContextBuilder sslBuilder = null;
        SSLContext sslContext = null;
        try {
            if (sslStore != null) {
                TrustStrategy trustStrategy = sslStore.isCertificateValidationEnabled() ? null : DISABLED_CERTIFICATE_VALIDATION;
                SslStore.Store trustStoreParam = sslStore.getTrustStore();
                KeyStore trustStore = trustStoreParam.getStore();
                sslBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, trustStrategy);
                SslStore.Store keyStoreParams = sslStore.getKeyStore();
                KeyStore keyStore = keyStoreParams.getStore();
                String keyStorePass = keyStoreParams.getPassword();
                if (keyStorePass != null) {
                    sslBuilder = sslBuilder.loadKeyMaterial(keyStore, keyStorePass.toCharArray());
                }
            }
            sslContext = sslBuilder != null ? sslBuilder.build() : null;
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
        return sslContext;
    }

    public Map<String, Long> getStatistics() {
        return this.statistics;
    }

    public void integrateCrud(String rawJsonSchema, Operator operator, InputStream inputStream, OutputStream outputStream) throws ElasticSearchException {
        try {
            this.preIntegrate(rawJsonSchema, inputStream, outputStream);
            this.index = this.indices.get(0);
            Class<? extends SpringDataDocumentModel> documentClass = this.springDataContextFactory.getConcreteDocumentClass(this.index);
            JsonDocumentMerger jsonDocumentMerger = new JsonDocumentMerger(documentClass);
            List<SpringDataDocumentModel> inputDocuments = this.readInputJson(documentClass);
            SpringDataComponent<SpringDataDocumentModel> component = this.springDataContextFactory.getComponentInstance(this.index);
            Field idField = this.springDataContextFactory.getDocumentField(SpringDataKeyword.ID_FIELD);
            this.indexdField = this.springDataContextFactory.getDocumentField(INDEX_FIELD);
            this.createdField = this.springDataContextFactory.getDocumentField(CREATED_FIELD);
            this.foundField = this.springDataContextFactory.getDocumentField(FOUND_FIELD);
            switch (operator) {
                case INSERT: {
                    this.integrateCrudInsert(component, inputDocuments);
                    break;
                }
                case UPDATE: {
                    this.integrateCrudUpdate(component, inputDocuments, idField, jsonDocumentMerger);
                    break;
                }
                case DELETE: {
                    this.integrateCrudDelete(component, inputDocuments, idField);
                    break;
                }
                case GET: {
                    this.integrateCrudGet(component, inputDocuments, idField);
                    break;
                }
                case UPSERT: {
                    this.integrateCrudUpert(component, inputDocuments, idField, jsonDocumentMerger);
                }
            }
            this.finalizeIntegrate();
        }
        finally {
            this.postIntegrate();
        }
    }

    private List<SpringDataDocumentModel> readInputJson(Class<? extends SpringDataDocumentModel> documentClass) throws ElasticSearchException {
        JsonParser.Event event;
        ArrayList<SpringDataDocumentModel> inputDocuments = new ArrayList<SpringDataDocumentModel>();
        JsonParser.Event event2 = event = this.jsonDataParser.hasNext() ? this.jsonDataParser.next() : null;
        if (this.jsonDataParser.hasNext() && JsonParser.Event.START_ARRAY.equals((Object)event)) {
            try {
                Constructor<? extends SpringDataDocumentModel> documentConstructor = documentClass.getConstructor(new Class[0]);
                JsonDocumentInstanciator jsonDocumentInstanciator = new JsonDocumentInstanciator(documentConstructor, this.jsonSchemaParser);
                event = this.jsonDataParser.next();
                while (this.jsonDataParser.hasNext() && !JsonParser.Event.END_ARRAY.equals((Object)event)) {
                    SpringDataDocumentModel document = jsonDocumentInstanciator.instanciate(this.jsonDataParser, event);
                    inputDocuments.add(document);
                    event = this.jsonDataParser.next();
                }
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
        return inputDocuments;
    }

    private void integrateCrudInsert(SpringDataComponent<SpringDataDocumentModel> component, List<SpringDataDocumentModel> inputDocuments) throws ElasticSearchException {
        List<String> ids = component.insert(inputDocuments);
        long inputDocumentsNumber = inputDocuments.size();
        int documentIndex = 0;
        while ((long)documentIndex < inputDocumentsNumber) {
            SpringDataDocumentModel document = inputDocuments.get(documentIndex);
            String id = ids.get(documentIndex);
            document.setId(id);
            this.setCrudOutput(document, true, false, documentIndex, inputDocumentsNumber - 1L);
            ++documentIndex;
        }
        this.statistics.put(INSERT_STAT, inputDocumentsNumber);
    }

    private void integrateCrudUpdate(SpringDataComponent<SpringDataDocumentModel> component, List<SpringDataDocumentModel> inputDocuments, Field idField, JsonDocumentMerger jsonDocumentMerger) throws ElasticSearchException {
        List<String> ids = ElasticSearchOutputStreamIntegratorV8.getIds(idField, inputDocuments);
        HashMap<String, SpringDataDocumentModel> existingDocuments = new HashMap<String, SpringDataDocumentModel>();
        ElasticSearchOutputStreamIntegratorV8.setExistingDocuments(component, ids, existingDocuments);
        long inputDocumentsNumber = inputDocuments.size();
        ArrayList<SpringDataDocumentModel> mergedDocuments = new ArrayList<SpringDataDocumentModel>((int)inputDocumentsNumber);
        int documentIndex = 0;
        while ((long)documentIndex < inputDocumentsNumber) {
            SpringDataDocumentModel document = ElasticSearchOutputStreamIntegratorV8.mergeDocument(idField, jsonDocumentMerger, inputDocuments, existingDocuments, documentIndex, mergedDocuments);
            this.setCrudOutput(document, false, true, documentIndex, inputDocumentsNumber - 1L);
            ++documentIndex;
        }
        component.update(mergedDocuments);
        this.statistics.put(UPDATE_STAT, inputDocumentsNumber);
    }

    private void integrateCrudDelete(SpringDataComponent<SpringDataDocumentModel> component, List<SpringDataDocumentModel> inputDocuments, Field idField) throws ElasticSearchException {
        List<String> ids = ElasticSearchOutputStreamIntegratorV8.getIds(idField, inputDocuments);
        Map<String, Boolean> deletes = component.delete(ids);
        int documentIndex = 0;
        for (boolean deleted : deletes.values()) {
            SpringDataDocumentModel document = inputDocuments.get(documentIndex);
            this.setCrudOutput(document, false, deleted, documentIndex, (long)inputDocuments.size() - 1L);
            ++documentIndex;
        }
        this.statistics.put(DELETE_STAT, Long.valueOf(deletes.size()));
    }

    private void integrateCrudGet(SpringDataComponent<SpringDataDocumentModel> component, List<SpringDataDocumentModel> inputDocuments, Field idField) throws ElasticSearchException {
        List<String> ids = ElasticSearchOutputStreamIntegratorV8.getIds(idField, inputDocuments);
        List<SpringDataDocumentModel> outputDocuments = component.get(ids);
        long outputDocumentsNumber = outputDocuments.size();
        long lastOutputDocumentIndex = outputDocumentsNumber - 1L;
        int documentIndex = 0;
        while ((long)documentIndex < outputDocumentsNumber) {
            SpringDataDocumentModel document = outputDocuments.get(documentIndex);
            this.setCrudOutput(document, false, true, documentIndex, lastOutputDocumentIndex);
            ++documentIndex;
        }
        this.statistics.put(GET_STAT, outputDocumentsNumber);
    }

    private void integrateCrudUpert(SpringDataComponent<SpringDataDocumentModel> component, List<SpringDataDocumentModel> inputDocuments, Field idField, JsonDocumentMerger jsonDocumentMerger) throws ElasticSearchException {
        ArrayList<String> ids = new ArrayList<String>();
        int inputDocumentsNumber = inputDocuments.size();
        if (idField != null) {
            int documentIndex = 0;
            while (documentIndex < inputDocumentsNumber) {
                SpringDataDocumentModel document = inputDocuments.get(documentIndex);
                try {
                    String id = (String)idField.get(document);
                    document.setId(id);
                    if (id != null) {
                        ids.add(id);
                    }
                }
                catch (Exception e) {
                    throw new ElasticSearchException(e);
                }
                ++documentIndex;
            }
        }
        HashMap<String, SpringDataDocumentModel> existingDocuments = new HashMap<String, SpringDataDocumentModel>();
        ElasticSearchOutputStreamIntegratorV8.setExistingDocuments(component, ids, existingDocuments);
        ArrayList<SpringDataDocumentModel> mergedDocuments = new ArrayList<SpringDataDocumentModel>(inputDocumentsNumber);
        int documentIndex = 0;
        while (documentIndex < inputDocumentsNumber) {
            ElasticSearchOutputStreamIntegratorV8.mergeDocument(idField, jsonDocumentMerger, inputDocuments, existingDocuments, documentIndex, mergedDocuments);
            ++documentIndex;
        }
        Map<String, Boolean> upsertResults = component.upsert(mergedDocuments);
        int documentIndex2 = 0;
        long insertCounter = 0L;
        long updateCounter = 0L;
        for (Map.Entry<String, Boolean> upsertEntry : upsertResults.entrySet()) {
            String id = upsertEntry.getKey();
            SpringDataDocumentModel document = (SpringDataDocumentModel)mergedDocuments.get(documentIndex2);
            document.setId(id);
            boolean update = upsertEntry.getValue();
            this.setCrudOutput(document, !update, update, documentIndex2, (long)inputDocumentsNumber - 1L);
            if (update) {
                ++updateCounter;
            } else {
                ++insertCounter;
            }
            ++documentIndex2;
        }
        this.statistics.put(INSERT_STAT, insertCounter);
        this.statistics.put(UPDATE_STAT, updateCounter);
    }

    private void setCrudOutput(SpringDataDocumentModel document, boolean created, boolean found, int documentIndex, long lastDocumentIndex) throws ElasticSearchException {
        this.setDocumentFieldValue(document, this.createdField, created);
        this.setDocumentFieldValue(document, this.foundField, found);
        this.setDocumentFieldValue(document, this.indexdField, this.index);
        String jsonDocument = this.jsonDocumentComposer.composeJsonDocument(document);
        try {
            this.outputStream.write(jsonDocument.getBytes());
            if ((long)documentIndex != lastDocumentIndex) {
                this.outputStream.write(ELEMENT_SEPARATOR_BYTES);
            }
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    private void setDocumentFieldValue(SpringDataDocumentModel document, Field field, Object value) throws ElasticSearchException {
        if (field != null) {
            try {
                field.set(document, value);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
    }

    public void integrateSearch(String rawJsonSchema, String rawQuery, InputStream inputStream, OutputStream outputStream) throws ElasticSearchException {
        try {
            this.preIntegrate(rawJsonSchema, inputStream, outputStream);
            Map<String, Class<? extends SpringDataDocumentModel>> indexDocumentAssociation = this.springDataContextFactory.getIndexDocumentAssociation();
            try {
                outputStream.write(HITS_OPEN);
                this.searchCounter = 0L;
                this.firstLine = true;
                int level = 0;
                String findReplaceQuery = null;
                String keyName = null;
                while (this.jsonDataParser.hasNext()) {
                    JsonParser.Event event = this.jsonDataParser.next();
                    switch (event) {
                        case START_OBJECT: {
                            if (++level != 1) break;
                            findReplaceQuery = rawQuery;
                            break;
                        }
                        case END_OBJECT: {
                            this.integrateSearchEndObject(level, findReplaceQuery, indexDocumentAssociation);
                            --level;
                            break;
                        }
                        case KEY_NAME: {
                            keyName = this.jsonDataParser.getString();
                            break;
                        }
                        case VALUE_FALSE: {
                            findReplaceQuery = ElasticSearchOutputStreamIntegratorV8.findReplaceQuery(level, findReplaceQuery, keyName, "false");
                            break;
                        }
                        case VALUE_TRUE: {
                            findReplaceQuery = ElasticSearchOutputStreamIntegratorV8.findReplaceQuery(level, findReplaceQuery, keyName, "true");
                            break;
                        }
                        case VALUE_STRING: 
                        case VALUE_NUMBER: {
                            String value = this.jsonDataParser.getValue().toString();
                            findReplaceQuery = ElasticSearchOutputStreamIntegratorV8.findReplaceQuery(level, findReplaceQuery, keyName, value);
                        }
                    }
                }
                outputStream.write(HITS_CLOSE);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
            this.statistics.put(SEARCH_STAT, this.searchCounter);
            this.finalizeIntegrate();
        }
        finally {
            this.postIntegrate();
        }
    }

    private void integrateSearchEndObject(int level, String findReplaceQuery, Map<String, Class<? extends SpringDataDocumentModel>> indexDocumentAssociation) throws ElasticSearchException {
        if (level == 1) {
            Query query = new QueryParser(findReplaceQuery).getQuery();
            Iterable<SearchHit<SpringDataDocumentModel>> searchHits = this.configuration.search(query, indexDocumentAssociation, this.indices);
            for (SearchHit<SpringDataDocumentModel> searchHit : searchHits) {
                try {
                    if (this.firstLine) {
                        this.firstLine = false;
                    } else {
                        this.outputStream.write(ELEMENT_SEPARATOR_BYTES);
                    }
                    SpringDataDocumentModel document = (SpringDataDocumentModel)searchHit.getContent();
                    this.index = searchHit.getIndex();
                    String id = searchHit.getId();
                    float score = searchHit.getScore();
                    Field idField = this.springDataContextFactory.getDocumentField(SpringDataKeyword.ID_FIELD);
                    this.setDocumentFieldValue(document, idField, id);
                    Field indexField = this.springDataContextFactory.getDocumentField(INDEX_FIELD);
                    this.setDocumentFieldValue(document, indexField, this.index);
                    Field scoreField = this.springDataContextFactory.getDocumentField(SCORE_FIELD);
                    this.setDocumentFieldValue(document, scoreField, Float.valueOf(score));
                    String jsonDocument = this.jsonDocumentComposer.composeJsonDocument(document);
                    this.outputStream.write(jsonDocument.getBytes());
                }
                catch (Exception e) {
                    throw new ElasticSearchException(e);
                }
                ++this.searchCounter;
            }
        }
    }

    private static String findReplaceQuery(int level, String inputQuery, String searchParameter, String value) {
        String outputQuery;
        if (level == 1 && !HITS_FIELD.equals(searchParameter)) {
            String prefixedParameter = ":" + searchParameter;
            String prefixedValue = ":" + value;
            String suffixedSeparatorParameter = prefixedParameter + ",";
            String suffixedSeparatorValue = prefixedValue + ",";
            String suffixedCloseParameter = prefixedParameter + "}";
            String suffixedCloseValue = prefixedValue + "}";
            outputQuery = inputQuery.replaceAll(suffixedSeparatorParameter, suffixedSeparatorValue).replaceAll(suffixedCloseParameter, suffixedCloseValue);
        } else {
            outputQuery = inputQuery;
        }
        return outputQuery;
    }

    private void preIntegrate(String rawJsonSchema, InputStream inputStream, OutputStream outputStream) throws ElasticSearchException {
        this.outputStream = outputStream;
        this.statistics = new HashMap<String, Long>();
        this.jsonDataParser = null;
        ByteArrayClassLoader.ChildFirst dynamicClassLoader = new ByteArrayClassLoader.ChildFirst(ElasticSearchOutputStreamTransformerV8.ES8_CLASS_LOADER, false, new HashMap());
        try {
            outputStream.write(ARRAY_OPEN_BYTES);
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
        this.jsonSchemaParser = new JsonSchemaParser((ClassLoader)dynamicClassLoader, rawJsonSchema);
        this.configuration = new ElasticSearchConfiguration(this.httpUrl, this.authentication, this.sslContext);
        ElasticsearchClient elasticsearchClient = this.configuration.getElasticsearchClient();
        Map<String, Class<?>> jsonSchema = this.jsonSchemaParser.getParsedJsonSchema();
        this.springDataContextFactory = new SpringDataContextFactory((ClassLoader)dynamicClassLoader, elasticsearchClient, new HashSet<String>(this.indices), jsonSchema);
        Class<? extends SpringDataDocumentModel> abstractDocumentClass = this.springDataContextFactory.getAbstractDocumentClass();
        this.jsonDocumentComposer = new JsonDocumentComposer(abstractDocumentClass, this.jsonSchemaParser.getFieldsElasticJava());
        this.jsonDataParser = Json.createParser((InputStream)inputStream);
    }

    private void finalizeIntegrate() throws ElasticSearchException {
        try {
            this.outputStream.write(ARRAY_CLOSE_BYTES);
            this.outputStream.flush();
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    private void postIntegrate() {
        if (this.jsonDataParser != null) {
            this.jsonDataParser.close();
        }
    }

    private static List<String> getIds(Field idField, List<SpringDataDocumentModel> documents) throws ElasticSearchException {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            for (SpringDataDocumentModel document : documents) {
                String id = (String)idField.get(document);
                ids.add(id);
            }
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
        return ids;
    }

    private static void setExistingDocuments(SpringDataComponent<SpringDataDocumentModel> component, List<String> ids, Map<String, SpringDataDocumentModel> existingDocuments) {
        List<SpringDataDocumentModel> originalDocuments = component.get(ids);
        for (SpringDataDocumentModel document : originalDocuments) {
            existingDocuments.put(document.getId(), document);
        }
    }

    private static SpringDataDocumentModel mergeDocument(Field idField, JsonDocumentMerger documentMerger, List<SpringDataDocumentModel> inputDocuments, Map<String, SpringDataDocumentModel> existingDocuments, int documentIndex, List<SpringDataDocumentModel> mergedDocuments) throws ElasticSearchException {
        SpringDataDocumentModel updateDocument = inputDocuments.get(documentIndex);
        String id = updateDocument.getId();
        if (id == null && idField != null) {
            try {
                id = (String)idField.get(updateDocument);
                updateDocument.setId(id);
            }
            catch (Exception e) {
                throw new ElasticSearchException(e);
            }
        }
        SpringDataDocumentModel originalDocument = existingDocuments.getOrDefault(id, null);
        SpringDataDocumentModel mergedDocument = documentMerger.mergeJsonDocument(originalDocument, updateDocument);
        mergedDocuments.add(mergedDocument);
        return mergedDocument;
    }
}

