/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.json;

import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.common.ReflectUtil;
import com.semarchy.xdi.elasticsearch.json.SpringDataKeyword;
import com.semarchy.xdi.elasticsearch.springdata.SpringDataDocumentModel;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonDocumentComposer {
    private Map<String, String> keywords = new HashMap<String, String>();
    private final Map<Class<?>, Map<String, String>> fieldsJavaElastic = new HashMap();
    public static final String NULL = "null";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ARRAY_OPEN = "[";
    public static final String ARRAY_CLOSE = "]";
    public static final String OBJECT_OPEN = "{";
    public static final String OBJECT_CLOSE = "}";
    public static final String OBJECT_ENTRY = ":";
    public static final String ELEMENT_SEPARATOR = ",";
    public static final String ESCAPED_QUOTE = "\"";

    public JsonDocumentComposer(Class<? extends SpringDataDocumentModel> classDocument, Map<Class<?>, Map<String, String>> fieldsElasticJava) {
        Field[] javaFields;
        Field[] fieldArray = javaFields = classDocument.getFields();
        int n = javaFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field javaField = fieldArray[n2];
            String jsonFieldName = ReflectUtil.getAnnotatedJsonFieldName(javaField);
            if (SpringDataKeyword.contains(jsonFieldName)) {
                String javaFieldName = javaField.getName();
                this.keywords.put(javaFieldName, jsonFieldName);
            }
            ++n2;
        }
        for (Map.Entry<Class<?>, Map<String, String>> fieldsElasticJavaEntry : fieldsElasticJava.entrySet()) {
            Class<?> objectClass = fieldsElasticJavaEntry.getKey();
            HashMap<String, String> fieldJavaElastic = new HashMap<String, String>();
            this.fieldsJavaElastic.put(objectClass, fieldJavaElastic);
            Map<String, String> fieldElasticJava = fieldsElasticJavaEntry.getValue();
            for (Map.Entry<String, String> fieldElasticJavaEntry : fieldElasticJava.entrySet()) {
                String elasticField = fieldElasticJavaEntry.getKey();
                String javaField = fieldElasticJavaEntry.getValue();
                fieldJavaElastic.put(javaField, elasticField);
            }
        }
    }

    public String composeJsonDocument(SpringDataDocumentModel objectDocument) throws ElasticSearchException {
        StringBuilder jsonDocumentBuilder = this.composeJson(objectDocument);
        return jsonDocumentBuilder.toString();
    }

    private StringBuilder composeJson(Object object) throws ElasticSearchException {
        StringBuilder jsonDocumentBuilder = new StringBuilder();
        if (object == null) {
            jsonDocumentBuilder.append(NULL);
        } else {
            Class<?> clazz = object.getClass();
            if (Boolean.class.equals(clazz)) {
                jsonDocumentBuilder.append((Boolean)object != false ? TRUE : FALSE);
            } else if (ReflectUtil.extend(Number.class, clazz)) {
                jsonDocumentBuilder.append(object);
            } else if (String.class.equals(clazz)) {
                jsonDocumentBuilder.append(JsonDocumentComposer.enquote(object.toString()));
            } else if (ReflectUtil.implement(List.class, clazz)) {
                this.composeJsonArray(jsonDocumentBuilder, object);
            } else {
                this.composeJsonObject(jsonDocumentBuilder, object);
            }
        }
        return jsonDocumentBuilder;
    }

    private void composeJsonArray(StringBuilder jsonDocumentBuilder, Object object) throws ElasticSearchException {
        jsonDocumentBuilder.append(ARRAY_OPEN);
        List array = (List)object;
        int elementsNumber = array.size();
        int penultimateElementIndex = elementsNumber - 1;
        int elementIndex = 0;
        while (elementIndex < elementsNumber) {
            Object element = array.get(elementIndex);
            StringBuilder jsonElement = this.composeJson(element);
            jsonDocumentBuilder.append((CharSequence)jsonElement);
            if (elementIndex != penultimateElementIndex) {
                jsonDocumentBuilder.append(ELEMENT_SEPARATOR);
            }
            ++elementIndex;
        }
        jsonDocumentBuilder.append(ARRAY_CLOSE);
    }

    private void composeJsonObject(StringBuilder jsonDocumentBuilder, Object object) throws ElasticSearchException {
        jsonDocumentBuilder.append(OBJECT_OPEN);
        Map<String, Object> fields = ReflectUtil.getFieldsValues(object);
        if (ReflectUtil.extend(SpringDataDocumentModel.class, object)) {
            Set<String> fieldsNames = fields.keySet();
            for (Map.Entry<String, String> fieldEntry : this.keywords.entrySet()) {
                String keywordFieldName = fieldEntry.getKey();
                if (!fieldsNames.contains(keywordFieldName)) continue;
                String keyword = fieldEntry.getValue();
                Object fieldValue = fields.get(keywordFieldName);
                fields.put(keyword, fieldValue);
                fields.remove(keywordFieldName);
            }
            String id = ((SpringDataDocumentModel)object).getId();
            if (id != null) {
                fields.put(SpringDataKeyword.ID_FIELD, id);
            }
        }
        int fieldIndex = 0;
        int lastFieldIndex = fields.size() - 1;
        for (Map.Entry<String, Object> fieldEntry : fields.entrySet()) {
            String javaFieldName = fieldEntry.getKey();
            Class<?> objectClass = object.getClass();
            Map<String, String> fieldsNameJavaElastic = this.fieldsJavaElastic.get(objectClass);
            String elasticFieldName = fieldsNameJavaElastic == null ? javaFieldName : fieldsNameJavaElastic.get(javaFieldName);
            jsonDocumentBuilder.append(JsonDocumentComposer.enquote(elasticFieldName));
            jsonDocumentBuilder.append(OBJECT_ENTRY);
            Object fieldValue = fieldEntry.getValue();
            StringBuilder jsonField = this.composeJson(fieldValue);
            jsonDocumentBuilder.append((CharSequence)jsonField);
            if (fieldIndex != lastFieldIndex) {
                jsonDocumentBuilder.append(ELEMENT_SEPARATOR);
            }
            ++fieldIndex;
        }
        jsonDocumentBuilder.append(OBJECT_CLOSE);
    }

    public static String enquote(String rawString) {
        return ESCAPED_QUOTE + rawString + ESCAPED_QUOTE;
    }
}

